%! PS-Adobe-2.0
%% for GhostScript 2.0
%% Program for reading a single-page .ps file and writing out a PPM file.
%% Original version by Phillip Conrad - Perfect Byte, Inc.
%% Modified 06/26/90 for a color file
%% Modified on 08/02/90 for using the CORRECT color map.
%% Modified by L. Peter Deutsch -- Aladdin Enterprises -- 08/02/90
%% Modified by L. Peter Deutsch -- Aladdin Enterprises -- 08/25/90 --
%%   converted from a one-shot program to a utility package,
%%   designed to be used from an interactive terminal.
%% Modified by Henry Minsky 11/03/90
%%   for each showpage, it writes out a ppm file with name filenameN.ppm
%%   where N increments each showpage, starting at 1
%%
%% NOTE: This will ONLY work for programs with at most ONE(1) showpage.
%%       If you have multiple showpage commands only the FIRST one is
%%       recognized.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%% Define the directory for holding the PPM information

/ppmdict 25 dict def
ppmdict begin

  /Horz_dpi 205 def		% g3 high res mode is slightly higher res
  /Vert_dpi  196 def		% horizontally than vertically

  /OutFileDir () def		% default to current directory

  /Palette1 [1 1 1 rgbcolor 0 0 0 rgbcolor] def

  % Redefine showpage appropriately
  /showpage
   { ppmdict begin
       WrotePage not {
       OutFileDir OutFileName concatstrings 

       /FileNameOUT exch def		% outfile name 
       /FileDescOUT FileNameOUT (w) file def
       (Writing ) print FileNameOUT print (\n) print
       flush

       FileDescOUT Device writeppmfile
       FileDescOUT closefile
       /WrotePage true def
      } if       
     end
   } def

  /Convert			% the main procedure
  				% <filename> <palette> Convert -
   { /Palette exch def
     /FileName exch def

     /ScaleX Horz_dpi 72 div def
     /ScaleY Vert_dpi 72 div def

     /Width 85 Horz_dpi mul 5 add 10 div cvi def % add 5 to round up!
     /Height 11 Vert_dpi mul def

     FileName
       /FileNameIN exch def		% file name with extension
     /FileDescIN  0 def

     /NScaleX ScaleX neg def
     /NScaleY ScaleY neg def

     [ScaleX 0.0 0.0 NScaleY 0.0 Height]
     Width Height Palette makeimagedevice
       /Device exch def
     Device setdevice

     /WrotePage false def

     % Put userdict back on top of the dict stack
     /topstate save def

     userdict begin
     FileNameIN run
     end			% userdict
     WrotePage not { showpage } if	% make sure the page got written
     end			% ppmdict

   } def

end				% ppmdict

%%%%%% Define the user-callable procedures

/ppmsetdensity
 { ppmdict begin
   /Vert_dpi exch def
   /Horz_dpi exch def
   end
 } def

/ppmsetppmdir
 { ppmdict begin
   /OutFileDir exch def
   end
 } def

/ppm1run
 { ppmdict begin   Palette1 Convert
 } def

/OutFileName (junk.ppm) def    % the user is supposed to override this

flush
