/* Standalone fax send program stub.
 *
 * This opens the serial_port and then calls the faxsend routine to
 * send the g3 fax files.
 *
 * 
 * usage: faxsend phone-number g3-filename1 g3-filename2 ...
 *
 * This opens a connection, and then sends each g3 format file
 * successively, one document page per file. This assumes exactly 
 * 1728 pixels per line. Page length is variable. 
 *
 * The files must be in raw 1-d huffman coded g3 fax format.
 * For the fax data specs, see  CCITT recommendation T.30 (Blue Book)
 *
 *
 * EXIT CODES:
 * 0    fax sent
 * 1    can't synchronize with modem
 * 2    NO DIALTONE
 * 3    NO CARRIER
 * 4    ERROR 	  
 * 6    NO_DIALTONE    
 * 7    BUSY
 * 8    NO_ANSWER
 *
 * Henry Minsky 11/02/90
 * hqm@ai.mit.edu
 *
 * Trying the SCCS system out. 2/3/91
 */

#include <stdio.h>
#include <fcntl.h>
#include <strings.h>

extern void exit();

#include "../include/conf.h"

extern int faxsend();
extern int tty_raw_mode_out();

main(argc, argv)
int argc;
char *argv[];
{
  int serial_fd;
  char *dialstring;

  if (argc < 3) {
    fprintf(stderr, 
	    "usage: sendfax phone-number g3-file1 g3-file2 ...\n");
    exit(1);
  }

  dialstring = argv[1];

  serial_fd = open(SERIAL_PORT, O_RDWR);
  if (serial_fd < 0)
    {perror("sendfax couldn't open serial line "); exit(1);}
  
  if (tty_raw_mode_out(serial_fd) < 0) {
    fprintf(stderr, "couldn't put device in raw mode\n");
    exit(1); 
  }

  exit(faxsend(dialstring, argc-2, &argv[2], serial_fd));


}
