/*
  fax.c

  The file is part of the MIT Artificial Intelligence Laboratory's
  Netfax automatic fax transmission system.

  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
  to anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer
  to the General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute
  Netfax, but only under the conditions described in the Netfax
  General Public License.  A copy of this license is supposed to have been
  given to you along with Netfax so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.

v  (c) Copyright 1990 by Henry Minsky and David M. Siegel.
      All rights reserved.

  Sun Nov 4, 1990 at 11:16:34
*/

#include <stdio.h>
#include <pwd.h>
#include "../include/conf.h"

#define TRUE 1
#define FALSE 0

main(argc,argv)
int argc;
char *argv[];
{
    char buf[BUFSIZ];
    int is_postscript = FALSE;
    int is_dvi = FALSE;
    int mail_notification = TRUE;
    int coversheet = TRUE;
    int g3file = FALSE;
    char cmd[BUFSIZ];
    char hostname[128];
    char filename[128];
    struct passwd *pwd;
    int count;
    FILE *fp;
    FILE *in = stdin;
    char *phone;
    char *returnfax = "";
    char *recipient = "";
    char *username = NULL;
    char *font = ENSCRIPT_FONT;
    int c;
    int errflg = FALSE;
    extern char *optarg;
    extern int optind;

    umask(0);
      
    while ((c = getopt(argc, argv, "u:r:p:f:dmcg")) != -1)
      switch (c) {
	case 'u':
	  username = optarg;
	  break;

	case 'r':
	  recipient = optarg;
	  break;

	case 'f':
	  font = optarg;
	  break;
	
	case 'p':
	  returnfax = optarg;
	  break;

	case 'd':
	  is_dvi = TRUE;
	  break;

	case 'm':
	  mail_notification = FALSE;
	  break;

	case 'c':
	  coversheet = FALSE;
	  break;

	case 'g':
	  g3file = TRUE;
	  break;
	
	case '?':
	  errflg = TRUE;;
	  break;
      }

    if (errflg || optind >= argc) {
	fprintf(stderr, 
  "usage: %s [-p returnfax] [-r recipient] [-f font] [-c] [-g] [-d] [-m] phone [file]\n",
		argv[0]);
	exit(1);
    }

    phone = argv[optind++];

/*
  This security check makes it impossible to have your mail forwarded
  to a fax machine, because the mailer insists on invoking 'fax' with the uid
  of the sender if it is a local message. 
 */
/*    if (username != NULL) {
	int uid = getuid();
	if ((pwd = getpwnam(username)) == NULL) {
	    fprintf(stderr, "unknown user\n");
	    exit(1);
	}
 	if ((pwd->pw_uid != uid) && (pwd->pw_uid != 0) && (uid != 1)) {
 	    fprintf(stderr, "permission denied (uid=%d)\n", uid);
 	    exit(1);
 	}
     } else
 */
   pwd = getpwuid(getuid());

    if (pwd == NULL) {
	fprintf(stderr, "can't figure out who you are\n");
	exit(1);
    }

    if (optind < argc) {
	if ((in = fopen(argv[optind], "r")) == NULL) {
	    fprintf(stderr, "can't open input file: %s\n", argv[optind]);
	    exit(1);
	}
    }
	
    if (gethostname(hostname, sizeof(hostname)) < 0) {
	perror("gethostname");
	exit(1);
    }
    sprintf(filename, "%s/%s-XXXXXX",SPOOLDIR, hostname);
    mktemp(filename);

    /*
      Write out the postscript file:
      */
    while ((count = fread(buf, 1, sizeof(buf), in)) > 0) {
	if (fp == NULL) {
	  /* Is it a raw g3 fax file? */
	  if (g3file) {
	    sprintf(cmd, "%s.g3.1", filename);
	    if ((fp = fopen(cmd, "w")) == NULL) {
	      perror("fopen");
	      exit(1);
	    }
	  } else if (is_dvi) {
	    sprintf(cmd, "%s.dvi", filename);
	    if ((fp = fopen(cmd, "w")) == NULL) {
	      perror("fopen");
	      exit(1);
	    }
	  } else {
	    if (strncmp(buf, "%!", 2) == 0) {
	      is_postscript = TRUE;
	      sprintf(cmd, "%s.ps", filename);
	      if ((fp = fopen(cmd, "w")) == NULL) {
		perror("fopen");		    
		exit(1);
	      }
	    } else {
	      is_postscript = FALSE;
	      if (USE_ENSCRIPT) {
		sprintf(cmd, "%s %s -f%s -p%s.ps", 
			ENSCRIPT, ENSCRIPT_OPTIONS, font, filename);
		if ((fp = popen(cmd, "w")) == NULL) {
		  perror("popen enscript");
		  exit(1);
		} 
	      } else 
		if (USE_PSIFY) {
		  sprintf(cmd, "%s -fb%s > %s.ps", 
			  PSIFY, font, filename);
		  if ((fp = popen(cmd, "w")) == NULL) {
		    perror("popen psify");
		    exit(1);
		  }
		} else {
		  fprintf(stderr, 
			  "What program do I use to create postscript with?");
		  exit(1);
		}
	    }
	  }
	}
	fwrite(buf, 1, count, fp);
    }

    if (is_postscript || is_dvi || g3file)
      fclose(fp);
    else
      pclose(fp);

    if (is_dvi) {
	sprintf(cmd, "%s -a %s %s.dvi > %s.ps", DVI2PS, DVIFONT, 
		filename, filename);
	if (system(cmd) != 0) {
	    fprintf(stderr, "dvi2ps failed\n");
	    exit(1);
	}
	sprintf(cmd, "%s.dvi", filename);
	unlink(cmd);
    }

    /*
      Write out queue file:
    */
    sprintf(cmd, "%s.qf", filename);
    if ((fp = fopen(cmd, "w")) == NULL) {
	fprintf(stderr, "can't open queue file\n");
	exit(1);
    }

    fprintf(fp, "USER: %s\n", pwd->pw_name);
    fprintf(fp, "SENDER: %s\n", pwd->pw_gecos);
    fprintf(fp, "RECIPIENT: %s\n", recipient);
    fprintf(fp, "RETURNFAX: %s\n", returnfax);
    if (!mail_notification) 
      fprintf(fp, "NOMAIL: 1\n");
    if (!coversheet || g3file) 
      fprintf(fp, "NOCOVER: 1\n");
    fprintf(fp, "PHONE: %s\n", phone);
    fclose(fp);

    exit(0);
}
