.TH PSIFY 1 "15 JANUARY 1988"
.UC 4
.SH NAME
psify \- pretty print C, C++, LISP, CLU, and ARGUS source files for
P\s-2OST\s+2S\s-2CRIPT\s+2
printers
.SH SYNOPSIS
.B psify
[options] [file] ...
.SH DESCRIPTION
.IR Psify
is similar to
.IR pressify ,
a program that converted ASCII files to PRESS format to be printed on the Dover.
However,
.IR psify
converts files to P\s-2OST\s+2S\s-2CRIPT\s+2 format for printing on a
P\s-2OST\s+2S\s-2CRIPT\s+2 printer.
.IR Psify
will work with any ASCII file, but is meant for printing C, C++, LISP, CLU, and ARGUS
programs.  It uses the file name extension to determine how to print a file.
".c" and ".h" are assumed to be C,
".C", ".cc", ".CXX", ".cpp", ".cxx", ".hpp", ".hxx", and ".h++" are
assumed to be C++,
".lisp" and ".lsp" are assumed to be Lisp,
".clu" is CLU,
".arg" is ARGUS,
and anything else is printed as plain text.
For C, C++ CLU, and ARGUS, comments and reserved
words are printed in different fonts
to make the listings easier to read.
For Lisp, comments are printed in a different font.
By default, comments are printed in italics and reserved words are printed in bold.
.PP
If no files are given on the command line,
.IR psify
will read from standard input.  Also,
.IR psify
always produces output on standard output.
Normally, the output should be piped to
.IR lpr
in order to actually produce a printout.
.sp
Options are:
.TP
.BI \-fb font
sets the normal body font.  Default is Courier10.  The size may be
specified with the font (all one word).  If it is omitted, the
default size will be used.
.TP
.BI \-fh font
sets font for page headers.  Default is Times-BoldItalic12.
.TP
.BI \-fr font
sets font for reserved words (for program source files).  Default is
Courier-Bold10.
.TP
.BI \-fc font
sets font for comments (for program source files).  Default is
Courier-Oblique10.
.TP
.BI \-fa font
sets font for body, reserved words, and comments to the font
specified.
.TP
.BI \-sz number
if
.IR number
is greater than zero, this option forces the body, comment, and reserved
fonts to all be this size.
Lets you just change the size of the fonts used without specifying each
font individually.
.TP
.BI \-lm number
sets left margin in
.I
points.
Default is 72 (one inch).
.TP
.BI \-tm number
sets top margin in points.  Default is 36.  Note that the page header
is printed in the top margin, so that if it is made too small, the
header will disappear.
.TP
.BI \-bm number
sets bottom margin in points.  Default is 36.
.TP
.BI \-clu
forces all files to be printed as if they were CLU source files.
.TP
.BI \-c
forces all files to be printed as if they were C source files.
.TP
.BI \-c++
forces all files to be printed as if they were C++ source files.
.TP
.BI \-lisp
forces all files to be printed as if they were Lisp source files.
.TP
.BI \-arg
forces all files to be printed as if they were ARGUS source files.
.TP
.BI \-text
forces all files to be printed as plain text files.
.TP
.BI \-h [text]
if
.IR text
is null, no page headers are printed.  Otherwise, the file
name that is usually in the page header is replaced by
.IR text .
.TP
.BI \-
ends options.  Allows a file whose name starts with '-' to be printed.
.SH DIAGNOSTICS
Aborts if given an unknown option.  Prints a message if it cannot open
a file (the other files on the command line will still be printed).
.SH AUTHOR
Andrew Heybey, atheybey@ptt.lcs.mit.edu
.SH BUGS
None known.
.SH NOTES
The input is parsed using a hairy
.IR lex
file.  Other languages could be implemented without too many problems,
but I felt no pressing need to do so.
.PP
For CLU and ARGUS, the reserved words
.IR true,
.IR false,
and
.IR nil,
are not printed in bold because they are literals.
