%e 3000
%p 6500
%k 3000
%a 8000
%n 2000
%o 8000

%{
#define NORM_STATE 1
#define COMMENT_STATE 2		/* A delimited comment */
#define QUOTE_STATE 3		/* Double-quote delimited string */
#define SQUOTE_STATE 4		/* Single-quote delimited string */
#define EOL_COMMENT_STATE 5	/* A comment that continues until the end of line */

int state = NORM_STATE;
int pagenum, masterpagenum;
int linenum;
int paren_open = 0;
int preproc = 0;
int filename = 0;
int newpage;

int cxx_mode = 0;		/* c++ submode of C mode */

extern int max_lines;
extern int type;
extern int starting;
extern char name[], date[];

#include "filetypes.h"

%}

%Start C CLU PLAIN ARG LISP

a [aA]
b [bB]
c [cC]
d [dD]
e [eE]
f [fF]
g [gG]
h [hH]
i [iI]
j [jJ]
k [kK]
l [lL]
m [mM]
n [nN]
o [oO]
p [pP]
q [qQ]
r [rR]
s [sS]
t [tT]
u [uU]
v [vV]
w [wW]
x [xX]
y [yY]
z [zZ]

%%
<C>\014 |
<CLU>\014 |
<LISP>\014 |
<PLAIN>\014	{		/* Handle form feeds */
		  switch (state)  {
		    case QUOTE_STATE:
		    case SQUOTE_STATE:
		        default_handler();
			break;
		    default:
			makenewpage();
			if (paren_open)  {
			  fprintf(yyout, ") show ");
			  paren_open = 0;
			}
			fprintf(yyout, " showpage restore\n");
			newpage = 1;
			filename = preproc = 0;
			break;
		  }
		}
<C>\t+ |
<CLU>\t+ |
<LISP>\t+ |
<PLAIN>\t+ |
<ARG>\t+	{
		  makenewpage();
		  if (paren_open)  {
		    fprintf(yyout, ") show\n");
		    paren_open = 0;
		  }
		  fprintf(yyout, " %d dotab\n", yyleng);
		}

<C>\/\/		{ if ( cxx_mode )
		    eol_comment_marker();
		  else
		    default_handler();
		}
<C>asm |
<C>catch |
<C>const |
<C>friend |
<C>inline |
<C>operator |
<C>private |
<C>public |
<C>template |
<C>throw |
<C>try |
<C>virtual |
<C>volatile |
<C>class |
<C>new |
<C>delete |
<C>void |
<C>this		{ if ( cxx_mode )
		    keyword();
		  else
		    default_handler();
		}

<C>^\#[a-zA-Z_][a-zA-Z0-9_]*  {
		if (state == NORM_STATE)  {
		  makenewpage();
		  preproc = 1;
		  paren_open = 1;
		  fprintf(yyout, "(");
		  ECHO;
		} else
		default_handler();
		}
<C>\\\"		{ newparen();  fprintf(yyout, "\\\\\"");}
<C>\"		{ double_quote(); }
<C>\'		{
		  default_handler();
		  switch (state)  {
		    case NORM_STATE:
			state = SQUOTE_STATE;
			break;
		    case SQUOTE_STATE:
			state = NORM_STATE;
			break;
		    default:
			break;
		  }
		}
<C>"("		{newparen(); fprintf(yyout, "\\(");}
<C>")"		{newparen(); fprintf(yyout, "\\)");}
<C>\\		{newparen(); fprintf(yyout, "\\\\");}
<C>"<"		{ newparen();
		  if (preproc)
		    filename = 1;
		  ECHO;
		}
<C>">"		{ newparen();
		  if (preproc && filename)
		    filename = 0;
		  ECHO;
		}
<C>\n		{
		end_of_line();
		filename = preproc = 0;
		}
<C>.		{ default_handler(); }
<C>"/*"		{ comment_start(); }
<C>"*/"		{ comment_end(); }
<C>int |
<C>char |
<C>float |
<C>double |
<C>struct |
<C>union |
<C>long |
<C>short |
<C>unsigned |
<C>auto |
<C>extern |
<C>register |
<C>typedef |
<C>static |
<C>goto |
<C>return |
<C>sizeof |
<C>break |
<C>continue |
<C>if |
<C>else |
<C>enum |
<C>for |
<C>do |
<C>while |
<C>switch |
<C>case |
<C>default |
<C>entry	{ keyword(); }
<C>[a-zA-Z_][a-zA-Z_0-9]*	{ default_handler(); }

<CLU>\\\"	{ newparen();  fprintf(yyout, "\\\\\"");}
<CLU>\"		{ newparen();
		  ECHO;
		  switch (state)  {
		  case NORM_STATE:
			state = QUOTE_STATE;
			break;
		  case QUOTE_STATE:
			state = NORM_STATE;
			break;
		  default:
			break;
		}}
<CLU>\'		{
		  newparen();
		  ECHO;
		  switch (state)  {
		    case NORM_STATE:
			state = SQUOTE_STATE;
			break;
		    case SQUOTE_STATE:
			state = NORM_STATE;
			break;
		    default:
			break;
		  }
		}
<CLU>"("	{newparen(); fprintf(yyout, "\\(");}
<CLU>")"	{newparen(); fprintf(yyout, "\\)");}
<CLU>\\		{newparen(); fprintf(yyout, "\\\\");}
<CLU>\n		{
		makenewpage();
		if (paren_open)  {
		  fprintf(yyout, ") show ");
		  paren_open = 0;
		}
		fprintf(yyout, " newline\n");
		if (state == COMMENT_STATE)  {
		  state = NORM_STATE;
		  fprintf(yyout, "normfont\n");
		}
		if (++linenum >= max_lines)  {
		  fprintf(yyout, " showpage restore\n");
		  newpage = 1;
		}
		}
<CLU>"%"	{ makenewpage();
		  switch (state)  {
		    case NORM_STATE:
			state = COMMENT_STATE;
			if (paren_open)
			  fprintf(yyout, ") show\n");
			fprintf(yyout, "commentfont (%%");
			paren_open = 1;
			break;
		    default:
			newparen();
			ECHO;
			break;
		}}
<CLU>.		{newparen(); ECHO;}
<CLU>{p}{r}{o}{c} |
<CLU>{e}{n}{d} |
<CLU>{i}{t}{e}{r} |
<CLU>{c}{l}{u}{s}{t}{e}{r} |
<CLU>{t}{y}{p}{e} |
<CLU>{r}{e}{t}{u}{r}{n}{s} |
<CLU>{y}{i}{e}{l}{d}{s} |
<CLU>{s}{i}{g}{n}{a}{l}{s} |
<CLU>{w}{h}{e}{r}{e} |
<CLU>{h}{a}{s} |
<CLU>{i}{n} |
<CLU>{r}{e}{p} |
<CLU>{o}{w}{n} |
<CLU>{n}{u}{l}{l} |
<CLU>{b}{o}{o}{l} |
<CLU>{i}{n}{t} |
<CLU>{r}{e}{a}{l} |
<CLU>{c}{h}{a}{r} |
<CLU>{s}{t}{r}{i}{n}{g} |
<CLU>{a}{n}{y} |
<CLU>{c}{v}{t} |
<CLU>{a}{r}{r}{a}{y} |
<CLU>{s}{e}{q}{u}{e}{n}{c}{e} |
<CLU>{r}{e}{c}{o}{r}{d} |
<CLU>{s}{t}{r}{u}{c}{t} |
<CLU>{o}{n}{e}{o}{f} |
<CLU>{v}{a}{r}{i}{a}{n}{t} |
<CLU>{p}{r}{o}{c}{t}{y}{p}{e} |
<CLU>{i}{t}{e}{r}{t}{y}{p}{e} |
<CLU>{w}{h}{i}{l}{e} |
<CLU>{d}{o} |
<CLU>{f}{o}{r} |
<CLU>{i}{f} |
<CLU>{t}{h}{e}{n} |
<CLU>{e}{l}{s}{e}{i}{f} |
<CLU>{e}{l}{s}{e} |
<CLU>{t}{a}{g}{c}{a}{s}{e} |
<CLU>{o}{t}{h}{e}{r}{s} |
<CLU>{r}{e}{t}{u}{r}{n} |
<CLU>{y}{i}{e}{l}{d} |
<CLU>{s}{i}{g}{n}{a}{l} |
<CLU>{e}{x}{i}{t} |
<CLU>{b}{r}{e}{a}{k} |
<CLU>{c}{o}{n}{t}{i}{n}{u}{e} |
<CLU>{b}{e}{g}{i}{n} |
<CLU>{r}{e}{s}{i}{g}{n}{a}{l} |
<CLU>{e}{x}{c}{e}{p}{t} |
<CLU>{t}{a}{g} |
<CLU>{w}{h}{e}{n} |
<CLU>{c}{a}{n}{d} |
<CLU>{c}{o}{r} |
<CLU>{f}{o}{r}{c}{e} |
<CLU>{u}{p} |
<CLU>{i}{s} |
<CLU>{d}{o}{w}{n}	{
		makenewpage();
		if (state == NORM_STATE && !filename)  {
		  if (paren_open)
		    fprintf(yyout, ") show\n");
		  fprintf(yyout, "reservefont (%s) show \nnormfont ", yytext);
		  if (paren_open)
		    fprintf(yyout, "(");
		} else
		  {newparen(); ECHO;}
		}
<CLU>[a-zA-Z_][a-zA-Z_0-9]*	{
		newparen();
		ECHO;
		}

<ARG>\\\"	{ newparen();  fprintf(yyout, "\\\\\"");}
<ARG>\"		{ newparen();
		  ECHO;
		  switch (state)  {
		  case NORM_STATE:
			state = QUOTE_STATE;
			break;
		  case QUOTE_STATE:
			state = NORM_STATE;
			break;
		  default:
			break;
		}}
<ARG>\'		{
		  newparen();
		  ECHO;
		  switch (state)  {
		    case NORM_STATE:
			state = SQUOTE_STATE;
			break;
		    case SQUOTE_STATE:
			state = NORM_STATE;
			break;
		    default:
			break;
		  }
		}
<ARG>"("	{newparen(); fprintf(yyout, "\\(");}
<ARG>")"	{newparen(); fprintf(yyout, "\\)");}
<ARG>\\		{newparen(); fprintf(yyout, "\\\\");}
<ARG>\n		{
		makenewpage();
		if (paren_open)  {
		  fprintf(yyout, ") show ");
		  paren_open = 0;
		}
		fprintf(yyout, " newline\n");
		if (state == COMMENT_STATE)  {
		  state = NORM_STATE;
		  fprintf(yyout, "normfont\n");
		}
		if (++linenum >= max_lines)  {
		  fprintf(yyout, " showpage restore\n");
		  newpage = 1;
		}
		}
<ARG>"%"	{ makenewpage();
		  switch (state)  {
		    case NORM_STATE:
			state = COMMENT_STATE;
			if (paren_open)
			  fprintf(yyout, ") show\n");
			fprintf(yyout, "commentfont (%%");
			paren_open = 1;
			break;
		    default:
			newparen();
			ECHO;
			break;
		}}
<ARG>.		{newparen(); ECHO;}
<ARG>{p}{r}{o}{c} |
<ARG>{e}{n}{d} |
<ARG>{i}{t}{e}{r} |
<ARG>{c}{l}{u}{s}{t}{e}{r} |
<ARG>{t}{y}{p}{e} |
<ARG>{r}{e}{t}{u}{r}{n}{s} |
<ARG>{y}{i}{e}{l}{d}{s} |
<ARG>{s}{i}{g}{n}{a}{l}{s} |
<ARG>{w}{h}{e}{r}{e} |
<ARG>{h}{a}{s} |
<ARG>{i}{n} |
<ARG>{i}{s} |
<ARG>{r}{e}{p} |
<ARG>{o}{w}{n} |
<ARG>{n}{u}{l}{l} |
<ARG>{b}{o}{o}{l} |
<ARG>{i}{n}{t} |
<ARG>{r}{e}{a}{l} |
<ARG>{c}{h}{a}{r} |
<ARG>{s}{t}{r}{i}{n}{g} |
<ARG>{a}{n}{y} |
<ARG>{c}{v}{t} |
<ARG>{a}{r}{r}{a}{y} |
<ARG>{s}{e}{q}{u}{e}{n}{c}{e} |
<ARG>{r}{e}{c}{o}{r}{d} |
<ARG>{s}{t}{r}{u}{c}{t} |
<ARG>{o}{n}{e}{o}{f} |
<ARG>{v}{a}{r}{i}{a}{n}{t} |
<ARG>{p}{r}{o}{c}{t}{y}{p}{e} |
<ARG>{i}{t}{e}{r}{t}{y}{p}{e} |
<ARG>{w}{h}{i}{l}{e} |
<ARG>{d}{o} |
<ARG>{f}{o}{r} |
<ARG>{i}{f} |
<ARG>{t}{h}{e}{n} |
<ARG>{e}{l}{s}{e}{i}{f} |
<ARG>{e}{l}{s}{e} |
<ARG>{t}{a}{g}{c}{a}{s}{e} |
<ARG>{o}{t}{h}{e}{r}{s} |
<ARG>{r}{e}{t}{u}{r}{n} |
<ARG>{y}{i}{e}{l}{d} |
<ARG>{s}{i}{g}{n}{a}{l} |
<ARG>{e}{x}{i}{t} |
<ARG>{b}{r}{e}{a}{k} |
<ARG>{c}{o}{n}{t}{i}{n}{u}{e} |
<ARG>{b}{e}{g}{i}{n} |
<ARG>{r}{e}{s}{i}{g}{n}{a}{l} |
<ARG>{e}{x}{c}{e}{p}{t} |
<ARG>{t}{a}{g} |
<ARG>{w}{h}{e}{n} |
<ARG>{c}{a}{n}{d} |
<ARG>{c}{o}{r} |
<ARG>{f}{o}{r}{c}{e} |
<ARG>{u}{p} |
<ARG>{d}{o}{w}{n} |
<ARG>{a}{b}{o}{r}{t} |
<ARG>{a}{c}{t}{i}{o}{n} |
<ARG>{a}{t}{o}{m}{i}{c}_{a}{r}{r}{a}{y} |
<ARG>{a}{t}{o}{m}{i}{c}_{r}{e}{c}{o}{r}{d} |
<ARG>{a}{t}{o}{m}{i}{c}_{v}{a}{r}{i}{a}{n}{t} |
<ARG>{b}{a}{c}{k}{g}{r}{o}{u}{n}{d} |
<ARG>{b}{i}{n}{d} |
<ARG>{c}{o}{e}{n}{t}{e}{r} |
<ARG>{c}{r}{e}{a}{t}{o}{r} |
<ARG>{c}{r}{e}{a}{t}{o}{r}{t}{y}{p}{e} |
<ARG>{e}{n}{t}{e}{r} |
<ARG>{e}{q}{u}{a}{t}{e}{s} |
<ARG>{f}{o}{r}{k} |
<ARG>{g}{u}{a}{r}{d}{i}{a}{n} |
<ARG>{h}{a}{n}{d}{l}{e}{r} |
<ARG>{h}{a}{n}{d}{l}{e}{r}{t}{y}{p}{e} |
<ARG>{h}{a}{n}{d}{l}{e}{s} |
<ARG>{i}{m}{a}{g}{e} |
<ARG>{l}{e}{a}{v}{e} |
<ARG>{m}{u}{t}{e}{x} |
<ARG>{n}{o}{d}{e} |
<ARG>{p}{a}{u}{s}{e} |
<ARG>{p}{r}{o}{c}{e}{s}{s} |
<ARG>{r}{e}{c}{o}{v}{e}{r} |
<ARG>{s}{e}{i}{z}{e} |
<ARG>{s}{e}{l}{f} |
<ARG>{s}{t}{a}{b}{l}{e} |
<ARG>{t}{a}{g}{t}{e}{s}{t} |
<ARG>{t}{a}{g}{w}{a}{i}{t} |
<ARG>{t}{e}{r}{m}{i}{n}{a}{t}{e} |
<ARG>{t}{o}{p}{a}{c}{t}{i}{o}{n} |
<ARG>{t}{r}{a}{n}{s}{m}{i}{t} |
<ARG>{w}{t}{a}{g}	{ keyword(); }
<ARG>[a-zA-Z_][a-zA-Z_0-9]*	{
		newparen();
		ECHO;
		}

<LISP>\n	{ end_of_line(); }
<LISP>;		{ eol_comment_marker(); }
<LISP>"#|"	{ comment_start(); }
<LISP>"|#"	{ comment_end(); }
<LISP>\"	{ double_quote(); }
<LISP>\\\"	{ default_handler(); }
<LISP>#\\.	{ default_handler(); }
<LISP>"("	{ special_char(); }
<LISP>")"	{ special_char(); }
<LISP>\\	{ newparen(); fprintf(yyout, "\\\\"); }
<LISP>.		{ newparen(); ECHO; }


<PLAIN>"("	{newparen(); fprintf(yyout, "\\(");}
<PLAIN>")"	{newparen(); fprintf(yyout, "\\)");}
<PLAIN>\\	{newparen(); fprintf(yyout, "\\\\");}
<PLAIN>\n	{
		makenewpage();
		if (paren_open)  {
		  fprintf(yyout, ") show ");
		  paren_open = 0;
		}
		fprintf(yyout, " newline\n");
		if (++linenum >= max_lines)  {
		  fprintf(yyout, " showpage restore\n");
		  newpage = 1;
		}
		}
<PLAIN>.	{newparen(); ECHO;}

.		{
		  if (starting)  {
		    switch (type)  {
		      case C_FILE_TYPE:
			BEGIN C;
			break;
		      case CXX_FILE_TYPE:
			cxx_mode = 1;
			BEGIN C;
			break;
		      case CLU_FILE_TYPE:
			BEGIN CLU;
			break;
		      case ARGUS_FILE_TYPE:
			BEGIN ARG;
			break;
		      case LISP_FILE_TYPE:
			BEGIN LISP;
			break;
		      case PLAIN_FILE_TYPE:
		      default:
			BEGIN PLAIN;
			break;
		    }
		    starting = 0;
		    paren_open = 0;
		    filename = 0;
		    preproc = 0;
		    state = NORM_STATE;
		    newpage = 1;
		    pagenum = 0;
		  }
		  yyless(0);
		}
%%
yywrap()
{
	if (paren_open)
	  fprintf(yyout, ") show\n");
	fprintf(yyout, " normfont\n");
	if (!newpage)
	  fprintf(yyout, "showpage restore\n");
	BEGIN 0;
	return(1);
}

newparen()
{
  makenewpage();
  if (!paren_open)  {
    fprintf(yyout, "(");
    paren_open = 1;
  }
}

makenewpage()
{
  if (newpage)  {
    pagenum++;
    masterpagenum++;
    linenum = 0;
    fprintf(yyout, "\n%%%%Page: %d %d\n", pagenum, masterpagenum);
    fprintf(yyout, "save 0 setlinewidth\n");
    fprintf(yyout, "%d (%s) (%s) makeheader\n", pagenum, name, date);
    switch(state)  {
	case NORM_STATE:
	case QUOTE_STATE:
	case SQUOTE_STATE:
		fprintf(yyout, "normfont\n");
		break;
	case COMMENT_STATE:
		fprintf(yyout, "commentfont\n");
		break;
    }
    newpage = 0;
  }
}

comment_start()
{
  makenewpage();
  switch (state)
    {
    case NORM_STATE:
      state = COMMENT_STATE;
      if (paren_open) {
	fprintf(yyout, ") show ");
	paren_open = 0;
      }
      fprintf(yyout, "commentfont ");
      break;
    default:
      break;
    }
  newparen();
  ECHO;
}

comment_end()
{
  newparen();
  ECHO;
  switch (state)
    {
    case COMMENT_STATE:
      state = NORM_STATE;
      fprintf(yyout, ") show ");
      paren_open = 0;
      fprintf(yyout, "normfont ");
      break;
    default:
      break;
    }
}

eol_comment_marker()
{
  switch (state)
    {
    case NORM_STATE:
      state = EOL_COMMENT_STATE;
      if (paren_open) {
	fprintf(yyout, ") show ");
	paren_open = 0;
      }
      fprintf(yyout, "commentfont ");
      break;
    default:
      break;
    }
  newparen();
  ECHO;
}

end_of_line()
{
  makenewpage();
  if (paren_open) {
    fprintf(yyout, ") show ");
    paren_open = 0;
  }
  fprintf(yyout, " newline\n");
  if (++linenum >= max_lines)  {
    fprintf(yyout, " showpage restore\n");
    newpage = 1;
  }
  switch (state) {
  case EOL_COMMENT_STATE:
    fprintf(yyout, "normfont ");
    state = NORM_STATE;
    break;
  default:
    break; }
}

keyword()
{
  makenewpage();
  if (state == NORM_STATE && !filename)
    {
      if (paren_open)
	fprintf(yyout, ") show\n");
      fprintf(yyout, "reservefont (%s) show \nnormfont ", yytext);
      if (paren_open)
	fprintf(yyout, "(");
    }
  else
    default_handler();
}

double_quote()
{
  default_handler();
  switch (state)
    {
    case NORM_STATE:
      state = QUOTE_STATE;
      break;
    case QUOTE_STATE:
      state = NORM_STATE;
      break;
    default:
      break;
    }
}

special_char()
{
  newparen();
  fprintf(yyout, "\\%s", yytext);
}

default_handler()
{
  newparen();
  ECHO;
}
