/**************************************************************************/
/*  APIBLANK.C				                                  */
/*  Sample program to communicate with the BLANK-IT(tm) Screen Saver      */
/*  Copyright(c) 1992  Rhode Island Soft Systems, Inc.                    */
/**************************************************************************/

#define UNBLANK_SCREEN  0x07
#define BLANK_SCREEN    0x08

#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>

/**************************************************************************/

int 	blank_it_resident	(void),
	compare_signature	(char far *),
	main			(int argc, char *argv[]);
void	call_api		(char),
	show_usage      	(void);

/**************************************************************************/
int main (int argc, char *argv[])
{

  if(argc != 2)					  /* if not proper number   */
    { show_usage();				  /* arguments, exit        */
      exit(1);
    }

  if (!blank_it_resident())		          /* see if BLANK-IT loaded */
     {  printf("\n BLANK-IT not resident!\n");	  /* exit if not            */
	exit(1);
     }

  switch (tolower(argv[1][1]))			  /* go blank/unblank       */
    {
       case  'b':	call_api(BLANK_SCREEN);	  
			break;

       case  'u':	call_api(UNBLANK_SCREEN);
			break;
    }

  return(0);
}
/**************************************************************************/
int blank_it_resident (void)
{
  struct REGPACK	regs;
  int			int_number = 0x11;
  char far		*signature;


  regs.r_ax = 0x0225;				  /* set up CPU registers   */
  regs.r_bx = 0x6900;				  /* as per BLANK-IT API    */

  intr(int_number, &regs);			  /* make call to API       */

  if((regs.r_bx & 0x00FF) != 0x23)		  /* if BL not 23, exit     */
     return(0);

  signature = MK_FP (regs.r_es, regs.r_di);	  /* create pointer to      */
						  /* signature string       */
						  
  return (compare_signature(signature));      
}
/**************************************************************************/
int compare_signature (char far *signature)
{
  int  	i;
  char	string[] = "BLNKIT";


  for(i = 0; i < 7; i++)			  /* see if signature       */
      {  if ( *(signature + i) != string[i])	  /* matches                */
	    return(0);
      }

  return(1);
}
/**************************************************************************/
void show_usage (void)
{

   printf("\n Usage:  APIBLANK.EXE [/b] [/u] \n\n");
   printf("         /b  Blanks the screen \n");
   printf("         /u  Unblanks the screen \n");
   printf("         Specify either /b or /u \n\n");
}
/**************************************************************************/
void call_api (char command_value)
{
  union REGS	inregs,
		outregs;
  int		int_number = 0x11;

  inregs.x.ax = 0x0225;				  /* set up CPU registers   */
  inregs.h.bh = 0x69;
  inregs.h.bl = command_value;			  /* use whichever API sub- */
						  /* function the is wanted */

  int86(int_number,				  /* make the API call      */
	&inregs,
	&outregs);

}
/**************************************************************************/
