program qnetconf;

type
   flagstr  = packed array[0..9] of char;
   datestr  = packed array[0..7] of char;
   timestr  = packed array[0..4] of char;
   modstr   = packed array[0..7] of char;
   conftype = record
                 network    : integer;
                 netconf    : integer;
                 flags      : flagstr;
                 lastscan   : longint;
                 lastinsert : longint;
                 scandate   : datestr;
                 scantime   : timestr;
                 scanned    : longint;
                 insertdate : datestr;
                 inserttime : timestr;
                 inserted   : longint;
                 moderated  : modstr;
              end;

{$i-}
var
   dif    : file;
   dof    : file;
   f      : text;
   io     : integer;
   bread  : word;
   size   : word;
   ocnf   : word;
   ncnf   : word;
   conf   : conftype;
   oexit  : pointer;
   buffer : pointer;

{$f+}
procedure myexit;
   begin
      io := ioresult;
      exitproc := oexit;
      close(f);
      io := ioresult;
      close(dif);
      io := ioresult;
      close(dof);
      io := ioresult;
      case exitcode of
         0   : writeln('Successful termination');
         1   : writeln('Error: Unable to locate CNAMES.DAT');
         2   : begin
                  writeln('Error: CNAMES.OLD already exists.');
                  writeln('You have probably already ran this program.');
                  writeln('If you have not, then delete CNAMES.OLD and re-execute');
               end;
         3   : writeln('Error: Unable to create CNAMES.OLD');
         4   : writeln('Error: Problem reading CNAMES.DAT');
         5   : writeln('Error: Problem writing CNAMES.OLD');
         6   : writeln('Error: Unable to close CNAMES.DAT');
         7   : writeln('Error: Unable to close CNAMES.OLD');
         8   : writeln('Error: Unable to open CNAMES.DAT');
         9   : writeln('Error: Unable to open CNAMES.OLD');
         10  : writeln('Error: Problem reading QNETCONF.CNF');
         11  : writeln('Error: Problem reading CNAMES.OLD');
         12  : writeln('Error: Problem writing CNAMES.DAT');
         101 : writeln('Error: Missing QNETCONF.CNF file');
         else ;
      end;
      writeln;
   end;
{$f-}

begin
   oexit := exitproc;
   exitproc := @myexit;
   writeln;
   writeln('QNETCONF 1.00');
   writeln('Copyright 1992, James D. Jones');
   writeln;
   assign(f,'qnetconf.cnf');
   reset(f);
   if ioresult <> 0 then
      begin
         writeln('QNETCONF requires a text file QNETCONF.CNF');
         writeln('Each line contains a two conference numbers');
         writeln('  OldConf# NewConf#');
         writeln('Example: 109 52');
         writeln('  will move conference 109 to conference 52');
         writeln;
         halt(101);
      end;
   close(f);
   io := ioresult;
   assign(dif,'cnames.dat');
   assign(dof,'cnames.old');
   reset(dif,1);
   if ioresult <> 0 then halt(1);
   reset(dof,1);
   if ioresult = 0 then halt(2);
   rewrite(dof,1);
   if ioresult <> 0 then halt(3);
   if maxavail < 32768 then size := maxavail else size := 32768;
   getmem(buffer,size);
   bread := size;
   while bread = size do
      begin
         blockread(dif,buffer^,size,bread);
         if ioresult <> 0 then halt(4);
         blockwrite(dof,buffer^,bread);
         if ioresult <> 0 then writeln('Error: Problem writing CNAMES.OLD');
      end;
   close(dif);
   if ioresult <> 0 then halt(6);
   close(dof);
   if ioresult <> 0 then halt(7);
   reset(f);
   if ioresult <> 0 then halt(101);
   reset(dif,1);
   if ioresult <> 0 then halt(8);
   reset(dof,1);
   if ioresult <> 0 then halt(9);
   while not eof(f) do
      begin
         readln(f,ocnf,ncnf);
         if ioresult <> 0 then halt(10);
         seek(dof,4+ocnf*sizeof(conftype));
         blockread(dof,conf,sizeof(conf),bread);
         if ioresult <> 0 then halt(11);
         if bread <> sizeof(conf) then halt(11);
         seek(dif,4+ncnf*sizeof(conftype));
         blockwrite(dif,conf,sizeof(conf),bread);
         if ioresult <> 0 then halt(12);
         if bread <> sizeof(conf) then halt(12);
      end;
end.
