' ****************************************************************
'
' Name: Usenet
' Date: Sept. 18, 1992
' Author: Jim Wenzel    jim.wenzel@grapevine.lrk.ar.us
' Purpose:
'     To modify the report generated by dbfsetup of uuPCB into a 
'     format that better described the conferences to the users.
'
' Modifications:  Please add as needed
'
' Author:
' Date:
' Modification made:
'
' ****************************************************************
' variables used
'
' file1$ = uuPCB report name
' file2$ = UseNet conference listing
' z$     = generic variable for line of text read in
' x$     = generic variable for line of text written out
' grp$   = line of text taken from UseNet conference listing
' grp1$  = conference name stripped from grp$
' grp2$  = conference description stripped from grp$
' test$  = contains conference name taken from uuPCB report
' p$     = Progress character
'
' row = row to print on for LOCATE purposes
' col = column to print on for LOCATE purposes
' temp= generic variable 
' x   = generic counting variable
' xxx = generic variable for "FOR" loops
' xxxx= generic variable for ending a "FOR" loop
' zzzz= length of UseNet conference list file
'
' ****************************************************************

CLS
PRINT "If the file is not in the current directory give full path"
INPUT "Enter filename of uuPCB report"; file1$
INPUT "Enter filename of UseNet group listing"; file2$

row = 4
col = 1

' ****************************************************************
' 
' Clean up report (strip out paths to message bases etc.)
'
' ****************************************************************

OPEN file1$ FOR INPUT AS #1
OPEN "usenet.cln" FOR OUTPUT AS #2

DO WHILE NOT EOF(1)
     GOSUB Progress
     LINE INPUT #1, z$
     temp = INSTR(z$, "uuPCB C")
     IF temp > 1 THEN x$ = MID$(z$, temp, LEN(z$)): PRINT #2, x$: LINE INPUT #1, z$: x$ = SPACE$(10)
     z = 50
     IF LEN(z$) < 50 THEN z = LEN(z$)
     x$ = MID$(z$, 1, z)
     PRINT #2, x$
LOOP
LOCATE row, col: PRINT "Phase 1 complete"
row = 5

CLOSE

' ****************************************************************
'
' Use "clean" version of report and compare against usenet conference
' listing.
'
' ****************************************************************
OPEN "usenet.cln" FOR INPUT AS #1
OPEN "usenet.blt" FOR OUTPUT AS #2

DO WHILE NOT EOF(1)
        GOSUB Progress
        LINE INPUT #1, z$
        PRINT #2, z$
        OPEN file2$ FOR INPUT AS #3
        IF MID$(z$, 1, 2) = SPACE$(2) AND LEN(z$) > 30 THEN
                test$ = RTRIM$(MID$(z$, 8, 30))
                DO WHILE NOT EOF(3)
                LINE INPUT #3, grp$
' ****************************************************************
'  expand tab characters if any
' ****************************************************************
                IF INSTR(grp$, CHR$(9)) > 1 THEN
                        xxxx = INSTR(grp$, CHR$(9))
                        FOR xxx = xxxx TO xxxx + 1
                                IF MID$(grp$, xxx, 1) = CHR$(9) THEN MID$(grp$, xxx) = " "
                                IF xxx < 80 THEN LOCATE row, xxx: PRINT "*"
                        NEXT xxx
                        LOCATE row, 1: PRINT SPACE$(80)
                END IF
               
                GOSUB Progress
' ****************************************************************
' break line up into two variables.  grp1$ is the conference name
' and grp2$ is conference description
' ****************************************************************

                   grp1$ = RTRIM$((MID$(grp$, 1, INSTR(grp$, " "))))
                   grp2$ = MID$(grp$, LEN(test$) + 1, LEN(grp$))
                   IF test$ = grp1$ THEN
                       PRINT #2, grp2$
                       zzzz = LOF(3)
                       SEEK #3, zzzz
                   END IF
                LOOP
        CLOSE #3
        END IF
CLOSE #3
PRINT #2, SPACE$(20)

LOOP
CLOSE
KILL "usenet.cln"
LOCATE row, col: PRINT "Processing complete"

PRINT "Output is UseNet.blt"

SYSTEM
' ****************************************************************
'
' Prints a progress character on the screen to show program is working
'
' ****************************************************************

Progress:
LOCATE row, col: PRINT p$
x = x + 1
IF x = 1 THEN p$ = "\"
IF x = 2 THEN p$ = "|"
IF x = 3 THEN p$ = "/"
IF x = 4 THEN p$ = "-"
IF x = 5 THEN x = 0
RETURN

