#include <stdio.h>
#include <conio.h>
#include <dos.h>

#include "nos.h"
#include "noslib.h"
#include "netpq.h"

//
//  NETPQ.EXE
//
//  Displays printer queue activity on all logged on servers.  The display
//	updates every two seconds.  Queued files may be cancelled, held, or
//	released by the operator.  If the operator has queue privileges, the
//	operator can change the downloading status of each printer port and
//	may 'rush' queued files.
//
//  This program uses the Borland C versions of the nos library included in
//  the file 'book.zip' on the Artisoft BBS (602-293-0065) and was compiled
//  using Borland C++.
//
//  Written by Alan R. Roney
//
//  Released into the public domain by the author.  The author accepts no
//  responsiblity for any problems associated with use of this program.
//
//  This software is not to be included in any "for profit" software packages.
//
//  You are welcome to modify the source code for this program.  Please
//  forward a copy of your changes to the author.
//
//  Comments should be directed to the author at:
//
//	    Internet:	    aroney@tso.uc.edu
//	    Artisoft:	    alan roney
//	    Compuserve:     76330,3711
//


struct serverdef *server;
struct localqueuedef *localqueue;

int currentserver, adaptornum, numberoflogins, currentprinter, found;
int queuejobcount, printjobcount;
int maxlocalqueuecount, localqueuecount;

char	servername [D_NAMESZ + 2];

struct PS serverps;
struct queue_entry serverqe;
struct time_block servertime;
struct user_account serveraccount;


main ()
{
int keypressed, i;

    setup ();

    do
	{
	do
	    {
	    getserverinfo ();
	    clrscr ();
	    reportinfo ();
	    showmenu ();

	    i = 0;
	    while (i++ < 2)
		{
		sleep (1);
		if (kbhit () != 0)
		    break;
		}
	    }while (kbhit () == 0);

	keypressed = getextch ();

	switch (keypressed)
	    {
	    case key_f1:
		f1keypressed ();
		break;

	    case key_f2:
		f2keypressed ();
		break;
	    }
	lowvideo ();

	}while ( (keypressed == key_f1) || (keypressed == key_f2) );

    lowvideo ();
    textcolor (LIGHTGRAY);
    clrscr ();

    free (server);
    free (localqueue);
}


setup ()
{
    //	Check for presence of NetBios Version 4.0 or greater

    if (NOSPresence () == -1)
	{
	printf ("NETBIOS not installed\n");
	exit (1);
	}

    if (NOSGetVersion () < 1024)
	{
	printf ("Incorrect NETBIOS Version\n");
	exit (1);
	}

    //	Find out how many servers this node is logged into

    numberoflogins = 0;
    servername [0] = servername [1] = '\\';

    while (NOSGetLogin (&numberoflogins, &servername [2], &adaptornum) != -1)
	numberoflogins++;

    if (numberoflogins <= 0)
	{
	printf ("Not logged into to any servers\a\n");
	exit (1);
	}

    //	open structures for storing information

    if ( (server = (struct serverdef *) calloc (numberoflogins, sizeof (struct serverdef))) ==	(struct serverdef *) 0)
	{
	printf ("Couldn't allocate space for server information\n");
	exit (1);
	}

    maxlocalqueuecount = 0;
    if ( (localqueue = (struct localqueuedef *) calloc (1, sizeof (struct localqueuedef))) ==  (struct localqueuedef *) 0)
	{
	printf ("Couldn't allocate space for queue information\n");
	exit (1);
	}

    //	Get server names and queue privileges

    currentserver = 0;

    while (currentserver < numberoflogins)
	{
	if (NOSGetLogin (&currentserver, &servername [2], &adaptornum) == -1)
	    NOSperror ("NOSGetLogin");

	strcpy (server [currentserver] .servername, servername);

	//  Check for queue privileges

	if (NOSGetAccount (&serveraccount, servername) == -1)
	    NOSperror ("NOSGetAccount");
	else
	    {
	    if (((serveraccount .UA_privilege & UA_privilege_superACL) != 0) ||
		((serveraccount .UA_privilege & UA_privilege_superqueue) != 0))
		{
		server [currentserver] .queue_privilege = true;
		}
	    else
		server [currentserver] .queue_privilege = false;
	    }
	currentserver++;
	}
}


showmenu ()
{
    textcolor (LIGHTGRAY);
    highvideo ();
    cprintf ("F1: ");
    lowvideo ();
    cprintf ("Control Port  ");
    highvideo ();
    cprintf ("F2: ");
    lowvideo ();
    cprintf ("Control Queue  ");
    highvideo ();
    cprintf ("Any other key: ");
    lowvideo ();
    cprintf ("Exit");
}
