#include <stdio.h>
#include <conio.h>

#include "nos.h"
#include "noslib.h"
#include "netpq.h"

extern struct serverdef *server;
extern struct localqueuedef *localqueue;

extern int currentserver, adaptornum, numberoflogins, currentprinter, found;
extern int queuejobcount, printjobcount;
extern int maxlocalqueuecount, localqueuecount;

extern struct PS serverps;
extern struct queue_entry serverqe;
extern struct time_block servertime;
extern struct user_account serveraccount;

int statusorder [] =
    {
    8,				    //"FREE",
    3,				    //"UPDATING",
    4,				    //"HOLDING",
    2,				    //"WAITING",
    0,				    //"DESPOOLING",
    5,				    //"CANCELLED",
    6,				    //"FILE ERROR",
    7,				    //"SPOOL ERROR",
    1				    //"* RUSH *"
    };




getserverinfo ()
{
    //	Loop through each server that the user is logged into

    purgelocalqueue ();

    currentserver = 0;
    localqueuecount = 0;

    while (currentserver < numberoflogins)
	{
	//  Record the Server's Date & Time

	if (NOSGetTime (&servertime, server [currentserver] .servername) == -1)
	    NOSperror ("NOSGetTime");
	else
	    server [currentserver] .time = servertime;

	//  Loop through each of the 5 possible printers on the server
	//  and record status of printer

	currentprinter = 0;
	while (currentprinter < 5)
	    {
	    if (NOSGetStatus (&currentprinter, &serverps, server [currentserver] .servername) == -1)
		NOSperror ("NOSGetStatus");
	    fixstatus ();
	    server [currentserver] .PS_state_pause [currentprinter - 1] = serverps .PS_state.PS_state_pause;
	    server [currentserver] .PS_state_value [currentprinter - 1] = serverps .PS_state.PS_state_value;
	    server [currentserver] .PS_index [currentprinter - 1] = serverps .PS_index;
	    server [currentserver] .PS_CPS [currentprinter - 1] = serverps .PS_CPS;
	    server [currentserver] .PS_output_chars [currentprinter - 1] = serverps .PS_output_chars;
	    }
	currentserver++;
	}

    qsort ( (void *) server, numberoflogins, sizeof (struct serverdef), comparestring);

    currentserver = 0;
    localqueuecount = 0;

    while (currentserver < numberoflogins)
	{
	//	Check queue for presence of printer files in the server queue

	queuejobcount = 0;
	printjobcount = 0;

	while (NOSGetQueue (&queuejobcount, &serverqe, server [currentserver] .servername) != -1)
	    {
	    if (serverqe .QE_type == QE_type_print)
		{
		if (localqueuecount >= maxlocalqueuecount)
		    {
		    if ( (localqueue = (struct localqueuedef *) realloc (localqueue, numberoflogins, sizeof (struct localqueuedef)))
			    ==	(struct localqueuedef *) 0)
			{
			printf ("Couldn't reallocate space\n");
			exit (1);
			}
		    maxlocalqueuecount++;
		    }

		//if present, copy information to localqueue

		localqueue [localqueuecount] .QE_sequence = serverqe .QE_sequence;
		sprintf (localqueue [localqueuecount] .sequencestring, "%6lu\0", serverqe .QE_sequence);

		strcpy (localqueue [localqueuecount] .QE_user,	      serverqe .QE_user);
		strcpy (localqueue [localqueuecount] .QE_machine,     serverqe .QE_machine);
		strcpy (localqueue [localqueuecount] .QE_destination, serverqe .QE_destination);
		strcpy (localqueue [localqueuecount] .QE_comment,     serverqe .QE_comment);

		localqueue [localqueuecount] .QE_status = serverqe .QE_status;
		localqueue [localqueuecount] .QE_size	= serverqe .QE_size;
		localqueue [localqueuecount] .server	= currentserver;

		localqueue [localqueuecount] .sort_order = statusorder [serverqe .QE_status] * 100000 + serverqe .QE_sequence;

		localqueue [localqueuecount] .printer = -1;

		//if waiting or downloading, find out which printer it's on

		if (serverqe .QE_status == 4)
		    {
		    currentprinter = 0;
		    found = false;

		    while ( (currentprinter < 5) && (found == false) )
			{
			if ( (server [currentserver] .PS_state_value [currentprinter] != 0) &&
			     (server [currentserver] .PS_index [currentprinter] == (queuejobcount - 1) ) )
			    {
			    localqueue [localqueuecount] .printer = currentprinter;
			    found = true;
			    }
			currentprinter++;
			}
		    }
		printjobcount++;
		localqueuecount++;
		}
	    }
	server [currentserver] .queue_jobs = printjobcount;
	currentserver++;
	}
    qsort ( (void *) localqueue, localqueuecount, sizeof (struct localqueuedef), compareDWORD);

}



purgelocalqueue ()
{
int i;

    for (i = 0; i < maxlocalqueuecount + 1; i++)
	localqueue [i] .server = -1;
}



fixstatus ()
{
//  this module fixes the apparent error in the information reported by
//  the NOSGetStatus call.
//
// Printer	 ACTUAL 	ACTUAL		DESIRED 	DESIRED
// Status     PS_state_pause PS_state_value  PS_state_pause  PS_state_value
//
// Enabled	  0x00		 0x01		 0x00	    PS_state_multijob
// Single Job	  0x01		 0x00		 0x00	    PS_state_single_job
// Disabled	  0x00		 0x00		 0x00	    PS_disabled
// Paused	  0x00		 0x41		 0x01		 0xXX

    if ( (serverps .PS_state.PS_state_pause == 0) &&
	 (serverps .PS_state.PS_state_value == 0x41) )
	{
	serverps .PS_state.PS_state_pause = 1;
	serverps .PS_state.PS_state_value = 1;
	}
    else if ( (serverps .PS_state.PS_state_pause == 0) &&
	      (serverps .PS_state.PS_state_value == 0x01) )
	 {
	 serverps .PS_state.PS_state_pause = 0;
	 serverps .PS_state.PS_state_value = PS_state_multijob;
	 }
    else if ( (serverps .PS_state.PS_state_pause == 1) &&
	      (serverps .PS_state.PS_state_value == 0) )
	 {
	 serverps .PS_state.PS_state_pause = 0;
	 serverps .PS_state.PS_state_value = PS_state_single_job;
	 }
    else if ( (serverps .PS_state.PS_state_pause == 0) &&
	      (serverps .PS_state.PS_state_value == 0) )
	 {
	 serverps .PS_state.PS_state_pause = 0;
	 serverps .PS_state.PS_state_value = PS_state_disabled;
	 }
}
