;
; Simple program to extract the user's name from netware and place it in
; an environment variable "USER".  
;
; Public Domain - credits to Matthew Staben, Staben Technologies
;                                            811 West 14th Avenue
;                                            Spokane, WA  99204
;




.model small
.code

                ;===============================:
                ; first, test for MS-DOS or 4DOS:
                ;===============================:
                mov     ax, 0D44Dh              ; 4DOS swap area
                mov     bx, 0
                int     2Fh                     ; and interrupt it
                ;===============================:
                ;IF ax = 44DD, 4DOS is used.    :
                ;===============================:
                cmp     ax, 44DDh               ; compare the deal
                je      IS_4DOS                 ; and if equal, its 4DOS
                mov     ax, 352Eh               ; find the master env
                int     21h
                mov     es, [es:2Ch]            ; es = environment segment
                jmp     short   dos_checked     ; jump past 4dos stuff
        is_4dos:
                mov     es, cx                  ; es = 4dos environment segment
                mov     es, [es:2Ch]
        dos_checked:            
                mov     [cs:envseg], es
                xor     di, di                  ; point to start of env in es:di
                cld                             ; scan in forward
FIND_STRING:                                    ; - loop thru 1 by 1
                test    [byte ptr es:[di]], -1  ; end of env?
                jnz     check_string            ; nope... continue
                jmp     short   no_environment  ; error...
CHECK_STRING:           
                push    cs
                pop     ds
                mov     si, offset ENVSTR       ; point to USERNAME
                mov     bx, di                  ; save ptr to start
                mov     cx, envlen              ; length of envstr
                repe    cmpsb                   ; compare
                je      ALL_PASSED              ; found it!
                mov     di, bx                  ; restore ptr to start
                xor     al, al                  ; scan for end of string
                mov     cx, -1                  ; FFFF <- cx
                repne   scasb
                jmp     short   find_string     ; go back for next string
                
ALL_PASSED:
                mov     [cs:envoff], di
        		clc
        		mov     [cs:onezero], 0
        		jmp 	BEGIN
                
NO_ENVIRONMENT:
                ;===========================:
                ; This procedure is called  :
                ; if the environment string :
                ; does not exist.           :
                ;===========================:
                ; so, create it!            :
                ;===========================:
                
                mov     [cs:onezero],2
                mov     ax, [cs:envseg]
                mov     es, ax
                xor     di, di
                
                ; look for pair of zeros, the second zero is the new begin
lookfor:                
                mov     ah, [byte ptr es:[di]]
                cmp     ah, 0
                je      first_zero
                inc     di
                jmp     lookfor
first_zero:
                inc     di
                mov     ah, [byte ptr es:[di]]
                cmp     ah, 0
                jne     lookfor
                
is_zero:
                mov     [byte ptr es:[di]], 85
                inc     di
                mov     [byte ptr es:[di]], 83
                inc     di
                mov     [byte ptr es:[di]], 69
                inc     di
                mov     [byte ptr es:[di]], 82
                inc     di
                mov     [byte ptr es:[di]], 61    
                inc     di
                mov     [cs:envoff], di
                jmp     begin

SHOW_MESSAGE:
                mov     ah, 09h
                int     21h
                
EXIT_OUT:
                jmp     bye_bye
BEGIN:

MODIFY_ENV:
                ;==================================================:
                ; Let's get the username and slip into the env     :
                ;==================================================:
                
                mov     AH,0DCh                 ; function to get connection #
                int     21h
                mov     CS:ConnectionNumber,AL

                mov     AH,0E3h                 ; log request function #

                mov     DX,seg cs:RequestBuffer
                mov     DS,DX
                mov     DX,seg cs:ReplyBuffer
                mov     ES,DX
                lea     SI,cs:RequestBuffer        ;  DS:SI points to Request Buffer
                lea     DI,cs:ReplyBuffer          ;  ES:DI points to Reply Buffer
                                              
                int     21h

;  Return the name

       WRITE_OUT:
                ; here, we actually write out the environment.       
                mov     ax, seg cs:objectname
                mov     es, ax
                mov     di, offset cs:objectname
                mov     [cs:objectoff], di
                mov     [cs:objectseg], es
                mov     ax, cs
                mov     ds, ax
                mov     si, offset safearea
                xor     dx, dx
                xor     bx, bx
                xor     cx, cx
                
                cmp     [cs:onezero], 2
                jne     REPLACEUPTO
                
                ; 
                ; just fill it out and add two zeros
                ;
          APPEND:
                mov     es, [cs:objectseg]
                mov     di, [cs:objectoff]
                mov     ah, [byte ptr es:[di]]
                cmp     ah, 0
                je      addtwo
                cmp     [cs:charcount], 8
                je      addtwo
                inc     [cs:objectoff]
                inc     [cs:charcount]
                mov     es, [cs:envseg]
                mov     di, [cs:envoff]
                inc     [cs:envoff]
                mov     [byte ptr es:[di]], ah
                jmp     append
      addtwo:
                mov     es, [cs:envseg]
                mov     di, [cs:envoff]
                jmp     addtwozeros

      samelength:
                cmp     ah, 0
                jne     retsame
                jmp     did_it
                                
      REPLACEUPTO:
                ; 
                ; replace the environment up to the first zero
                ;
                mov     es, [cs:objectseg]
                mov     di, [cs:objectoff]
                mov     ah, [byte ptr es:[di]]  ; next net buffer char
                mov     es, [cs:envseg]
                mov     di, [cs:envoff]
                mov     al, [byte ptr es:[di]]
                ; check if both are zero
                cmp     al, ah
                je      samelength
           retsame:
                ; check if zero has been reached in environment
                cmp     al, 0
                je      ENDREPLACE
                ; check if zero has been reached in net-buffer
                cmp     ah, 0
                je      ENDNETBUF
                ; check if 8 chars have been used
                cmp     [cs:charcount], 8
                je      ENDNETBUF
                inc     [cs:charcount]
                mov     es, [cs:envseg]
                mov     di, [cs:envoff]
                mov     [byte ptr es:[di]], ah
                inc     [cs:envoff]
                inc     [cs:objectoff]
                jmp     REPLACEUPTO

      ENDNETBUF:
                ; 
                ; scan thru environment to next char, saving the current
                ; position in the environment for replacing
                ;
                mov     es, [cs:objectseg]
                mov     di, [cs:objectoff]
                mov     [byte ptr es:[di]], 0
                mov     es, [cs:envseg]
                mov     di, [cs:envoff]
                mov     [cs:startpos], di
                ; find a zero
         envscan:
                inc     di
                mov     ah, [byte ptr es:[di]]
                cmp     ah, 0
                je      endenvscan
                jmp     envscan
         endenvscan:
                mov     [cs:envoff], di
                
      ENDREPLACE:
                ; 
                ; save the rest of the environment in the buffer
                ;
                mov     di, [cs:envoff]
                cmp     [cs:startpos], 0
                jne     checkstart
                mov     [cs:startpos], di
         checkstart:
                mov     es, [cs:envseg]
                mov     di, [cs:envoff]
                mov     ah, [byte ptr es:[di]]
                cmp     ah, 0
                jne     notzero
                inc     di
                mov     ah, [byte ptr es:[di]]
                dec     di
                cmp     ah, 0
                je      checkout
         
         notzero:
                mov     ah, [byte ptr es:[di]]
                mov     [byte ptr ds:[si]], ah
                inc     [cs:envoff]
                inc     si
                inc     dl
                jmp     checkstart
      
         checkout:
       
      FILLENVIRONMENT:
                ; 
                ; if the buffer was too long, we still have some chars to
                ; slip into the environment from the network buffer
                ;
                mov     es, [cs:objectseg]
                mov     di, [cs:objectoff]
                mov     ah, [byte ptr es:[di]]
                cmp     ah, 0
                je      fillitup
                cmp     [cs:charcount], 8
                je      fillitup
           fillnet:
                mov     es, [cs:objectseg]
                mov     di, [cs:objectoff]
                mov     ah, [byte ptr es:[di]]
                cmp     ah, 0
                je      fillitup
                cmp     [cs:charcount], 8
                je      fillitup
                inc     [cs:objectoff]
                mov     es, [cs:envseg]
                mov     di, [cs:startpos]
                mov     [byte ptr es:[di]], ah
                inc     [cs:startpos]
                inc     [cs:charcount]
                jmp     fillnet
                
           fillitup:
                mov     di, [cs:startpos]
                mov     [cs:envoff], di
                mov     ax, cs
                mov     ds, ax
                mov     si, offset safearea
                inc     dl
           filloop:
                mov     di, [cs:envoff]
                mov     es, [cs:envseg]
                mov     ah, [byte ptr ds:[si]]
                inc     si
                mov     [byte ptr es:[di]], ah
                inc     [cs:envoff]
                inc     cx
                cmp     cx, dx
                je      addtwozeros
                jmp     filloop
         
           addtwozeros:
                mov     [byte ptr es:[di]], 0
                inc     di
                mov     [byte ptr es:[di]], 0

did_it:
                mov     ax, cs
                mov     ds, ax
                mov     dx, offset ACTION      ; point to finished mssg
                jmp     show_message
        
bye_bye:
                mov     ah, 4Ch
                int     21h             
                
ACTION          DB      0Ah,0Dh,0Ah,0Dh
                DB      'Bovay Northwest, Inc.', 0Ah, 0Dh
                DB      '---------------------', 0Ah, 0Dh
                DB      'Netware Username Extraction Facility',0Ah,0Dh
                DB      0Ah,0Dh
                DB      'The currently logged in user''s name ',0Ah,0Dh
                DB      'has been extracted to the environment',0Ah,0Dh
                DB      'under USER.',0Ah,0Dh
                DB      'Any Usernames over 8 characters have',0Ah,0Dh
                DB      'been truncated.',0Ah,0Dh
                DB      0AH,0Dh
                DB      '$'

;============================================:
; Variables which are internally used by the :
; program.                                   :
;============================================:
safearea        DB      512 dup ( ? )          ; temp storage buffer
EMPTYSPOT       DB      'D'
ENVSTR          DB      'USER='                 ; Env. variable to find
ENVLEN          EQU     5                       ; length of env variable
envseg          DW      0                        ; environment seg
envoff          DW      0                        ; environment offset
objectseg       DW      0                       ; object segment
objectoff       DW      0                       ; object offset
startpos        DW      0                       ; network buffer too short
onezero         DB      0                       ; was it appended?
charcount       DB      0                       ; count of chars


RequestBuffer           Label   Byte
PacketLengthLow         db      2               ; request buffer 2 bytes long
PacketLengthHigh        db      0
Function                db      22              ; sub function to get user info
ConnectionNumber        db      ?               ; logical connection number

ReplyBuffer             Label   Byte
ReturnLengthLow         db      62              ; Reply is 62 bytes long
ReturnLengthHigh        db      0
UniqueID                dd      ?               ; Station's ID #
Typex                   dw      ?
ObjectName              db      48 dup ( ? )    ; USERNAME 1-47 characters
LogTime                 db      8  dup ( ? )    ; Time user logged in

end                
