    /*
    COMPILE WITH:
    qcl QPATCH.c structs.c routines.c
    */

#include "qpatch.h"
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
extern struct item items[];


main(ac, av) int ac; char **av;
    {
    int getvalues=0;
    char fname[15];
    strcpy(fname, "q.exe");
    while( --ac ){
        if( av[ac][0] == '-' || av[ac][0] == '\/' ) getvalues = 1;
        else strcpy ( fname, av[ac] );
    }
    if( getvalues ) {
        get_all_values_from_q( fname );
        print_form(0);
        exit(0);
    }
    reading_in_file();
    installing_all_values( fname );
    print_form(1);
    }



/*======================INPUT OUTPUT===================================*/
/*======================INPUT OUTPUT===================================*/
/*======================INPUT OUTPUT===================================*/


/*======================READING IN THE PATCH FILE======================*/

reading_in_file()
    {
    int n;
    char line[90];
    while( gets( line ))
        {
        n = finditem( line );
        if (n < 0) continue;
        if(getnewval( line, &items[n].new_val ))
            {
            if( data_check( &items[n] ) )
                {
                items[n].nv = 1;
                Ialpha2int( &items[n] );
                }
            else
                {
                printf("******************bad val for question: \n\n\n\t\t%s:%s:\n\n", items[n].message, items[n].new_val.alpha_val );
                exit(-1);
                }
            }
        }
    }

data_check( item ) struct item *item;
    {
    switch( item->format )
        {
        case 0:  return( strlen( item->new_val.alpha_val ) <=4 );
        case 1:  return ( char_is( "YNyn", item->new_val.alpha_val[0] ));
        case 2:  return ( str_is ( item->new_val.alpha_val, "0123456789" ));
        default: return 0;
        }
    }

char_is( string, ch ) char ch; char *string;
    {
    while( *string != '\0')
        if( ch == *string++) return 1;
    return 0;
    }

str_is( string, vals ) char *string, *vals;
    {
    while( *string != '\0' )
        {
	if( !char_is ( vals, *string )) return 0;
        string++;
        }
    return 1;
    }

/*======================PATCHING q.exe===============================*/

installing_all_values( fname) char *fname;
    {
    int f = open( fname, O_WRONLY | O_BINARY);
    int i=0;
    if( f== -1 )
        {
        printf( "no %s FILE in this directory", fname );
        exit(-1);
        }
    while ( items[i].message[0] != '\0')
        {
        if( items[i].nv )
            install_new_value( &items[i], f );
        i++;
        }
    close( f );
    }

install_new_value( item, f ) struct item *item; int f;
    {
    int i;
    int leng;
    lseek( f, (long)item->address, SEEK_SET);
    if( item->format > 0)
	write( f, &item->new_val.int_val, 1 );
    else write( f, item->new_val.alpha_val, strlen(item->new_val.alpha_val));
    }

/*======================READING q.exe=================================*/

get_all_values_from_q( q_name ) char *q_name;
    {
     FILE *in;
     int n=0;
     if( ( in = fopen( q_name, "rb" ) ) == NULL )
        {
        printf( "no %s FILE in this directory", q_name );
		exit(-1);
        }
    while( items[n].address != 0 )
        {
        get_value_from_q( &items[n++], in );
	}
    fclose( in );
    }


get_value_from_q( item, f )
FILE *f; struct item *item;
    {
    int i;
    fseek ( f, (long) item->address, SEEK_SET);
    if( item->format > 0)
        item->old_val.int_val = fget_byte( f );
    else
        {
        i=-1;
        do
            {
            item->old_val.alpha_val[++i] = (char) fget_byte( f );
            } while(item->old_val.alpha_val[i] != '\0' );
        }
    Iint2alpha( item );
    }


fget_byte(f)
FILE *f;
    {
    unsigned int c;
	if ((c = fgetc(f)) == EOF)
    printf( "Can't read file or unexpected end of file" );
    return c & 0xFF;
    }


/* ===================PRINTING========================================*/


print_item(item)  struct item *item;
    {
    if(item->nv)
        printf("%s [%s] : %s   \n", item->message, item->old_val.alpha_val, item->new_val.alpha_val );
    else printf("%s [%s] :     \n", item->message, item->old_val.alpha_val );
    }

print_form(nv) int nv;
    {
    int i=0;
    while(items[i].message[0] != '\0')
	{
        if( !nv || items[i].nv )
	    print_item( &items[i] );
	i++;
	}
    }


