Program TPTest;
(*********************************************************************)
(***  Program Name: TPTest                                         ***)
(***  Author:       Julio Monroy                                   ***)
(**   Last Update:  9/18/1991                                      ***)
(***  Purpose:      To demonstrate use of the TPNET.TPU Unit.      ***)
(***  Requirements: TPTEST.DAT must be present in current directory **)
(*********************************************************************)

Uses Dos,Crt,TPNet;

CONST  TestFile = 'TPTEST.DAT';        {  File to be shared          }
       Recnum   = 3;                   {  Record # to be locked      }
       CrLf     = #10#13;              {  Line feed combo            }
       ShareMode= 66;                  {  File open mode (SHARED)    }

TYPE  Item_Rec = Record                {  Structure of disk file to  }
        Model : String;                {  be read/written and        }
        Price : Real;                  {  locked/unlocked            }
      End;

      Item_File = File of Item_Rec;    {  Type declarations of data  }
      Item_Record  = Item_Rec;         {  structure for VAR headers  }

VAR Errcode  : Word;                   {  Global variable declarations }
    Itemfile : Item_File;
    ItemRec  : Item_Record;

Procedure ShowTitle;
{ Show program information and author }

Begin
  Writeln('TPNET Unit Demonstration by Julio Monroy.');
  Writeln('September 1991.',Crlf)
End;

Procedure KeyPause;
{ This procedure prompts the user to press a key to continue }
Var
  Ch : Char;

Begin
  Writeln('Press any key to continue...',CrLf);
  Ch := Readkey;
End;

Procedure ErrorHandle(VAR Error : Word);
{ This is a dummy error handler.  Substitute your own error handler to }
{ properly handle all critical errors.                                 }
Begin
  Writeln('= Error # ',Error,' =');
  If (Error=33) then Writeln('Lock Violation... it works!');
  KeyPause;
End;

Procedure OpenFile;
{ Opens files in a share mode. This is where the actual file sharing }
{ takes place. }

Begin { OpenFiles }
  FileMode := ShareMode;     { <-- This step is VERY IMPORTANT! This tells }
  Assign(ItemFile,TestFile);     { Turbo Pascal to open file in a SHARED   }
  {$I-}                          { mode.  A must for network file sharing! }
  Reset(ItemFile);
  {$I+}
  Errcode := IOResult;
  If Errcode<>0 then
    Begin
      Writeln('Error number ',Errcode,' while opening file ',TestFile);
      Halt(1);
    End
  Else
      Writeln('File opened successfully.');
End; { OpenFiles }

Procedure WriteData;
{ This procedure shows how to seek, lock, write, and unlock a record }

Begin { XchgData }
  Repeat
    {$I-}
    Seek(ItemFile,Recnum);                       { Move pointer to test rec }
    {$I+}
    ErrCode := IoResult;
    If Errcode<>0 then ErrorHandle(Errcode);  { If error occurs, handle it }
  Until Errcode = 0;
  ItemRec.Model := 'Invisible 16-Bit Ethernet';  { Assign data to record }
  ItemRec.Price := 369;
  Repeat
    Lockrec(FileRec(ItemFile).Handle,Sizeof(ItemRec),Recnum,Errcode);  { Lock it! }
    If Errcode<>0 then ErrorHandle(Errcode);
  Until Errcode = 0;
  Writeln('Record is locked.');
  KeyPause;
  Repeat
    {$I-}
    Write(ItemFile,ItemRec);                     { Write record }
    {$I+}
    ErrCode := IoResult;
    If Errcode<>0 then ErrorHandle(Errcode);
  Until Errcode = 0;
  Writeln('Record written.');
  KeyPause;
  Repeat                                         { And ... unlock record }
    UnLockrec(FileRec(ItemFile).Handle,Sizeof(ItemRec),Recnum,Errcode);
    If Errcode<>0 then ErrorHandle(Errcode);
  Until Errcode=0;
  Writeln('Record Unlocked.');
End; { XchgData }

Procedure CloseFile;
{ Closes file opened with ShareHandle }

Begin
  {$I-}
  Close(ItemFile);
  {$I+}
End;

(*************************************************************************)
(****************************   M   A   I   N   **************************)
(*************************************************************************)

Begin { Main }
  ShowTitle;
  OpenFile;
  WriteData;
  CloseFile;
End.  { Main }

