struct sqleaf {		/* Decoding tree */
	int children[2];	/* left, right */
};

typedef struct {
#ifdef INTERNAL
	FILE *file;
	struct sqleaf sqleaf[256];
	int issq;		/* non-zero if this file's squeezed */
	int bpos;		/* last bit position read */
	int curin;		/* last byte value read */
	int repct;		/* Number of times to return value */
	int value;		/* current byte value or EOF */
	long rewpos;		/* rewind seek position */
#endif
} SQFILE;

SQFILE	*sqopen    (const char *path);
void	 sqrewind  (SQFILE *stream);
long	 sqseek    (SQFILE *stream, long offset);
char	*sqgets    (char *s, int n, SQFILE *stream);
long	 sqtell    (SQFILE *stream);
long	 sqsize    (SQFILE *stream);
int	 sqclose   (SQFILE *stream);
