#include <stdio.h>
#include <math.h>
#include <fcntl.h>
#include "realcnvt.h"
#include "pcbstruc.h"

int fd,local;

/*:::::::::::::::::::[ GET CURRENT USERS RECORD NUMBER ]::::::::::::::::::::*/
long getrecordnum(){
  long filenum;
  if((fd=_open("pcboard.sys",O_RDWR|O_BINARY|O_DENYNONE))==NULL){
	printf("Cannot open file pcboard.sys\n");
	exit(1);  }
  read(fd,&doordat,sizeof(struct pcboardsys));
  close(fd);
  filenum = doordat.datanum-1;
  local=(strncmp("Local",doordat.mode,5)?0:1);
  return(filenum);}

/*:::::::::::::::::::::::[ PRINT STRUCTURE FIELD ]::::::::::::::::::::::::::*/
prtasc(char *string,char *fieldname,int length){
	char tempbuff[100];
	strncpy(tempbuff,fieldname,length);
	strcpy(&tempbuff[length],"\0");
	printf("%s%s",string,tempbuff);}

/*:::::::::::::::::::::::::::[ DISPLAY USER INFO ]::::::::::::::::::::::::::*/
display_info(){
	double doublenum;
	prtasc("\nNAME: ",person.name,25);
	printf("       Security Level: %d",person.seclev);
	prtasc("\nCity & state: ",person.citystate,24);
	prtasc("Password: ",person.password,12);
	prtasc("\nBusiness phone: ",person.busphone,13);
	prtasc("         Voice phone: ",person.voicephone,13);
	prtasc("\nLast date on: ",person.lastdateon,6);
	prtasc("\t\t      Time last logged on: ",person.lastlogon,5);
	printf("\nExpert mode: %c",person.expertmode);
	printf("\t\t\t      Protocol: %c",person.protocal);
	prtasc("\nLast dir look date: ",person.dirlookdate,6);
	printf("\t      Num times on: %d",person.numtimeson);
	printf("\nDaily D/L: %g",basdbletodouble(&person.dailydownloads));
	printf("\t\t      Page length: %d",person.pagelen);
	printf("\nNumber of uploads: %d ",person.numuploads);
	printf("\t\t      Number of downloads: %d",person.numdownloads);
	printf("\nElapsed Time on: %d",person.timeon);
	printf("\t\t      Subs exp sec level: %d",person.subsecuritylevel);
	prtasc("\nSubs registration date: ",person.subscriptionreg,6);
	printf("\t      Area last in: %d",person.arealastin);
	printf("\nDelete flag: %c",person.deleteflg);
	printf("\t\t\t      Last message read: %g",bassngltodouble(&person.lastreadmsg));
	prtasc("\nUser comments: ",person.usrcomments,30);
	prtasc("\nSys comments: ",person.syscomments,30);
	printf("\nBytes downloaded: %g",basdbletodouble(&person.bytesdownload));
	printf("\nBytes uploaded: %g",basdbletodouble(&person.bytesupload));
	printf("\n\nLocal modem: %c\n\n",(local?'Y':'N'));
	}



/*%%%%%%%%%%%%%%%%%%%%%%%%%[ START OF MAIN PROGRAM ]%%%%%%%%%%%%%%%%%%%%%%%%*/
main(int argc, char *argv[])	{
	int structsize;
	long user_num,pos;
	clrscr();
	/*=========[ COMMAND LINE OR PCBOARD.SYS RECORD NUMBER ]=======*/
	if (argc>1)
		user_num=atoi(argv[1]);
	else user_num=getrecordnum();
	/*=========[ OPEN USERS FILE ]=================================*/
	if((fd=open("users",O_RDWR|O_BINARY))==-1){
		printf("\n\nCannot open users file ");
		exit(1);	}
	/*=========[ FIND RECORD NUMBER IN USERS FILE ]================*/
	structsize = sizeof(struct usersinfo);
	pos=(long)user_num*structsize;
	if((lseek(fd,pos,0))!=-1L){
		/*=====[ READ DATA INTO STRUCTURE ]========================*/
		if((read(fd,&person,structsize))==0){
			printf("Record number out of range");exit(1);}
		close(fd);
		/*=====[ DISPLAY DATA ]====================================*/
		display_info();
		exit(0);
	}else {	printf("  ERROR trying to find record number in database!");}
	close(fd);
	exit(1);
}

