'         ******************** BIRTHDAY.BAS ********************
'
'        The original BIRTHDAY.BAS was downloaded from CompuServe.
'        It was a 12  line BASIC program which displayed the words
'        and played  "Happy Birthday."   The  name and  birth date
'        input   were part  of the BASIC program.  If the computer
'        date did  not match the birth date, the program would NOT
'        play.
'
'        The author  of this  ditty is unknown, but without him, I
'        could   not have  done the rest.  I have used QUICK BASIC
'        4.5 to add input statements, colors,  and  tried  to make
'        sure data entry was more controlled.  Most importantly an
'        UNBIRTHDAY section  was  added  as  there  are  more  un-
'        birthdays than  birthdays.   Lastly, I  have added my own
'        sense of humor.
'
'        The original  intent of  BIRTHDAY.BAS   was  to  surprise
'        someone  on  their  birthday  by  editing the program for
'        the person's  name  and  birth date and  then placing the
'        program  in their  AUTOEXEC.BAT   file.  This purpose has
'        been    enhanced   by    using  an   executable  program:
'        BIRTHDAY.EXE,  with  two  modifiable files: BIRTH.BAT and
'        DATA.DAT.

'        This technique allows this program to be used  for one  or
'        more   birthdays, or mostly for un-birthdays. BIRTHDAY.EXE
'        is  also fun to use from the keyboard.
'
'        How to  calculate the EXACT age for an un-birthday led me
'        to the Julian calender programs. That function calculates
'        the exact  difference between two dates, a useful tool.
'
'        Plagiarism  means to  steal  another's ideas and use them
'        as your own.  To plagiarize  means not to acknowledge USE
'        of someone else's intellectual  property  without  giving
'        them  credit for the borrowing. This  program uses pieces
'        of several  other BASIC,  GWBASIC,  QUICK  BASIC 4.0, and
'        QUICK BASIC 4.5 program  code.   All code  used has  been
'        modified  for this particular  program. I thank  all  the
'        programmers for their help, innovations, and formulas.
'
'        This program is shareware.
'
'        Ŀ
'                John R De Palma         Fri  02-22-1991         
'                                                                
'                         CompuServe: 76076,571                  
'        
'
'                 *********** BIRTHDAY.BAS **************

DECLARE SUB UNBIRTHDAY (FirstName$, month%, day%, year%)
DECLARE FUNCTION EXACTDATE! (month%, day%, year%)

COLOR 15, 1

'       Draw an outline around screen with ASCII characters.
CLS
LOCATE 1, 2, 0, 0, 0              ' turn off the cursor first

    PRINT CHR$(201); STRING$(76, 205); CHR$(187);   ' Draw top border.
    FOR I = 2 TO 23                 ' Draw left and right borders.
        LOCATE I, 2
        PRINT CHR$(186); TAB(79); CHR$(186);
    NEXT I
    LOCATE 24, 2
    PRINT CHR$(200); STRING$(76, 205); CHR$(188);   ' Draw bottom border.

'       Technique for centering text on the screen

COLOR 14, 7
text$ = "              "     ' Set text length
LOCATE 2, (80 \ 2) - LEN(text$) \ 2 + 1     ' Calculate the center
PRINT text$                                 ' Print text
text$ = "       B I R T H D A Y       "      ' Set text length
LOCATE 3, (80 \ 2) - LEN(text$) \ 2 + 1     ' Calculate the center
PRINT text$                                 ' Print text
text$ = "           S O N G           "      ' Set text length use same variable
LOCATE 4, (80 \ 2) - LEN(text$) \ 2 + 1     ' Calculate the center
PRINT text$                                 ' Print new text
text$ = "              "      ' Set text length
LOCATE 5, (80 \ 2) - LEN(text$) \ 2 + 1     ' Calculate the center
PRINT text$                                 ' Print text
COLOR 15, 4
text$ = "   Please Read and Answer the Questions ....   "
LOCATE 24, (80 \ 2) - LEN(text$) \ 2 + 1     ' Calculate the center
PRINT text$;                                 ' nb: use ";" to keep cursor on
COLOR 15, 3                                  ' line 24

'       To make sure that everyone will put in numbers rather than
'       letters or something else took a little looping.

    DO                                  'get the Month of birth.
        COLOR 15, 1
        LOCATE 9, 4: PRINT SPACE$(75)   ' eraser for mistakes
        COLOR 15, 2
        LOCATE 9, 50
        PRINT "and PRESS  {Enter}"
        LOCATE 9, 4: PRINT SPACE$(44)   ' eraser for mistakes
        LOCATE 9, 4, 1, 0, 7            ' large cursor block
        INPUT "TYPE in your MONTH of Birth (as 01 to 12) ", month$
        LOOP UNTIL LEN(month$) > 1 AND month$ <= "12" AND month$ >= "01"
        PLAY "MBT255L16O4CDEGO6C"       ' Tune 1
   
    DO                                  ' Get the Day of birth.
        COLOR 15, 1
        LOCATE 11, 4: PRINT SPACE$(75)   'eraser
        COLOR 15, 3
        LOCATE 11, 50
        PRINT "and PRESS  {Enter}"
        LOCATE 11, 4: PRINT SPACE$(44)   ' eraser
        LOCATE 11, 4
        INPUT "TYPE  in  your DAY of Birth (as 01 to 31) ", day$
        LOOP UNTIL LEN(day$) > 1 AND day$ <= "31" AND day$ >= "01"
        PLAY "MBT255L16O6CO4GEDC"         ' Tune 2
   
    DO                                   ' Get the Year of birth.
        COLOR 15, 1
        LOCATE 13, 4: PRINT SPACE$(75)   ' eraser
        COLOR 15, 4
        LOCATE 13, 50
        PRINT "and PRESS  {Enter}"
        LOCATE 13, 4: PRINT SPACE$(44)   ' eraser
        LOCATE 13, 4
        INPUT "TYPE in your YEAR of Birth ( use 19-- ) ", year$
        LOOP UNTIL LEN(year$) = 4 AND year$ <= "1991" AND year$ > "1583"
        PLAY "MBT255L16O4CDEGO6C"       ' Tune 1

'       DATE$ and Birthday$  will be made to match; then compare them
'       to see if the month and day are the same.  Make the
'       string look exactly as DATE$ does when it generates a date.

BIRTHDAY$ = month$ + "-" + day$ + "-" + year$

'       Get the numeric equivalents for the Julian formula to pass on to
'       the function EXACTDATE!.

month% = VAL(month$)
day% = VAL(day$)
year% = VAL(year$)


'       First name string, set limit to 16 characters
   
    DO
        COLOR 15, 1
        LOCATE 15, 4: PRINT SPACE$(75)  ' eraser
        COLOR 15, 5
        LOCATE 15, 50
        PRINT "and PRESS  {Enter}"
        LOCATE 15, 4: PRINT SPACE$(44)   ' this acts as an eraser
        LOCATE 15, 4
        INPUT "TYPE in your FIRST NAME:  ", FirstName$
        LOOP UNTIL LEN(FirstName$) <= 16
        PLAY "MBT255L16O4CDEGO6C"         ' Tune 1
        PLAY "MBT255L16O6CO4GEDC"         ' Tune 2
        LOCATE , , 0, 0, 0                ' Turn off cursor
        SLEEP (2)                         ' build a little suspense

'       Make the date a string variable (don't put DATE$ first).

D$ = DATE$

Today$ = RIGHT$(D$, 4)

'       get the right most 4 digits to process and transfer the string
'       variable into a numeric variable.

Today% = VAL(Today$)

'       Change the color to blue and white again for 2nd screen.

COLOR 15, 1
CLS
'       Draw an outline around screen with ASCII characters.
CLS
LOCATE 1, 2, 0, 0, 7
    PRINT CHR$(201); STRING$(76, 205); CHR$(187);   ' Draw top border.
    FOR I = 2 TO 23                 ' Draw left and right borders.
        LOCATE I, 2
        PRINT CHR$(186); TAB(79); CHR$(186);
    NEXT I
    LOCATE 24, 2
    PRINT CHR$(200); STRING$(76, 205); CHR$(188);   ' Draw bottom border.



COLOR 14, 7
text$ = "              "      ' Set text length
LOCATE 2, (80 \ 2) - LEN(text$) \ 2 + 1      ' Calculate the center
PRINT text$                                  ' Print text
text$ = "       B I R T H D A Y       "      ' Set text length, same variable
LOCATE 3, (80 \ 2) - LEN(text$) \ 2 + 1      ' Calculate the center
PRINT text$                                  ' Print text
text$ = "           S O N G           "      ' Set text length, same variable
LOCATE 4, (80 \ 2) - LEN(text$) \ 2 + 1      ' Calculate the center
PRINT text$                                  ' Print text
text$ = "              "      ' Set text length, same variable
LOCATE 5, (80 \ 2) - LEN(text$) \ 2 + 1      ' Calculate the center
PRINT text$                                  ' Print text

'       Displays DATE$ and the string Birthday$.

COLOR 14, 0
LOCATE 2, 5
PRINT "TODAY'S DATE"
LOCATE 4, 5
PRINT DATE$
LOCATE 2, 62
PRINT "YOUR BIRTH DATE!"
LOCATE 4, 62
PRINT BIRTHDAY$
COLOR 15, 1

'       Turns cursor off so it is not seen for rest of display
LOCATE , , 0, 0, 0

'       If the day and months do not match, go to UNBIRTHDAY SUB.

IF LEFT$(BIRTHDAY$, 5) <> LEFT$(DATE$, 5) THEN
        GOTO UNBIRTHDAY1
        ELSE GOTO BIRTHDAY1
        END IF

'       Selects the left most 5 characters to compare dates for birthday,
'       leaves out year.  If the dates match, the program goes on from here.

BIRTHDAY1:
LOCATE 7, 4
COLOR 13, 0
PRINT CHR$(201); STRING$(28, 205); CHR$(187)
LOCATE 8, 4
PRINT CHR$(186); "  Happy birthday to you . . "; CHR$(186)
LOCATE 9, 4
PRINT CHR$(200); STRING$(28, 205); CHR$(188)
COLOR 15, 1
PLAY "MF T120 L4 o3 c8 c8 d c f e2"      ' Set Music Foreground, print follows
                                         ' Set Tempo and Length to default
LOCATE 7, 47
COLOR 15, 2
PRINT CHR$(201); STRING$(28, 205); CHR$(187)
LOCATE 8, 47
PRINT CHR$(186); "  Happy birthday to you . . "; CHR$(186)
LOCATE 9, 47
PRINT CHR$(200); STRING$(28, 205); CHR$(188)
COLOR 15, 1
PLAY "c8 c8 d c g f2"

LOCATE 12, 12
PRINT "Happy birthday dear......"
COLOR 31, 4

COLOR 14, 7
text$ = "              "      ' Set text length
LOCATE 14, (80 \ 2) - LEN(text$) \ 2 + 1      ' Calculate the center
PRINT text$                                  ' Print text
        
COLOR 31, 4
text$ = "      " + UCASE$(FirstName$) + "      "   ' Set text length
LOCATE 15, (80 \ 2) - LEN(text$) \ 2 + 1      ' Calculate the center
PRINT text$                                  ' Print text
COLOR 14, 7
text$ = "              "      ' Set text length
LOCATE 16, (80 \ 2) - LEN(text$) \ 2 + 1      ' Calculate the center
PRINT text$                                  ' Print text


COLOR 15, 1
PLAY "c8 c8 o4 c o3 a f e d2"
LOCATE 18, 12
PRINT "Happy birthday to YOU.............!!"

'       Added 2 extra last notes (f2) for birthday song.
'       There are 2 EXTRA last notes at end.


PLAY "t90 b-8 b-8 a f g f2 f2 f2"

'       Program to calculate the  age on the birth date.


age% = (Today% - year%)

LOCATE 20, 28
COLOR 31, 0
PRINT "You are"; age%; "years old today!"

'       A little humor.

SLEEP (2)
COLOR 11, 13
LOCATE 22, 10
PRINT "But you Really...."
SLEEP (4)
COLOR 27, 13
LOCATE 22, 28
PRINT "R E A L L Y..."
COLOR 11, 13
SLEEP (4)

        IF age% <= 21 THEN                         ' for the old at heart
        LOCATE 22, 42
        PRINT "look Much..MUCH...O L D E R...!"
        END IF

        IF age% > 21 THEN                          ' for the young at heart
        LOCATE 22, 42
        PRINT "look Much..MUCH...Younger...!"
        END IF

SLEEP (2)
COLOR 15, 4
text$ = "    A N D    M A N Y   M O R E . . . ." ' Set text length
LOCATE 24, (80 \ 2) - LEN(text$) \ 2 + 1         ' Calculate the center
PRINT text$;                ' Print text, add ";" to keep cursor on line 24
COLOR 15, 1
                                           
PLAY "O2 L2C"                              ' the command SOUND does not work
PLAY "O1 L1CC"                             ' in the .EXE version of this

'       Turns cursor on.
LOCATE , , 1, 6, 7

'       There must be a simpler way to move around beside GOTO

IF LEFT$(BIRTHDAY$, 5) = LEFT$(DATE$, 5) THEN
        GOTO DONE
        END IF

UNBIRTHDAY1:
CALL UNBIRTHDAY(FirstName$, month%, day%, year%)

DONE:

FUNCTION EXACTDATE! (month%, day%, year%)

'       arguments must agree as to location, number and kind.
'       to call a function, you must use its name with the correct operator
'       the calculated variable must be transferred to the function name
'       and the function name used as the variable.

'      *********************** Date2Julian& ************************
'                               page 62

'       Program to calculate the  age on the birth date.

'       To make the date strings into integers.


'       Make the date a string variable

Today$ = DATE$

'       Break up the date into month, day and year.

TodayYear$ = RIGHT$(Today$, 4)
TodayMonth$ = LEFT$(Today$, 2)
TodayDay$ = MID$(Today$, 4, 2)

'       Change string expressions into integers.

TodayYear% = VAL(TodayYear$)
TodayMonth% = VAL(TodayMonth$)
TodayDay% = VAL(TodayDay$)

'       The Julian calender calculation...

IF year% < 1583 THEN
        PRINT "ERROR: Year is less than 1583"
        SYSTEM
END IF

IF month% > 2 THEN
        month% = month% - 3
ELSE
        month% = month% + 9
        year% = year% - 1
END IF

ta& = 146097 * (year% \ 100) \ 4
tb& = 1461& * (year% MOD 100) \ 4
tc& = (153 * month% + 2) \ 5 + day% + 1721119
FirstDate2Julian& = ta& + tb& + tc&

'       now calculate the Julian number for Today's date


IF TodayMonth% > 2 THEN
        TodayMonth% = TodayMonth% - 3
ELSE
        TodayMonth% = TodayMonth% + 9
        TodayYear% = TodayYear% - 1
END IF

ta& = 146097 * (TodayYear% \ 100) \ 4
tb& = 1461& * (TodayYear% MOD 100) \ 4
tc& = (153 * TodayMonth% + 2) \ 5 + TodayDay% + 1721119

SecondDate2Julian& = ta& + tb& + tc&

EXACTDATE! = (SecondDate2Julian& - FirstDate2Julian&) / 365.25


END FUNCTION

SUB UNBIRTHDAY (FirstName$, month%, day%, year%)

LOCATE 8, 5
PRINT "Happy Unbirthday to you . . ."   ' Set Music Foreground to slow print
PLAY "MF T120 L4 o3 c8 c8 d c f e2"     ' Set Tempo and Length to default
LOCATE 10, 10
PRINT "Happy Unbirthday to you . . ."
PLAY "c8 c8 d c g f2"
LOCATE 12, 15
PRINT "Happy Unbirthday dear ",
COLOR 31, 2
PRINT "   "; UCASE$(FirstName$); " . . ."
COLOR 15, 1
PLAY "c8 c8 o4 c o3 a f e d2"
LOCATE 14, 20
PRINT "Happy Unbirthday to YOU!!"
PLAY "t90 b-8 b-8 a f g f2 f2"

'       Display the exact date in a box.

COLOR 15, 4
LOCATE 17, 10
PRINT CHR$(218); STRING$(60, 196); CHR$(191)
LOCATE 18, 10
PRINT CHR$(179); SPC(60); CHR$(179)
LOCATE 18, 15
COLOR 11, 0
PRINT "You are EXACTLY  "; EXACTDATE!(month%, day%, year%); "   Years old today!"
COLOR 15, 4
LOCATE 19, 10
PRINT CHR$(192); STRING$(60, 196); CHR$(217)
COLOR 15, 1

'       Turns cursor on.
LOCATE , , 1, 6, 7
END SUB

