TITLE   "MONITOR" -- NETWORK I/O USER PROGRAM
PAGE            60,132
DATA            SEGMENT PARA PUBLIC 'DATA'

;--------------------------------------------------------------------;
; NETWORK CONTROL BLOCK ( GENERIC )                                  ;
;--------------------------------------------------------------------;
NCB             EQU     $
NCB_COMMAND     DB      00H               ;NCB COMMAND FIELD
NCB_RETCODE     DB      00H               ;NCB RETURN CODE
NCB_LSN         DB      00H               ;NCB LOCAL SESSION NUMBER
NCB_NUM         DB      00H               ;NCB NUMBER OF YOUR NAME
NCB_BUFFER@     DD      00000000H         ;NCB POINTER TO MESSAGE BUFFER
NCB_LENGTH      DW      0000H             ;NCB MESSAGE BUFFER LENGTH
NCB_CALLNAME    DB      'RAOUL DUKE      ';NCB NAME ON REMOTE ADAPTER
NCB_NAME        DB      'HUNTER THOMPSON ';NCB NAME ON LOCAL ADAPTER
NCB_RTO         DB      00H               ;NCB RECEIVE TIMEOUT
NCB_STO         DB      00H               ;NCB SEND TIMEOUT
NCB_POST@       DD      00000000H         ;NCB POINTER TO POST ROUTINE
NCB_LANA_NUM    DB      00H               ;NCB ADAPTER NUMBER (00H = 1ST ADAPTER)
NCB_CMD_CPLT    DB      00H               ;NCB COMMAND STATUS
NCB_RESERVE     DB      14 DUP(0)

CTRL_A          EQU     01H
CR              EQU     0DH
LF              EQU     0AH
ESC             EQU     1BH

ERR_MSG         DB      CR,LF,'00 NET ERROR',CR,LF,'$'
MSG_INIT        DB      CR,LF,'TALKING TO REMOTE...',CR,LF,'$'
BAD_INIT        DB      CR,LF,'HOST ENGAGED OR CRASHED',CR,LF,'$'
PROMPT          DB      CR,LF,'NET: $'
BUFFER          DB      'BUFFER'
O_BUFFER        DB      64 DUP(0)
OUTPUT          DW      0
TABLE           DB      '0123456789ABCDEF'

DATA ENDS

CSEG           SEGMENT PARA PUBLIC 'CODE'
               ASSUME CS:CSEG, DS:DATA,ES:DATA,SS:STACK
TEST           PROC FAR
               PUSH     DS             ; store stuff so we can return
               XOR      AX,AX
               PUSH     AX
               MOV      AX,DATA
               MOV      ES,AX
               MOV      DS,AX
               CALL     ADD_NAME
               MOV      NCB_COMMAND,010H ;COMMAND CODE FOR CALL
               MOV      NCB_STO,120    ;1MIN TIMEOUT
               MOV      NCB_RTO,120    ;1MIN TIMEOUT
               MOV      BX,OFFSET NCB  ;ES:BX MUST EQUAL NCB ADDRESS
               INT      5CH            ;INVOKE NETBIOS
               CMP      NCB_RETCODE,00H ;FINAL RETURN CODE OKAY?
               JE       C2             ;
               MOV      DX,OFFSET BAD_INIT
               MOV      AH,09H
               INT      21H
               JMP      EXIT
C2:
               CALL     RECEIVE        ; POST initial receive
               MOV      DX,OFFSET MSG_INIT ; tell'm we're connected
               MOV      AH,09H
               INT      21H
LOOP:
               MOV      AH,06H         ; check for keypress
               MOV      DL,0FFH
               INT      21H
               JNZ      KBD_HIT
               CMP      OUTPUT,00H     ; check for chars in output buffer
               JE       LOOP

               XOR      BX,BX          ; output chars in buffer
O_LOOP:
               MOV      AH,06H
               MOV      DL,O_BUFFER[BX]
               INT      21H
               INC      BX
               CMP      BX,OUTPUT
               JNE      O_LOOP
               MOV      OUTPUT,00H     ; clear buffer and POST receive
               CALL     RECEIVE
               JMP      LOOP

KBD_HIT:
               CMP      AL,CTRL_A      ; SEND everything but CTRL-a
               JNE      TSEND
               MOV      DX,OFFSET PROMPT
               MOV      AH,09H         ; print 'NET: ' prompt
               INT      21H
               MOV      AH,07H         ; get another char
               INT      21H
               CMP      AL,CTRL_A      ; if another ctrl-a, send it
               JE       TSEND
               MOV      BUFFER,0FFH    ; if anything else, exit
               CALL     SEND
               JMP      EXIT
TSEND:
               MOV      BUFFER,AL
               CALL     SEND
               JMP      LOOP
EXIT:
               CALL     HANGUP         ; bye bye!
               CALL     DELETE_NAME
               RET

TEST           ENDP
TALK           PROC     NEAR
               ASSUME   CS:CSEG,DS:DATA,ES:DATA,SS:STACK
;--------------------------------------------------------------------;
;      DO A NETBIOS "ADD NAME" - NAME TO USE ON THE NETWORK          ;
;--------------------------------------------------------------------;
ADD_NAME:
               MOV      NCB_COMMAND,030H ;ADDNAME COMMAND CODE
               MOV      NCB_STO,0      ;NO TIMEOUT
               MOV      NCB_RTO,0      ;NO TIMEOUT
               MOV      BX,OFFSET NCB  ;ES:BX MUST EQUAL NCB ADDRESS
               INT      5CH            ;INVOKE NETBIOS
               CMP      NCB_RETCODE,00H ;FINAL RETURN CODE OKAY?
               JE       A2
               JMP      ERROR
A2:            RET

;--------------------------------------------------------------------;
;      DO A NETBIOS "RECEIVE" - OBTAIN MESSAGE FROM THE OTHER PC     ;
;--------------------------------------------------------------------;
RECEIVE:
                MOV      NCB_COMMAND,095H ;RECEIVE COMMAND CODE
                MOV      NCB_STO,120   ;1MIN TIMEOUT
                MOV      NCB_RTO,120   ;1MIN TIMEOUT
                MOV      NCB_POST@,OFFSET POST
                MOV      NCB_POST@+2,CS
                MOV      NCB_BUFFER@,OFFSET O_BUFFER ;WHERE MESSAGE IS TO GO
                MOV      NCB_BUFFER@+2,DS
                MOV      NCB_LENGTH,040H ;HOW LONG (BYTES) MY BUFFER IS
                MOV      BX,OFFSET NCB ;ES:BX MUST EQUAL NCB ADDRESS
                INT      5CH           ;INVOKE NETBIOS
                RET

;--------------------------------------------------------------------;
;      DO A NETBIOS "SEND" - SEND MESSAGE ON THE NETWORK             ;
;--------------------------------------------------------------------;
SEND:
                MOV      NCB_COMMAND,014H ;SEND COMMAND CODE
                MOV      NCB_STO,120   ;1MIN TIMEOUT
                MOV      NCB_RTO,120   ;1MIN TIMEOUT
                MOV      NCB_BUFFER@,OFFSET BUFFER  ;PLACE THE ADDRESS OF BUFFER
                MOV      NCB_BUFFER@+2,DS ;TO SEND IN THE SEND_NCB.
                MOV      NCB_LENGTH,01H
                MOV      BX,OFFSET NCB ;ES:BX MUST EQUAL NCB ADDRESS
                INT      5CH           ;INVOKE NETBIOS
                CMP      NCB_RETCODE,00H ;FINAL RETURN CODE OKAY?
                JE       S2
                JMP      ERROR
S2:             RET
;--------------------------------------------------------------------;
;      DO A NETBIOS "HANG UP" - KILL NETWORK SESSION                 ;
;--------------------------------------------------------------------;
HANGUP:
                MOV      NCB_COMMAND,12H ;HANGUP COMMAND CODE
                MOV      NCB_STO,0     ;NO TIMEOUT
                MOV      NCB_RTO,0     ;NO TIMEOUT
                MOV      BX,OFFSET NCB ;ES:BX MUST EQUAL NCB ADDRESS
                INT      5CH           ;INVOKE NETBIOS
                RET

;--------------------------------------------------------------------;
;      DO A NETBIOS "DELETE NAME" - REMOVE NAME FROM NETWORK TABLE   ;
;--------------------------------------------------------------------;
DELETE_NAME:
                MOV      NCB_COMMAND,31H ;DELETE NAME COMMAND CODE
                MOV      NCB_STO,0     ;NO TIMEOUT
                MOV      NCB_RTO,0     ;NO TIMEOUT
                MOV      BX,OFFSET NCB ;ES:BX MUST EQUAL NCB ADDRESS
                INT      5CH           ;INVOKE NETBIOS
                RET

;--------------------------------------------------------------------;
;      SPIT OUT ERROR MESSAGE                                        ;
;--------------------------------------------------------------------;
ERROR:
                XOR      BX,BX         ;CLEAR BX
                MOV      BL,NCB_RETCODE ;GET RETURN CODE FROM NETBIOS
                AND      BL,0FH        ;GET LOW ORDER BITS
                MOV      AH,TABLE[BX]  ;LOAD HEXADECIMAL CHAR
                MOV      ERR_MSG + 3,AH ;PUT INTO ERROR MESSAGE
                MOV      BL,NCB_RETCODE ;RELOAD RETURN
                MOV      CL,4          ;GET READY TO SHIFT BITS
                SHR      BL,CL         ;SHIFT OVER HI ORDER BITS
                MOV      AH,TABLE[BX]  ;LOAD HEXADECIMAL CHAR
                MOV      ERR_MSG + 2,AH ;PUT INTO ERROR MESSAGE

                MOV      DX,OFFSET ERR_MSG ;ERROR HAS OCCURRED IN NETBIOS
                MOV      AH,09H           ;DISPLAY ERROR MESSAGE
                INT      21H

QUIT:
                RET
TALK            ENDP

POST            PROC    FAR
                PUSH    AX
                PUSH    DX
                MOV     AX,DATA
                MOV     DS,AX
                MOV     DI,DS:NCB_LENGTH
                MOV     DS:OUTPUT,DI
                POP     DX
                POP     AX
                IRET
POST            ENDP

CSEG            ENDS
STACK           SEGMENT PARA STACK 'STACK'
                DB     64 DUP('STACK   ')

STACK           ENDS
                END                    ; Eric W. DeSilva Nov 1985
