/*
 * @NET.C
 *
 * Program to provide the same functionallity as the LANtastic NET program
 * with the added ability to process indirect files (i.e. @NET @PARAMS.FIL)
*/

#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include "lantasti.h"

#define   MAX_CMDS       6
#define   MAX_CMD_SIZE   7
#define   MAX_ARGS       10
#define   MAX_ARG_SIZE   40

typedef struct
    {
    char            Command [MAX_CMD_SIZE];
    (*Function)    (void);
    } VC;

int unuse   (void);
int help    (void);
int login   (void);
int logout  (void);
int lpt     (void);
int unuse   (void);
int use     (void);
int parse   (void);
void ProcessArgs (void);

int         indx;
char        **Arguments;
char        **FileArgs;

char        Server      [17];
union {
      char        UserID      [17];
      char        Resource    [17];
      } Net;
char        Password    [17];
char        Device      [5];
int         Timeout;

VC ValidCommands [MAX_CMDS] =
    {
    "HELP",    help,
    "LOGIN",   login,
    "LOGOUT",  logout,
    "LPT",     lpt,
    "UNUSE",   unuse,
    "USE",     use
    };

FILE *CmdStream;
FILE *AltCmdStream;

char Buffer [81];

int parse (void)
{
    char *src, *dest;

    if (strncmp ("\\\\", Arguments [indx], 2) != 0) {
       strcpy (Device, Arguments [indx]);
       indx++;
    } else {
       *Device = '\0';
    }

    if (strncmp ("\\\\", Arguments [indx], 2) == 0) {
       src = Arguments [indx] + 2;
       dest = Server;
       while (*src != '\\') {
           *dest++ = *src++;
       }
       src++;
       dest = Net.UserID;
       while (*src != '\0') {
           *dest++ = *src++;
       }
       indx++;
       strcpy (Password, Arguments [indx]);
    } else {
       *Server = '\0';
       *Net.UserID = '\0';
       Timeout = atoi (Arguments [indx]);
    }
}

int help (void)
{
    parse ();
    clrscr ();
    cprintf ("\n\r@NET - LANtastic Network Functions with Indirect File Support");
    cprintf ("\n\r\n\rSupported commands are:");
    cprintf ("\n\r        HELP        - Display this screen");
    cprintf ("\n\r        LOGIN       - Login to a server");
    cprintf ("\n\r        LOGOUT      - Log out of a server");
    cprintf ("\n\r        USE         - Use a resource of a server");
    cprintf ("\n\r        UNUSE       - Release a resource of a server");
    cprintf ("\n\r        LPT TIMEOUT - Set printer timeouts");
    cprintf ("\n\r");
    cprintf ("\n\r        @<FNAME>    - Execute commands from file <FNAME>");
    cprintf ("\n\r\n\rPress a key to continue");
    getch ();

    return 0;
}

int login (void)
{
    int retc = FALSE;

    retc = ServerLogin (Server, Net.UserID, Password);
    return (retc);
}

int logout (void)
{
    return (ServerLogout (Server));
}

int lpt (void)
{
    return (SetPtrTimeout ((int) Timeout * 18.2));
}

int unuse (void)
{
    return (RedirectCancel (Device));
}

int use (void)
{
    int     DevType;
    char    RemoteName [40];

    sprintf (RemoteName, "\\\\%s\\%s", Server, Net.Resource);
    if (strlen (Device) > 2) {
       DevType = DevTypePtr;
    } else {
       DevType = DevTypeDsk;
    }
    return (RedirectDevice (DevType, Device, RemoteName));
}

void ProcessArgs (void)
{
    int j;

    j = 0;
    indx = 1;
    strupr (Arguments [indx]);
    while ((strcmp (Arguments [indx], ValidCommands[j].Command) != 0) & (j < MAX_CMDS)) {
        j++;
    }
    if (j < MAX_CMDS) {
        indx++;
        parse ();
        (ValidCommands[j].Function) ();
    } else {
        cprintf ("\n\rInvalid command: <%s>", Arguments [indx]);
    }
}

main (int argc, char **argv)
{
    int     j;
    char    *ptr;

    clrscr ();
    if (argc < 2) {
       help ();
       exit (1);
    }
    Arguments = argv;
    if (argv [1][0] == '@') {
       if ((CmdStream = fopen(&argv [1][1], "rt")) == NULL) {
          cprintf ("\n\n\rUnable to open indirect file %s\n\r", argv [1]);
       } else {
          FileArgs = calloc (MAX_ARGS, MAX_ARG_SIZE);
          Arguments = FileArgs;
          while (NULL != fgets (Buffer, sizeof (Buffer) - 1, CmdStream)) {
              FileArgs [0] = "@NET.C";
              j = 1;
              ptr = strtok (Buffer, " ");
              while (ptr != NULL) {
                  if ((j == 1) & (stricmp (ptr, "NET") == 0)) {
                      ptr = strtok (NULL, " ");
                  } else {
                      FileArgs [j] = calloc (1, strlen (ptr) + 1);
                      strcpy (FileArgs [j], ptr);
                      ptr = strtok (NULL, " ");
                      j++;
                  }
              }
              j--;
              ptr = strchr (FileArgs [j], '\n');
              if (ptr != NULL) {
                 *ptr = '\0';
              }
              ProcessArgs ();
          }
       }
    } else {
       ProcessArgs ();
    }
}

