TITLE   RAMSPY
.MODEL  tiny
PAGE    60,80
.CODE

RAMSPY: mov     ah,0Fh                  ; Bildschirmmode holen
       int     10h
       cmp     al,2                    ; mono 80x25
       je      do
       cmp     al,3                    ; color 80x25
       je      color
       cmp     al,7                    ; mono
       je      do

       mov     dx,Offset error+100h
       mov     ah,9
       int     21h
       int     20h                     ;Ende
;-----------------------------
color: mov     CS:screen+100h,0B800h   ;set to color display

do:    mov     dx,offset copyr+100h    ;show copyright and wait for key
       mov     ah,9
       int     21h
       mov     ah,8
       int     21h

       mov     ax,CS:Screen+100h
       mov     ds,ax
       mov     ax,0                    ; Segmentzeiger auf 0000
       mov     es,ax
       mov     cx,0
       mov     bx,0                    ; Zeiger auf 1. Bildschirmzeile
       mov     ax,7020h                ; Wei auf Schwarz und Leerstelle
schl1: mov     Word Ptr DS:[bx],ax
       inc     bx
       inc     bx
       cmp     bx,0a0h                 ; schon in der 2. Zeile ???
       jl      schl1
       mov     bx,8
       mov     al,':'
       mov     Byte Ptr DS:[bx],al
       mov     ax,0
       mov     bx,6
       call    ausg
       mov     bx,10h
       call    ausg
bild:  mov     dx,0a0h                 ; Zeiger im Bildschirmbereich Zeile 2
schl2: mov     bx,cx
       mov     al,Byte Ptr ES:[bx]
       mov     ah,2                    ; Grn auf Schwarz
       mov     bx,dx
       mov     Word Ptr DS:[bx],ax
       inc     cx
       inc     dx
       inc     dx
       cmp     dx,01f40h               ; VGA (normal = 0fa0)
       jl      schl2
       sub     cx,0f50h                ; Datenzeiger rcksetzen
zeich: mov     ah,6                    ; Funktion Tastatur/Bildschirm
       mov     dl,0ffh                 ; Zeichen von der Tastatur
       int     021h                    ; Funktionsinterrupt von DOS
       je      bild                    ; keine Taste gedrckt
       cmp     al,0
       je      analys
       jmp     schl
analys:mov     ah,6
       mov     dl,0ffh
       int     021h
       cmp     al,48h
       je      cup
       cmp     al,50h
       je      cdn
       cmp     al,4dh
       je      crt
       cmp     al,4bh
       je      clt
       cmp     al,51h
       je      pgdn
       cmp     al,49h
       je      pgup
       jmp     bild
clt:   cmp     cx,0
       je      clt1
       dec     cx
       jmp     aender
clt1:  mov     ax,es
       sub     ax,5
       mov     es,ax
       mov     cx,4fh
       jmp     aender
crt:   cmp     cx,4fh
       je      crt1
       inc     cx
       jmp     aender
crt1:  mov     ax,es
       add     ax,5
       mov     es,ax
       mov     cx,0
       jmp     aender
cup:   mov     ax,es
       sub     ax,5
       mov     es,ax
       jmp     aender
cdn:   mov     ax,es
       add     ax,5
       mov     es,ax
       jmp     aender
pgup:  mov     ax,es
       sub     ax,00f0h
       mov     es,ax
       jmp     aender
pgdn:  mov     ax,es
       add     ax,00f0h
       mov     es,ax
aender:mov     ax,es
       mov     bx,6
       call    ausg
       mov     ax,cx
       mov     bx,10h
       call    ausg
       jmp     bild
ana2:  mov     bx,cx
       mov     ax,Word Ptr ES:[bx]
       mov     bl,ah
       mov     bh,al
       mov     ax,bx
       mov     bx,20h
       call    ausg
       jmp     bild
ana3:  call    eing
       mov     es,ax
       jmp     aender
schl:  cmp     al,0dh
       je      ana2
       cmp     al,69h
       je      ana3
       cmp     al,1bh
       je      rueck
       jmp     bild
rueck: ret                             ; Rcksprung zu DOS

ausg:  push    ax                      ; AX = Wert
       push    bx                      ; BX = Bildschirmposition
       push    cx
       push    dx
       push    ds
ainit: mov     cx,CS:Screen+100h
       mov     ds,cx
       mov     cx,4
       mov     dx,ax
aloop: mov     ax,dx
       shr     dx,1
       shr     dx,1
       shr     dx,1
       shr     dx,1
       and     ax,0fh
       cmp     ax,0ah
       jl      adez
       add     ax,37h
       jmp     acont
adez:  add     ax,30h
acont: mov     Byte Ptr DS:[bx],al
       dec     bx
       dec     bx
       dec     cx
       jne     aloop
       pop     ds
       pop     dx
       pop     cx
       pop     bx
       pop     ax
       ret

eing:  push    cx                      ; AX = Wert
       push    dx
       push    ds
       mov     ax,40h
       mov     ds,ax
       mov     bx,50h
       mov     ax,0
       mov     Word Ptr DS:[bx],ax     ; Kursor auf Zeile 0 Spalte 0
       mov     ah,2
       mov     dl,0dh
       int     021h
       mov     ax,CS:Screen+100h
       mov     ds,ax
       mov     bx,0
       mov     ax,730h
eloop: mov     Word Ptr DS:[bx],ax
       inc     bx
       inc     bx
       cmp     bx,8
       jl      eloop                   ; Zeile lschen
       mov     bx,0
zeing: mov     ah,6
       mov     dl,0ffh
       int     021h
       je      zeing
       cmp     al,0dh                 ; Return
       je      cr
       cmp     al,30h
       jl      zeing
       cmp     al,39h
       jle     zaus
       cmp     al,61h
       jl      zeing
       cmp     al,66h
       jle     zaus
       jmp     zeing
zaus:  mov     ah,2
       mov     dl,al
       int     021h
       inc     bx
       inc     bx
       cmp     bx,8
       jl      zeing
cr:    mov     bx,0
       mov     cx,0
cloop: mov     ax,Word Ptr DS:[bx]
       and     ax,0ffh
       cmp     ax,39h
       jle     zahl
       sub     ax,57h
       jmp     zcont
zahl:  sub     ax,30h
zcont: add     cx,ax
       inc     bx
       inc     bx
       cmp     bx,6
       jg      zrueck
       shl     cx,1
       shl     cx,1
       shl     cx,1
       shl     cx,1
       jmp     cloop
zrueck:mov     ax,cx
       pop     ds
       pop     dx
       pop     cx
       ret

Screen dw 0B000h                         ; Bildschirmspeicher mono (farb = 0b800h)

copyr  db 'RAMSPY 1.20  revised by UComp Jan. 1991',0dh,0ah,0ah
       db 'Usage:',0dh,0ah
       db 'Up, Down, PgUp, PgDn       Go through memory by line or page.',0dh,0ah
       db 'Enter                      Display Hex-Value of word in top left corner.',0dh,0ah
       db 'ESC                        End Program.',0dh,0ah,0ah
       db 'Hit any key to start ...$'

error  db 7,'RAMSPY can`t start in present video mode !',0dh,0ah,'$'

       END  RAMSPY
