/*----------------------------- Module Header --------------------------------
 * timeout.c - A simple batch file wait utility.
 *
 * Revision History:
 *
 * 26-Aug-1991 Created by Eric Brown, who donates it to the public domain
 *             and as such makes no warrantees nor assumes any liability.
 *
 * 28-Oct-1991 Modified by Hans-Georg Michna, Munich, Germany,
 *             CompuServe: 74776,2361  Internet: 74776.2361@compuserve.com
 *             Changed such that DOS errorlevel is 1 if timeout occurs.
 *             Errorlevel remains 0 if a key is hit. The program can now
 *             be used as a security device, for example to boot into a
 *             BIOS password request if no menu choice is made.
 *--------------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

void Usage(void);

int main(int argc, char **argv[])
{
    time_t  tWait = 0, tNow = 0L, tEnd = 0L;

    if (argc > 1) {
        if ((char)argv[1][0] == (char)'-' || (char)argv[1][0] == (char)'/') {
            Usage();
            return 0;
        }
        tWait = (time_t)atoi((char *)argv[1]);
        if (tWait < 0) {
            tWait = 0;
        }
    }

    time(&tNow);

    tEnd = tNow + tWait;

    printf("Waiting %ld seconds, press a key to continue, CTRL+C to interrupt.",
           tWait);

    do {
        if (kbhit()) {
	    exit(0);
        }

        time(&tNow);

    } while (tNow < tEnd);

    exit(1);
}

void Usage(void)
{
    printf("\n\
TIMEOUT - This utility is similar to the DOS PAUSE command.  However, it\n\
	  accepts a timeout parameter to specify a length of wait (in seconds)\n\
	  at which time it will continue without a key press. If no key is\n\
	  pressed, a DOS errorlevel of 1 is returned.\n\
\n\
Usage -   TIMEOUT ###\n\
	  where ### is a decimal number of seconds.\n\
\n\
Written by Eric Brown, Seattle, WA, 16-Sep-1991.\n\
Modified by Hans-Georg Michna, Munich, Germany, 28-Oct-1991.\n");

    return;
}
