/****************************************************************/
/*								*/
/*	whelp.c							*/
/*								*/
/*	A command line interface for winhelp			*/
/*								*/
/*	Created 1-6-92 M.Dobie					*/
/*								*/
/****************************************************************/

/*
	Copyright
	---------

	whelp is copyright 1992 by Mark Dobie

	Permission to use, copy, modify, distribute, and sell this software
	and its documentation for any purpose is hereby granted without fee,
	provided that the above copyright notice appear in all copies and
	that both that copyright notice and this permission notice appear
	in supporting documentation.
*/

#define	STRICT

#include	<windows.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>

/****************************************************************/

/*
	win_error

	Display an error message on the screen...
*/

void	win_error(char far *message)
{
	MessageBeep(MB_ICONHAND) ;
	MessageBox((HWND)NULL, message, "Program Error",
		   MB_ICONHAND | MB_OK | MB_TASKMODAL) ;
}

/****************************************************************/

/*
	Command line processing.

	whelp [-f helpfile] topic

 -	cmd_line is the command line to process
 -	help_file will be set to the help file to look at
	"" => none specified
 -	help_topic is the topic to look up
	"" => none specified
*/

static	void	process_command_line(char far *cmd_line,
				     char far *help_file,
				     char far *help_topic)
{
	char far	*token ;
	int		got_helpfile ;

	token = strtok(cmd_line, " ") ;
	if (token == NULL)
	{
		*help_file = *help_topic = '\0' ;
		return ;
	}

	got_helpfile = FALSE ;

	/* Is it the helpfile option? */
	if (((*token     == '-') || (*token     == '/')) &&
	    ((*(token+1) == 'f') || (*(token+1) == 'F')))
		got_helpfile = TRUE ;

	if (got_helpfile)
	{
		/* Get the help file name */
		token = strtok(NULL, " ") ;
		if (token == NULL)
			*help_file = '\0' ;
		else
			strcpy(help_file, token) ;

		/* Get the help topic name */
		token = strtok(NULL, " ") ;
		if (token == NULL)
			*help_topic = '\0' ;
		else
			strcpy(help_topic, token) ;
	}
	else
	{
		*help_file = '\0' ;
		strcpy(help_topic, token) ;
	}
	return ;
}

/****************************************************************/

/*
	This is like main.
*/

int	PASCAL	WinMain(HINSTANCE instance, HINSTANCE prev_instance,
	                LPSTR cmd_param, int cmd_show)
{
	char	help_file[BUFSIZ] ;
	char	help_topic[BUFSIZ] ;

	process_command_line(cmd_param, help_file, help_topic) ;

	/* Usage message */
	if ((*help_topic == '\0') && (*help_file == '\0'))
	{
		win_error("usage : whelp [/F helpfile] topic") ;
		exit(1) ;
	}

	/* What is the help file? */
	if (*help_file == '\0')
		strcpy(help_file, "win31wh.hlp") ;

	/* Try to invoke winhelp with the topic */
	WinHelp(GetDesktopWindow(),
		help_file,
		HELP_PARTIALKEY,
		(DWORD)(char far *)help_topic) ;

	return(0) ;
}
