// ============================================================================
// profile.c -- code for dealing with the configuration file.
// ============================================================================


#include <windows.h>
#include "resgauge.h"


// ============================================================================
// > > > > > > > > > > > > > > >  code  begins  < < < < < < < < < < < < < < < <
// ============================================================================
// Retrieves the program configuration.
// ----------------------------------------------------------------------------
void
FAR
PASCAL
GetConfig(void)
{
    char szApp[32];
    char szKey[32];
    char szProfile[32];
    char szString[32];
    char szTmp[32];
    WORD wTmp;

    // load the application name and the profile name
    LoadString(GhInst, IDS_APPLICATION, szApp, sizeof(szApp) - 1);
    LoadString(GhInst, IDS_PROFILE, szProfile, sizeof(szProfile) - 1);

    // get the monitor mode
    LoadString(GhInst, IDS_MONITOR, szKey, sizeof(szKey) - 1);
    LoadString(GhInst, GcfgDef.wMonitor, szTmp, sizeof(szTmp) - 1);
    GetPrivateProfileString(szApp,
                            szKey,
                            szTmp,
                            szString,
                            sizeof(szString),
                            szProfile);
    LoadString(GhInst, IDS_GDI, szTmp, sizeof(szTmp) - 1);
    if ( lstrcmpi(szString, szTmp) == 0 )
    {
        GcfgCur.wMonitor = MONITOR_GDI;
    }
    else
    {
        LoadString(GhInst, IDS_USER, szTmp, sizeof(szTmp) - 1);
        if ( lstrcmpi(szString, szTmp) == 0 )
            GcfgCur.wMonitor = MONITOR_USER;
        else
            GcfgCur.wMonitor = MONITOR_BOTH;
    }

    // get the alarm setting
    LoadString(GhInst, IDS_ALARM_ENABLED, szKey, sizeof(szKey) - 1);
    wTmp = GetPrivateProfileInt(szApp,
                                szKey,
                                GcfgDef.fAlarmEnabled,
                                szProfile);
    if ( wTmp )
        GcfgCur.fAlarmEnabled = TRUE;
    else
        GcfgCur.fAlarmEnabled = FALSE;

    // get the alarm type
    LoadString(GhInst, IDS_ALARM_TYPE, szKey, sizeof(szKey) - 1);
    LoadString(GhInst, GcfgDef.wAlarmType, szTmp, sizeof(szTmp) - 1);
    GetPrivateProfileString(szApp,
                            szKey,
                            szTmp,
                            szString,
                            sizeof(szString),
                            szProfile);
    LoadString(GhInst, IDS_FLASH, szTmp, sizeof(szTmp) - 1);
    if ( lstrcmpi(szString, szTmp) == 0 )
        GcfgCur.wAlarmType = ALARM_FLASH;
    else
        GcfgCur.wAlarmType = ALARM_BEEP;

    // get the threshold value
    LoadString(GhInst, IDS_THRESHOLD, szKey, sizeof(szKey) - 1);
    wTmp = GetPrivateProfileInt(szApp, szKey, GcfgDef.wThreshold, szProfile);
    GcfgCur.wThreshold = max(min(wTmp, 99), 1);

    // get the "keep on top" setting
    LoadString(GhInst, IDS_KEEP_ON_TOP, szKey, sizeof(szKey) - 1);
    wTmp = GetPrivateProfileInt(szApp, szKey, 0, szProfile);
    if ( wTmp )
        GcfgCur.fKeepOnTop = TRUE;
    else
        GcfgCur.fKeepOnTop = FALSE;

    // get the gauge color for GDI
    LoadString(GhInst, IDS_COLOR_GDI, szKey, sizeof(szKey) - 1);
    wsprintf(szTmp, "%lX", GcfgDef.dwColorGDI);
    GetPrivateProfileString(szApp,
                            szKey,
                            szTmp,
                            szString,
                            sizeof(szString),
                            szProfile);
    if ( DecodeHexString(szString, &(GcfgCur.dwColorGDI)) != 0 )
        GcfgCur.dwColorGDI = GcfgDef.dwColorGDI;

    // get the gauge color for User
    LoadString(GhInst, IDS_COLOR_USER, szKey, sizeof(szKey) - 1);
    wsprintf(szTmp, "%lX", GcfgDef.dwColorUser);
    GetPrivateProfileString(szApp,
                            szKey,
                            szTmp,
                            szString,
                            sizeof(szString),
                            szProfile);
    if ( DecodeHexString(szString, &(GcfgCur.dwColorUser)) != 0 )
        GcfgCur.dwColorUser = GcfgDef.dwColorUser;

    // get the gauge color for both
    LoadString(GhInst, IDS_COLOR_BOTH, szKey, sizeof(szKey) - 1);
    wsprintf(szTmp, "%lX", GcfgDef.dwColorBoth);
    GetPrivateProfileString(szApp,
                            szKey,
                            szTmp,
                            szString,
                            sizeof(szString),
                            szProfile);
    if ( DecodeHexString(szString, &(GcfgCur.dwColorBoth)) != 0 )
        GcfgCur.dwColorBoth = GcfgDef.dwColorBoth;
} // GetConfig


// ----------------------------------------------------------------------------
// Saves the program configuration.
// ----------------------------------------------------------------------------
void
FAR
PASCAL
SaveConfig(void)
{
    char szApp[32];
    char szKey[32];
    char szProfile[32];
    char szString[32];
    WORD wTmp;

    // load the application name and the profile name
    LoadString(GhInst, IDS_APPLICATION, szApp, sizeof(szApp) - 1);
    LoadString(GhInst, IDS_PROFILE, szProfile, sizeof(szProfile) - 1);

    // save the monitor mode
    if ( GcfgCur.wMonitor == MONITOR_GDI )
        wTmp = IDS_GDI;
    else if ( GcfgCur.wMonitor == MONITOR_USER )
        wTmp = IDS_USER;
    else
        wTmp = IDS_BOTH;
    LoadString(GhInst, IDS_MONITOR, szKey, sizeof(szKey) - 1);
    LoadString(GhInst, wTmp, szString, sizeof(szString) - 1);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);

    // save the alarm setting
    if ( GcfgCur.fAlarmEnabled )
        wTmp = IDS_TRUE;
    else
        wTmp = IDS_FALSE;
    LoadString(GhInst, IDS_ALARM_ENABLED, szKey, sizeof(szKey) - 1);
    LoadString(GhInst, wTmp, szString, sizeof(szString) - 1);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);

    // save the alarm type
    if ( GcfgCur.wAlarmType == ALARM_FLASH )
        wTmp = IDS_FLASH;
    else
        wTmp = IDS_BEEP;
    LoadString(GhInst, IDS_ALARM_TYPE, szKey, sizeof(szKey) - 1);
    LoadString(GhInst, wTmp, szString, sizeof(szString) - 1);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);

    // save the threshold value
    wsprintf(szString, "%u", GcfgCur.wThreshold);
    LoadString(GhInst, IDS_THRESHOLD, szKey, sizeof(szKey) - 1);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);

    // save the gauge color for GDI
    LoadString(GhInst, IDS_COLOR_GDI, szKey, sizeof(szKey) - 1);
    wsprintf(szString, "%lX", GcfgCur.dwColorGDI);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);

    // save the gauge color for User
    LoadString(GhInst, IDS_COLOR_USER, szKey, sizeof(szKey) - 1);
    wsprintf(szString, "%lX", GcfgCur.dwColorUser);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);

    // save the gauge color for both
    LoadString(GhInst, IDS_COLOR_BOTH, szKey, sizeof(szKey) - 1);
    wsprintf(szString, "%lX", GcfgCur.dwColorBoth);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);
} // SaveConfig


// ----------------------------------------------------------------------------
// Saves the "keep on top" setting.
// ----------------------------------------------------------------------------
void
FAR
PASCAL
SaveKeepOnTop(void)
{
    char szApp[32];
    char szKey[32];
    char szProfile[32];
    char szString[32];
    WORD wTmp;

    // load the application name and the profile name
    LoadString(GhInst, IDS_APPLICATION, szApp, sizeof(szApp) - 1);
    LoadString(GhInst, IDS_PROFILE, szProfile, sizeof(szProfile) - 1);

    // save the setting
    if ( GcfgCur.fKeepOnTop )
        wTmp = IDS_TRUE;
    else
        wTmp = IDS_FALSE;
    LoadString(GhInst, IDS_KEEP_ON_TOP, szKey, sizeof(szKey) - 1);
    LoadString(GhInst, wTmp, szString, sizeof(szString) - 1);
    WritePrivateProfileString(szApp, szKey, szString, szProfile);
} // SaveKeepOnTop


// ----------------------------------------------------------------------------
// Decodes a hex string into a DWORD in the caller.  The hex string can be no
// longer than 8 characters, and an invalid character will abort decoding and
// cause the function to return 1.
// ----------------------------------------------------------------------------
UINT
FAR
PASCAL
DecodeHexString(
LPSTR       lpstrValue,
DWORD FAR * dwValue)
{
    char    chTmp;
    int     nChars;
    DWORD   dwTmp;
    LPSTR   lpstrTmp;
    UINT    uiReturn;

    // assume failure
    uiReturn = 1;

    // initialize
    lpstrTmp = lpstrValue;
    nChars = 0;
    dwTmp = 0;

    // traverse the string
    while ( (*lpstrTmp) && (nChars < 8) )
    {
        chTmp = *lpstrTmp++;
        ++nChars;
        dwTmp <<= 4;
        if ( (chTmp >= '0') && (chTmp <= '9') )
            dwTmp += chTmp - '0';
        else if ( (chTmp >= 'a') && (chTmp <= 'f') )
            dwTmp += chTmp - 'a' + 10;
        else if ( (chTmp >= 'A') && (chTmp <= 'F') )
            dwTmp += chTmp - 'A' + 10;
        else
            break;
    }

    if ((*lpstrTmp == 0) && (nChars <= 8) )
    {
        *dwValue = dwTmp;
        uiReturn = 0;
    }

    return(uiReturn);
} // DecodeHexString


// ================
// end of profile.c
// ================
