// ============================================================================
// resgauge.h -- header file for ResGauge.
// ============================================================================


#ifndef RESGAUGE_H
    #define RESGAUGE_H

    // -------------
    // menu item IDs
    // -------------
    #define SC_KEEP_ON_TOP    100
    #define SC_CONFIGURE      101
    #define SC_ABOUT          102

    // --------------
    // dialog box IDs
    // --------------
    #define IDDB_ABOUT        1
    #define IDDB_CONFIGURE    2

    // --------------------------
    // "About..." dialog item IDs
    // --------------------------
    #define IDD_ABOUT1        100
    #define IDD_ABOUT2        101
    #define IDD_ABOUT3        102
    #define IDD_ABOUT4        103
    #define IDD_ABOUT5        104
    #define IDD_ABOUT6        105
    #define IDD_ABOUT7        106
    #define IDD_ABOUT8        107
    #define IDD_ABOUT9        108
    #define IDD_ABOUT10       109
    #define LAST_ABOUT        109

    // ------------------------------
    // "Configure..." dialog item IDs
    // ------------------------------
    #define IDD_USER          100
    #define IDD_GDI           101
    #define IDD_BOTH          102
    #define IDD_GAUGE_COLOR   103
    #define IDD_ENABLE        104
    #define IDD_BEEP          105
    #define IDD_FLASH         106
    #define IDD_THRESHOLD     107
    #define IDD_MINUS         108
    #define IDD_PLUS          109
    #define IDD_APPLY         110
    #define IDD_DEFAULT       111
    #define LAST_CONFIG       111
    #define IDD_PERCENT       112

    // ----------------
    // string table IDs
    // ----------------
    #define IDS_ALARM_ENABLED 1
    #define IDS_ALARM_TYPE    2
    #define IDS_APPLICATION   3
    #define IDS_BEEP          4
    #define IDS_BOTH          5
    #define IDS_COLOR_BOTH    6
    #define IDS_COLOR_GDI     7
    #define IDS_COLOR_USER    8
    #define IDS_FALSE         9
    #define IDS_FLASH         10
    #define IDS_FORMAT_BOTH   11
    #define IDS_FORMAT_GDI    12
    #define IDS_FORMAT_USER   13
    #define IDS_GDI           14
    #define IDS_KEEP_ON_TOP   15
    #define IDS_MONITOR       16
    #define IDS_PROFILE       17
    #define IDS_THRESHOLD     18
    #define IDS_TIMER_ERROR   19
    #define IDS_TRUE          20
    #define IDS_USER          21

    #define IDSM_ABOUT        22
    #define IDSM_CONFIGURE    23
    #define IDSM_KEEP_ON_TOP  24

    #ifndef RC_INVOKED
        // -----------------------
        // miscellaneous constants
        // -----------------------
        #define TIMER_ID  1
        #define TIMER_MS  500
        #define WM_REVERT WM_USER

        // --------------------
        // enumerated constants
        // --------------------
        enum
        {
            ALARM_BEEP,
            ALARM_FLASH
        };
        enum
        {
            MONITOR_USER,
            MONITOR_GDI,
            MONITOR_BOTH
        };

        // --------------
        // data structure
        // --------------
        typedef struct config
        {
            BOOL  fAlarmEnabled; // TRUE if the alarm is enabled
            BOOL  fKeepOnTop;    // TRUE if "Keep on top" is selected
            WORD  wAlarmType;    // beep or flash
            WORD  wMonitor;      // GDI, User, or both
            WORD  wThreshold;    // percent at which alarm sounds
            DWORD dwColorGDI;    // gauge color for GDI
            DWORD dwColorUser;   // gauge color for User
            DWORD dwColorBoth;   // gauge color for both
        } CONFIG;
        typedef CONFIG * PCONFIG;

        typedef struct offset
        {
            WORD wX;
            WORD wY;
        } OFFSET;

        // -------
        // about.c
        // -------
        BOOL CALLBACK AboutDlgProc(HWND   hDlg,
                                   UINT   msg,
                                   WPARAM wParam,
                                   LPARAM lParam);

        // --------
        // config.c
        // --------
        BOOL CALLBACK ConfigDlgProc(HWND   hDlg,
                                    UINT   msg,
                                    WPARAM wParam,
                                    LPARAM lParam);
        void FAR PASCAL InitConfigDlg(HWND hDlg);
        BOOL FAR PASCAL ConfigCommand(HWND    hDlg,
                                      PCONFIG pConfig,
                                      WPARAM  wParam,
                                      LPARAM  lParam);
        void FAR PASCAL EnableAlarmControls(HWND hDlg,
                                            BOOL fEnable);
        BOOL FAR PASCAL DoColor(HWND        hWnd,
                                DWORD FAR * lpdwColor);

        // ------
        // init.c
        // ------
        void FAR PASCAL ProcessCmdLine(LPSTR lpstrCmdLine);
        BOOL FAR PASCAL InitApplication(HINSTANCE hPrevInstance);
        BOOL FAR PASCAL InitInstance(void);

        // ---------
        // profile.c
        // ---------
        void FAR PASCAL SaveConfig(void);
        void FAR PASCAL GetConfig(void);
        void FAR PASCAL SaveKeepOnTop(void);
        UINT FAR PASCAL DecodeHexString(LPSTR       lpstrValue,
                                        DWORD FAR * dwValue);

        // ----------
        // resgauge.c
        // ----------
        LRESULT WINAPI MainWndProc(HWND   hWnd,
                                   UINT   msg,
                                   WPARAM wParam,
                                   LPARAM lParam);
        void FAR PASCAL MainCreate(HWND hWnd);
        void FAR PASCAL MainPaint(HWND hWnd);
        void FAR PASCAL MainTimer(HWND hWnd);
        void FAR PASCAL HandleKeepOnTop(HWND  hWnd,
                                        HMENU hMenu,
                                        BOOL  fKeepOnTop);
        void FAR PASCAL CenterDialog(HWND hDlg);
        WORD FAR PASCAL GetSystemResources(void);
        void FAR PASCAL FormatLabel(void);

        // --------------------------------------------------------------------
        // preprocessor macros to make globals resident in the main module:
        //     GARRAY() is used for global arrays;
        //     GINIT() is used for explicitly initialized globals; and
        //     GLOBAL() is used for all other globals.
        // --------------------------------------------------------------------
        #ifdef MAIN
            #define GARRAY(X, Y) X[Y]
            #define GINIT(X, Y)  X = Y
            #define GLOBAL(X)    X
        #else
            #define GARRAY(X, Y) extern X[Y]
            #define GINIT(X, Y)  extern X
            #define GLOBAL(X)    extern X
            extern CONFIG GcfgDef; // ugly but necessary
        #endif

        // ----------------------------
        // global/external declarations
        // ----------------------------
        GARRAY(char      GszBuf, 8);

        GLOBAL(CONFIG    GcfgCur);
        GLOBAL(HINSTANCE GhInst);
        GLOBAL(WORD      GwFree);
    #endif


#endif


// =================
// end of resgauge.h
// =================
