// ============================================================================
// init.c -- initialization code for ResGauge.
// ============================================================================


#include <windows.h>
#include "resgauge.h"


// ============================================================================
// > > > > > > > > > > > > > > >  code  begins  < < < < < < < < < < < < < < < <
// ============================================================================
// Processes the command line.
// ----------------------------------------------------------------------------
void
FAR
PASCAL
ProcessCmdLine(
LPSTR    lpstrCmdLine) // command line
{
    char szTmp[32];

    if ( *lpstrCmdLine )
    {
        LoadString(GhInst, IDS_GDI, szTmp, sizeof(szTmp) - 1);
        if ( lstrcmpi(lpstrCmdLine, szTmp) == 0 )
        {
            GcfgCur.wMonitor = MONITOR_GDI;
        }
        else
        {
            LoadString(GhInst, IDS_USER, szTmp, sizeof(szTmp) - 1);
            if ( lstrcmpi(lpstrCmdLine, szTmp) == 0 )
            {
                GcfgCur.wMonitor = MONITOR_USER;
            }
            else
            {
                LoadString(GhInst, IDS_BOTH, szTmp, sizeof(szTmp) - 1);
                if ( lstrcmpi(lpstrCmdLine, szTmp) == 0 )
                    GcfgCur.wMonitor = MONITOR_BOTH;
            }
        }
    }
} // ProcessCmdLine


// ----------------------------------------------------------------------------
// Initializes the window data and registers the window class.
// ----------------------------------------------------------------------------
BOOL
FAR
PASCAL
InitApplication(
HINSTANCE    hPrevInstance) // previous instance
{
    char     szApp[32];
    BOOL     fReturn;
    WNDCLASS wndclass;

    if ( hPrevInstance )
    {
        fReturn = TRUE;
    }
    else
    {
        // load the application name
        LoadString(GhInst, IDS_APPLICATION, szApp, sizeof(szApp) - 1);

        // register the main window class
        wndclass.style         = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc   = MainWndProc;
        wndclass.cbClsExtra    = 0;
        wndclass.cbWndExtra    = 0;
        wndclass.hInstance     = GhInst;
        wndclass.hIcon         = NULL;
        wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
        wndclass.lpszMenuName  = szApp;
        wndclass.lpszClassName = szApp;
        fReturn = RegisterClass(&wndclass);
    }

    return(fReturn);
} // InitApplication


// ----------------------------------------------------------------------------
// Creates the main window.
// ----------------------------------------------------------------------------
BOOL
FAR
PASCAL
InitInstance(void)
{
    char szApp[32];
    char szError[32];
    BOOL fReturn;
    HWND hWnd;

    // assume failure
    fReturn = FALSE;

    // load the application name
    LoadString(GhInst, IDS_APPLICATION, szApp, sizeof(szApp) - 1);

    // create the main window
    hWnd = CreateWindow(szApp,
                        szApp,
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        0,
                        0,
                        GhInst,
                        NULL);
    if ( hWnd )
    {
        if ( SetTimer(hWnd, TIMER_ID, TIMER_MS, NULL) )
        {
            // normally, we'd call ShowWindow() with nCmdShow, but in this
            // case, we want the app to start up iconic, so we use
            // SW_SHOWMINNOACTIVE
            ShowWindow(hWnd, SW_SHOWMINNOACTIVE);
            UpdateWindow(hWnd);
            fReturn = TRUE;
        }
        else
        {
            // load the error string and tell the user what happened
            LoadString(GhInst, IDS_TIMER_ERROR, szError, sizeof(szError) - 1);
            MessageBox(hWnd, szError, szApp, MB_ICONEXCLAMATION | MB_OK);
        }
    }

    return(fReturn);
} // InitInstance


// =============
// end of init.c
// =============
