
#include "windows.h"
#include "arrange.h"
#include "string.h"
#include "time.h"
#include "dos.h"
#include "io.h"
#include "math.h"
#include "stdlib.h"

HANDLE hInst; HWND hWnd; int TimerID = 1;
HWND hWnds[200]; char inifile[144]; int moa=0,soe=0,aoa=0;

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance; HANDLE hPrevInstance; LPSTR lpCmdLine; int nCmdShow;
{
    MSG msg;
    GetWindowsDirectory(inifile,144);
    strcat(inifile,"\\arrange.ini");
    if (!hPrevInstance) if (!InitApplication(hInstance)) return (FALSE);
    if (!InitInstance(hInstance, nCmdShow)) return (FALSE);
    if (moa == 1) DestroyWindow(hWnd);
    while (GetMessage(&msg, NULL, NULL, NULL)) {
        TranslateMessage(&msg); DispatchMessage(&msg); }
    return (msg.wParam);
}

BOOL FileExists(PSTR pch)
{
        int fh;
        if ((fh = _lopen((LPSTR) pch, 0)) < 0) return(FALSE); _lclose(fh);
        return(TRUE);
}

int SaveLoc(sWnd,head)
HWND sWnd; char *head;
{
        char szText[100];
        RECT lpRect; int yw;
        if (strnicmp(head,"vp_win",6) == 0) return(0);
        GetWindowRect(sWnd,&lpRect);
        sprintf(szText,"%i",lpRect.left);
        WritePrivateProfileString(head,"left",szText,inifile);
        sprintf(szText,"%i",lpRect.right);
        WritePrivateProfileString(head,"right",szText,inifile);
        sprintf(szText,"%i",lpRect.top);
        WritePrivateProfileString(head,"top",szText,inifile);
        sprintf(szText,"%i",lpRect.bottom);
        WritePrivateProfileString(head,"bottom",szText,inifile);
        return(0);
}

int RestoreLoc(sWnd,head)
HWND sWnd; char *head;
{
        RECT lpRect; char str[100]; int xw,yw,xs,ys;
        GetPrivateProfileString(head,"left","-1",str,100,inifile);
        if ((xs = atoi(str)) == -1) return(0);
        GetPrivateProfileString(head,"top","-1",str,100,inifile);
        if ((ys = atoi(str)) == -1) return(0);
        GetPrivateProfileString(head,"right","-1",str,100,inifile);
        if ((xw = atoi(str)) == -1) return(0); xw = xw - xs;
        GetPrivateProfileString(head,"bottom","-1",str,100,inifile);
        if ((yw = atoi(str)) == -1) return(0); yw = yw - ys;
        SetWindowPos(sWnd,(HWND) NULL,xs,ys,xw,yw,SWP_NOZORDER);
        ShowWindow(sWnd, SW_SHOWNOACTIVATE);
        UpdateWindow(sWnd);
        return(1);
}

ResetFile()
{
       int hFile;
       hFile = _lcreat(inifile,0); _lclose(hFile);
       WritePrivateProfileString("arrange","SaveOnExit","no",inifile);
       WritePrivateProfileString("arrange","ArrangeOnActivation","no",inifile);
       WritePrivateProfileString("arrange","ExitOnArrange","no",inifile);
       soe = 0; aoa = 0; moa = 0;
}


BOOL InitApplication(hInstance)
HANDLE hInstance;
{
    WNDCLASS  wc;
    if (!FileExists(inifile)) ResetFile();
    wc.style = NULL; wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0; wc.cbWndExtra = 0; wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance,"ArrangeIcon");
    wc.hCursor = LoadCursor(hInstance,"ArrangeIcon");
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "ArrangeMenu";
    wc.lpszClassName = "ArrangeWClass";
    return (RegisterClass(&wc));
}

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE hInstance; int nCmdShow;
{
    TEXTMETRIC txm; HDC hDC; int xs,ys,xw,yw,j,i,nwnd; HWND sWnd;
    char szText[100],dumstr[100];
    hInst = hInstance;
    hWnd = CreateWindow( "ArrangeWClass", "Arrange",
    WS_OVERLAPPEDWINDOW, 0, 0, 10, 10, NULL, NULL, hInstance, NULL );
    SetTimer(hWnd, TimerID, TLEN , (FARPROC) NULL);
    if (!hWnd) return (FALSE);
    if (RestoreLoc(hWnd,"arrange") == 0) {
            hDC = GetDC(hWnd);
            GetTextMetrics (hDC, &txm); ReleaseDC(hWnd, hDC);
            xs = 0; ys = 0;
            xw = xs+17*(txm.tmMaxCharWidth);
            yw = ys+11*(txm.tmExternalLeading + txm.tmHeight);
            SetWindowPos(hWnd,(HWND) NULL,xs,ys,xw,yw,SWP_NOZORDER);
            ShowWindow(hWnd, nCmdShow); UpdateWindow(hWnd); }

    GetPrivateProfileString("arrange","ArrangeOnActivation","no",
        dumstr,100,inifile);
    if (strnicmp(dumstr,"yes",3) == 0) {
    sWnd = hWnd; nwnd = 0;
    while(1) {
    sWnd = GetNextWindow(sWnd,GW_HWNDNEXT);
    if (sWnd == (HWND)NULL) break;
    j = GetWindowText(sWnd,szText,100);
    if (j != 0) { hWnds[nwnd] = sWnd; ++nwnd; }}
    for (i = 0; i < nwnd; ++i) {
            szText[GetWindowText(hWnds[i],szText,100)] = 0;
            RestoreLoc(hWnds[i],szText); }}
    ShowWindow(hWnd, nCmdShow); UpdateWindow(hWnd);

    GetPrivateProfileString("arrange","ArrangeOnActivation","no",
        dumstr,100,inifile);
    if (strnicmp(dumstr,"yes",3) == 0) aoa = 1; else aoa = 0;
    GetPrivateProfileString("arrange","ExitOnArrange","no",
        dumstr,100,inifile);
    if (strnicmp(dumstr,"yes",3) == 0) moa = 1; else moa = 0;
    GetPrivateProfileString("arrange","SaveOnExit","no",
        dumstr,100,inifile);
    if (strnicmp(dumstr,"yes",3) == 0) soe = 1; else soe = 0;
    return (TRUE);
}

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd; unsigned message; WORD wParam; LONG lParam;
{
    FARPROC lpProcAbout;
    char szText[100],dumstr[100];
    HDC hDC; PAINTSTRUCT ps; HWND sWnd;
    int nDrawX,nDrawY,dy,i,j,nwnd; TEXTMETRIC textmetric;
    int xs,ys,xw,yw;
    RECT lpRect; LPOFSTRUCT lpf;
    switch (message) {
        case WM_COMMAND:
            switch (wParam) {
            case IDM_ABOUT:
                lpProcAbout = MakeProcInstance(About, hInst);
                DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
                FreeProcInstance(lpProcAbout); break;
            case IDM_INITIALIZE: ResetFile(); break;
            case IDM_SAVEPREV:
                sWnd = hWnd; i = 0;
                while(1) { ++i;
                sWnd = GetNextWindow(sWnd,GW_HWNDNEXT);
                if (sWnd == (HWND)NULL) break;
                j = GetWindowText(sWnd,szText,100);
                if (j != 0) {
                        szText[GetWindowText(sWnd,szText,100)] = 0;
                        if (!IsIconic(sWnd)) SaveLoc(sWnd,szText); break;
                }}
                SaveLoc(hWnd,"arrange");
                break;
            case IDM_SAVEONEXIT : soe = 1;
                    WritePrivateProfileString("arrange",
                        "ArrangeOnExit","yes",inifile); break;
            case IDM_ARRANGEONACTIVATION: aoa = 1;
                    WritePrivateProfileString("arrange",
                        "ArrangeOnActivation","yes",inifile); break;
            case IDM_EXITONARRANGE: moa = 1;
                    WritePrivateProfileString("arrange",
                        "ExitOnArrange","yes",inifile); break;
            case IDM_NOEXITONARRANGE: moa = 0;
                    WritePrivateProfileString("arrange",
                        "ExitOnArrange","no",inifile); break;
            case IDM_NOSAVEONEXIT : soe = 0;
                    WritePrivateProfileString("arrange",
                        "ArrangeOnExit","no",inifile); break;
            case IDM_NOARRANGEONACTIVATION: aoa = 0;
                    WritePrivateProfileString("arrange",
                        "ArrangeOnActivation","no",inifile); break;
            case IDM_SAVE:
                    SaveLoc(hWnd,"arrange");
                    sWnd = hWnd; i = 0;
                    while(1) { ++i; sWnd = GetNextWindow(sWnd,GW_HWNDNEXT);
                    if (sWnd == (HWND)NULL) break;
                    j = GetWindowText(sWnd,szText,100); if (j != 0) {
                            szText[GetWindowText(sWnd,szText,100)] = 0;
                            if (!IsIconic(sWnd)) SaveLoc(sWnd,szText); }} break;
            case IDM_RESTORE:
                     sWnd = hWnd; nwnd = 0;
                     while(1) { sWnd = GetNextWindow(sWnd,GW_HWNDNEXT);
                     if (sWnd == (HWND)NULL) break;
                     j = GetWindowText(sWnd,szText,100);
                     if (j != 0) { hWnds[nwnd] = sWnd; ++nwnd; }}
                     for (i = 0; i < nwnd; ++i) {
                             szText[GetWindowText(hWnds[i],szText,100)] = 0;
                             RestoreLoc(hWnds[i],szText); }
                     RestoreLoc(hWnd,"arrange");
                     if (moa == 1) DestroyWindow(hWnd);
                     break;
            case IDM_RESTOREPREV:
                     sWnd = hWnd; nwnd = 0;
                     while(1) { sWnd = GetNextWindow(sWnd,GW_HWNDNEXT);
                     if (sWnd == (HWND)NULL) break;
                     j = GetWindowText(sWnd,szText,100);
                     if (j != 0) { hWnds[nwnd] = sWnd; ++nwnd; }}
                     for (i = 0; i < nwnd; ++i) {
                             szText[GetWindowText(hWnds[i],szText,100)] = 0;
                             RestoreLoc(hWnds[i],szText); break; }
                     RestoreLoc(hWnd,"arrange");
                     if (moa == 1) DestroyWindow(hWnd);
                     break;
            case IDM_EXIT:
                DestroyWindow(hWnd); break; }
            break;
        case WM_TIMER: get_stats(hWnd);
            break;
        case WM_DESTROY:
            if (soe == 1) {
                    sWnd = hWnd; i = 0;
                    while(1) { ++i; sWnd = GetNextWindow(sWnd,GW_HWNDNEXT);
                    if (sWnd == (HWND)NULL) break;
                    j = GetWindowText(sWnd,szText,100); if (j != 0) {
                            szText[GetWindowText(sWnd,szText,100)] = 0;
                            if (!IsIconic(sWnd)) SaveLoc(sWnd,szText); }}}
            SaveLoc(hWnd,"arrange"); PostQuitMessage(0); break;
        case WM_CREATE:
            break;
        default: return (DefWindowProc(hWnd, message, wParam, lParam));
    } return (NULL);
}

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg; unsigned message; WORD wParam; LONG lParam;
{
    switch (message) { case WM_INITDIALOG: return (TRUE);
        case WM_COMMAND: if (wParam == IDOK || wParam == IDCANCEL) {
                EndDialog(hDlg, TRUE); return (TRUE); } break; }
    return (FALSE);
}

int get_stats(sWnd)
HWND sWnd;
{
        unsigned int cur_drive; struct diskfree_t dfree;
        char str[80],timestr[80]; long tot,i1,i2,i3,i4;
        int nx,ny,yinc; HFONT hFont,hOldFont;
        struct tm *newtime; time_t aclock;
        HDC hDC; TEXTMETRIC txm;
        hDC = GetDC(sWnd);
/*      hFont = GetStockObject(ANSI_VAR_FONT);
        hOldFont = SelectObject(hDC,hFont); */
        GetTextMetrics (hDC, &txm);
        time(&aclock); newtime = localtime(&aclock);
        strcpy(timestr,asctime(newtime)); timestr[strlen(timestr)-1]=0;
        nx = GetDeviceCaps (hDC, LOGPIXELSX) / 16;
        ny = GetDeviceCaps (hDC, LOGPIXELSY) / 16;
        yinc = txm.tmExternalLeading + txm.tmHeight;
        sprintf(str,"%s",timestr);
        TextOut (hDC, nx, ny, str, strlen (str));

        _dos_getdrive(&cur_drive); _dos_getdiskfree(cur_drive, &dfree);
        getcwd(str,60);
        ny += yinc; TextOut (hDC, nx, ny, str, strlen (str));
        i1 = dfree.total_clusters; i2 = dfree.sectors_per_cluster;
        i3 = dfree.bytes_per_sector; i4 = dfree.avail_clusters;
        sprintf(str," %li total kBytes disk space",i1*i2*i3/1000);
        ny += yinc; TextOut (hDC, nx, ny, str, strlen (str));
        sprintf(str," %li kBytes disk space free",i4*i2*i3/1000);
        ny += yinc; TextOut (hDC, nx, ny, str, strlen (str));
        i1 = GetWinFlags();
        if ((i1 & WF_ENHANCED)==WF_ENHANCED)
                strcpy(str,"Running in 386 Enhanced Mode");
        else if ((i1 & WF_STANDARD)==WF_STANDARD)
                strcpy(str,"Running in Standard Mode");
        else strcpy(str,"Running in Real Mode");
        ny += yinc; TextOut (hDC, nx, ny, str, strlen (str));
        i1 = GetFreeSpace(0); sprintf(str," %li kBytes Global RAM free",i1/1000);
        ny += yinc; TextOut (hDC, nx, ny, str, strlen (str));
        i1 = GlobalCompact(0); sprintf(str," %li kBytes in Largest Block",i1/1000);
        ny += yinc; TextOut (hDC, nx, ny, str, strlen (str));

        ReleaseDC(sWnd, hDC);
}

