/*
ͻ
                                                                           
                              LL_CLASS.H                                   
                                                                           
͹
                                                                           
  Copyrighted 1994  by Dynamic Solutions                                   
                       Rt 1, Box 185                                       
                       Osage City, Kansas 66523-9744                       
                                                                           
  This file contains a Linked List object header file to be used with      
  LL_CLASS.OBJ.                                                            
                                                                           
ͼ
*/

#include <ALLOC.H>

#ifndef LINKLIST_CLASS
   #define LINKLIST_CLASS

   /*.................................... NEAR vs FAR POINTERS & MACROS */

   #if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
      /*............................. define all list pointers as near    */
      /*                              use for models tiny, small, medium  */
      # define LL_PTR     *
      # define LL_NEAR
        typedef  void LL_PTR          VoidPtr;
      # define LL_Malloc(MallocSize)((VoidPtr)(   malloc(       (size_t)MallocSize)))
      # define LL_Free(Ptr)    free ((VoidPtr) Ptr )
   #else
      /*............................. define all list pointers as far     */
      /*                              use for models compact, large, huge */
      # define LL_PTR far *
      # define LL_FAR
        typedef  void LL_PTR          VoidPtr;
      # define LL_Malloc(MallocSize)((VoidPtr)(farmalloc((unsigned long)MallocSize)))
      # define LL_Free(Ptr) farfree ((VoidPtr) Ptr )
   #endif

   typedef  char LL_PTR  CharPtr;

   /*............................ Linked List NODE definition structure */

   struct LLNodeType{
                        struct  LLNodeType   *LLNodePtrNext;
                        struct  LLNodeType   *LLNodePtrPrev;
                        VoidPtr               LLNodePtrContents;
                    };
   typedef struct LLNodeType  LLNode;
   typedef LLNode  LL_PTR     LLNodePtr;

   /*................................. Linked List Definition structure */

   struct LListType {
                        LLNodePtr  LListPtrHead;
                        LLNodePtr  LListPtrTail;
                        int        LListLength;
                    };
   typedef struct LListType  LList;
   typedef LList LL_PTR      LListPtr;

   /*............................................ Binary Tree structure */

   struct BTreeType {
                        struct  BTreeType  *BTreeParent;
                        struct  BTreeType  *BTreePrev;
                        struct  BTreeType  *BTreeNext;
                        LLNodePtr           SortData;
                    };
   typedef struct BTreeType  BTree;
   typedef BTree LL_PTR      BTreePtr;

   /*............................................LINKED LIST PROTOTYPES */

   void     LList_InitErrMsg ( void );
   LListPtr LList_Create     ( void );
   void     LList_Print      ( LListPtr List,
                               void (*PrintFunction)(VoidPtr) );
   void     LList_Delete     ( LListPtr List );
   void     LList_Sort       ( LListPtr List,
                               int (*SortFunction)( VoidPtr, VoidPtr ) );

   /*.......................................LINKED LIST NODE PROTOTYPES */

   void  LLNode_AddAtHead    ( LListPtr List, VoidPtr NodeContent );
   void  LLNode_AddAtTail    ( LListPtr List, VoidPtr NodeContent );
   void  LLNode_Insert       ( LListPtr List, char Where,
                                            LLNodePtr InsertPosition,
                                            VoidPtr NodeContent );

   void  LLNode_DelHead      ( LListPtr List );
   void  LLNode_DelTail      ( LListPtr List );
   void  LLNode_DelNode      ( LListPtr List, LLNodePtr DeleteNode );

   void  LLNode_Swap         ( LListPtr List, LLNodePtr FromNode,
                                              LLNodePtr ToNode );
   void  LLNode_Move         ( LListPtr List, LLNodePtr MoveNode,
                                  char Where, LLNodePtr ToNode );

   void  LLNode_PromoteToHead( LListPtr List, LLNodePtr MoveNode );
   void  LLNode_DemoteToTail ( LListPtr List, LLNodePtr MoveNode );

   LLNodePtr LLNode_FindData   ( LListPtr List, VoidPtr Find,
                               int (*FindFunction)(VoidPtr, VoidPtr) );
   LLNodePtr LLNode_FindSub    ( LListPtr List, int Find );

   /*................................................. STACK PROTOTYPES */


   void  Stack_Push ( LListPtr List, VoidPtr NodeContent ); /* = AddAtTail */
   void  Stack_Pop  ( LListPtr List );                      /* = DelTail   */

   /*................................................. QUE   PROTOTYPES */

   void  Que_Push   ( LListPtr List, VoidPtr NodeContent ); /* = AddAtTail */
   void  Que_Pop    ( LListPtr List );                      /* = DelHead   */

   #define BEFORE  (char)0
   #define AFTER   (char)1

   /*............................................. GLOBAL Error Message */

      struct LL_ErrType {
                           CharPtr Routine;
                           CharPtr Msg;
                        };
      typedef struct LL_ErrType  LLErr;
      typedef LLErr LL_PTR       LLErrPtr;

#endif
