(******************************************************************************)
(*                       ALLFIX 4.31 type definitions                         *)
(*          Copyright (C) 1992,93,94 Harald Harms, all rights reserved        *)
(*                                                                            *)
(*                 All information in this documentation is                   *)
(*                  subject to change without prior notice                    *)
(******************************************************************************)

UNIT TYPES;

INTERFACE

Const MaxFileIDlen = 45;                        { maximum length of a line in a FILE_ID.DIZ file        }

      _announce   = $0001;                      { Attribute bits for the fileecho records               }
      _replace    = $0002;
      _convertall = $0004;
      _passthru   = $0008;
      _dupecheck  = $0010;
      _fileidxxx  = $0020;
      _visible    = $0040;
      _tinysb     = $0080;
      _Security   = $0100;
      _NoTouch    = $0200;
      _SendOrig   = $0400;
      _AddGifSpecs= $0800;
      _VirusScan  = $1000;
      _UpdateMagic= $2000;
      _UseFDB     = $4000;

      _SendTo      = $0001;                     { Attribute bits for the systems in the system list     }
      _ReceiveFrom = $0002;
      _PreRelease  = $0004;
      _Inactive    = $0008;
      _NoneStat    = $0010;
      _HoldStat    = $0020;
      _CrashStat   = $0040;
      _Mandatory   = $0080;

      _AdoptFile   = 1;                         { Magic filename types                                  }
      _ExecCommand = 2;
      _ForwardTo   = 3;
      _MoveToArea  = 4;
      _NoForward   = 5;
      _OtherPath   = 6;
      _UpdateAlias = 7;
      _CopyFile    = 8;
      _KeepNum     = 9;
      _HatchNew    = 10;
      _PickUpFile  = 11;
      _UnpackFile  = 12;
      _PassThruFile= 13;
      _DeleteFile  = 14;

      _HOLD        = $0200;                     { Message status bits in the node manager               }
      _CRASH       = $0001;

      ExportSize   = 255;                       { Size of the systems list                              }

      IndexSize    = 8000;                      { Maximum number of records in the TOBEREP.IDX file     }

Type

  StringRecord = array[0..2000] of char;

  Str12 = string[12];

  MsgBaseType = (Hudson,Pkt,Msg,EzyCom,Squish,Jam,PCBoard,Null,_Netmail);

  NetAddress = Record
    Zone, Net, Node, Point : word;
  end;

  ZoneNet = Record
    Zone, Net : word;
  end;

  ToBeRepIdx = record                           { TOBEREP.IDX file                                      }
    Group : byte;
    Offset: word;
  end;

  ToBeRepFix = record                           { TOBEREP.FIX file                                      }
    Fname     : string[12];
    Fsize     : longint;
    Fdate     : longint;
    From,
    Origin    : NetAddress;
    Group     : Byte;
    Name      : String[40];
    Comment   : String[50];
    Replaces  : String[12];
    MagicName : String[20];
    Fcrc      : LongInt;
    Cost      : Real;
    UnitCost  : real;
    UnitSize  : byte;
    DescLen   : Word;
    Fdesc     : StringRecord;
  end;

  ExportEntry = Record
    Address: NetAddress;
    Status : byte;
  end;

  ExportArray = Array[1..ExportSize] of ExportEntry; { Systems list                                     }

  GroupArray = Array[0..31] of byte;            { Array used to store groups                            }

  ArcRec = Record
    Arc      : String[12];
    ArcCmd   : String[20];
    UnArc    : String[12];
    UnArcCmd : String[20];
    BannerCmd: String[20];
  End;

  UplinkRec = Record
    Aka         : NetAddress;
    MgrProgram  : String[8];
    MgrPassword : String[16];
    Attrib      : word;
    (* bit 0 - add prefix
       bit 1 - unconditional
       bit 2 - direct
       bit 3 - filebone.ra *)
    Groups      : GroupArray;
    AreasFile   : String[12];
    UseAka      : Byte;
  end;

  AkaMatchRec = Record
    Zn : ZoneNet;
    Aka: byte;
  end;

  MailerModeType = (FrontDoorMode,BinkleyMode,DBridgeMode,PortalOfPower);
  DateType       = (European     {dd-mm-yy},
                    American     {mm-dd-yy},
                    Scandinavian {yy-mm-dd});

  ALLFIXcfg = Record                            { SETUP.FIX file                                        }
    VersionID     : Byte;
    FixLog,
    inNETmail,
    MSGpath,
    Inbound,
    LOGfile       : string[60];
    PktPath       : String[60];
    PktOut        : String[60];
    Queue         : String[60];
    TicPath       : String[60];
    Alias         : String[60];
    Semaphore     : String[60];
    RcvdPath      : String[60];
    DefaultAdd    : String[60];
    BadPath       : String[60];
    AreaLog       : String[60];
    OutBound      : String[60];
    OutNetmail    : String[60];
    SecInbound    : String[60];

    SysOp         : string[30];
    RKey          : String[24];
    ListPath      : string[60];
    BBSname       : string[30];
    Baud          : String[5 ];
    Flags         : String[30];
    Location      : String[30];
    Comment       : String[60];
    Pline1,
    Pline2,
    Pline3        : String[30];

    FileAreas     : Array[1..8000] of Byte;

    FakeAka       : NetAddress;
    Aka           : array[0..20] of NetAddress;
    Origin        : array[1..20] of String[60];
    Days          : array[1..7 ] of String[20];
    Months        : array[1..12] of String[20];
    Domains       : array[1..20] of Record Zone: Word;Name: String[25]; end;
    Arc           : Array[1..10] of ArcRec;
    Uplink        : Array[1..20] of UplinkRec;

    KeepDate      : Boolean;
    Rescan        : Byte;
    KeepNet,
    KeepRec       : Boolean;
    Swap          : Byte;
    Exclude       : Array[1..20] of String[12];
    FileCnt       : String[8];

    GroupsDef     : Record                      { No longer used                                        }
      From,
      Too         : String[30];
      Subject     : String[72];
      Template    : String[12];
      Extra       : Array[1..44] of byte;
    end;

    FareasDef     : Record
      Group       : Byte;
      Message     : String[12];
      Keep        : ShortInt;
      Attrib      : Word;
      Convert     : byte;
      Status      : Byte;
      UseFDB      : Boolean;
      LongDesc    : Byte;
      Banner      : String[8];
      Extra       : Array[1..34] of byte;
    end;

    NodesDef      : Record
      Useaka      : Byte;
      MailStat    : Byte;
      Direct      : Boolean;
      TicFile     : Byte;
      Message     : Boolean;
      Notify      : Boolean;
      Archiver    : Byte;
      Forward,
      AutoAdd     : Boolean;
      PackMode    : Byte;
      Remote      : Boolean;
      Groups      : GroupArray;
      Extra1      : Array[1..44] of byte;
    end;

    LogStyle      : byte;
    LocalRep      : Boolean;
    LogOptions    : Longint;
    AkaMatch      : Array[1..20] of AkaMatchRec;
    ReplaceExt    : Boolean;
    KeepMgr       : Boolean;
    AreaMgrOpts   : Word;
      (* bit 0 - allow %+ALL
             1 -       %notify
             2 -       %password
             3 -       %message
             4 -       %compression
             5 -       %tick
             6 -       %pause
             7 -       %echopassword *)
    AutoAddNodes  : Boolean;
    PublicGroups  : GroupArray;
    UseXEMS       : Boolean;
    MailerMode    : MailerModeType;
    DaysToKeepHis : Byte;
    MaxSizeOfHis  : Byte;
    ResetFuture   : Boolean;                    { no longer used                                         }
    ExtendedChar  : Char;
    FilterFileID  : Boolean;
    OneLineFileID : Boolean;
    KeepDays      : Word;
    DateFormat    : DateType;
    StatSize      : Word;
    _4DOSmode     : Boolean;
    AreaMgrStr    : Array[1..5] of String[20];
    VirusChecker  : String[12];
    VirusOptions  : String[50];
    DBqueue       : String[60];
    TagPath       : String[60];
    FixDor        : Record                      { no longer used                                        }
      ReadHK,
      ScanHK,
      QuickHK,
      YellHK,
      HelpHK,
      EnterHK,
      QuitHK,
      LogoffHK    : Char;
      YellDelay   : Byte;
      FixLogStyle : Byte;
      Extra       : Array[1..22] of byte;
    end;
    RedirectOutput: Boolean;
    VirusErrorLvl : Byte;
    FilesToScan   : Byte;
    MaxLineFileID : Byte;
    FileIDindent  : Byte;
    InitDate      : Longint;
    EchoToss      : String[60];
    MaxTicPackSize: Word;
    OldFileFind   : Byte;
    TmpDir        : String[60];
    ExtConvExe    : String[12];
    ExtConvOpt    : String[128];
    AddArea       : Byte;
    TemplatePath  : String[60];
    UTCofs        : Integer;
    MtaVirusLvl,
    MtaErrorLvl   : Byte;
    MinSpace      : Word;
    Colors        : String[40];
    UEFTS         : record
      name        : string[35];
      address     : netaddress;
      fname       : string[60];
      nname       : string[60];
      dom         : byte;
      status      : byte;
      direct      : boolean;
      oldf        : byte;
      area        : string[12];
      extra       : array[1..73] of byte;
    end;
    DupeCheck     : Byte;
      {  0 - filename
         1 - filename + fileecho
         2 - filecrc
         3 - filecrc + fileecho
         4 - filecrc + filename
         5 - filename + fileecho + filecrc }
    MaxSizeToPack : Word;
    messagecomp   : byte;
    BillPath      : String[60];
    DupePath      : String[60];
    xArc          : array[7..10] of ArcRec;
    xSig          : array[7..10] of String[29];
    xExt          : Array[7..10] of String[3];
    Unwanted      : String[60];
    MaxMsgSize    : Byte;
    Extra         : Array[1..1112] of byte;
  end;

  AreaMGRRec = Record                           { AREAS.FIX file                                        }
     Comment : string[55];
     Name    : string[40];
     RName   : String[40];
     Origin  : byte;
     Board   : Word;                            { Scan board number                                     }
     RBoard  : Word;                            { Reply board number                                    }
     Aka     : byte;
     Path    : String[60];                      { Scan path                                             }
     Rpath   : String[60];                      { Reply path                                            }
     Btype,                                     { Scan type of message base                             }
     Rtype   : byte;                            { Reply type of message base                            }
     _Sname  : String[8];                       { no longer used                                        }
     _SRname : String[8];                       { no longer used                                        }
     Template: String[8];
     Extra   : Array[1..105] of byte;
   end;

   AreaMgrIdx = Record                          { AREAS.IDX file                                        }
     Comment : String[55];
     Offset  : Word;
   End;

   NewFileMgrRec = Record                       { NEWFILES.FIX file                                     }
     Comment : String[55];
     Group   : Byte;
     FileBrd : Word;
     PathCrc : LongInt;
   end;

   NewFileMgrIdx = Record                       { NEWFILES.IDX file                                     }
     FileBrd: Word;
     Offset : Word;
   End;

   FileMGRrec = Record                          { FAREAS.FIX file                                       }
     Name      : String[12];
     Extra_1   : Array[1..28] of byte;
     Message   : String[12];
     Comment   : String[55];
     Group     : Byte;
     Attrib    : word;
     KeepLate  : ShortInt;
     Convert   : 0..6;
     UplinkNum : Byte;
     DestDir   : String[60];
     TotalFiles,
     TotalKb   : Word;
     Byear,
     Bmonth    : Byte;
     _FBoard   : Word;
     UseAka    : ShortInt;
     LongDesc  : Byte;
     Banner    : String[8];
     UnitCost     : real;
     UnitSize     : byte;
     AllLinks     : boolean;
     AddPercentage: real;
     Extra        : array[1..30] of byte;
     Export       : ExportArray;
   end;

   FileMGRidx = Record                          { FAREAS.IDX file                                       }
     Name   : String[12];
     Group  : Byte;
     Offset : word;
   end;

   GrpFileMgrRec = Record                       { GRPFILE.FIX file                                      }
     FMrec : FileMgrRec;
     Name  : String[25];
   end;

   GrpFileMgrIdx = Record                       { GRPFILE.IDX file                                      }
     Group : Byte;
     Spec  : String[12];
     Name  : String[25];
     Offset: Word;
   end;

   NodeMGRrec = Record                          { NODEFILE.FIX file                                     }
     Aka       : NetAddress;
     Sysop     : String[35];
     Password  : String[20];
     Groups    : GroupArray;
     Reserved  : Byte;
     Extra     : Array[1..4] of byte;
     MailStat  : Byte;
     Direct    : Boolean;
     TicFile   : Byte;
     UseAka    : ShortInt;
     Message   : Boolean;
     Notify    : Boolean;
     Archiver  : Byte;
     Forward   : Boolean;
     AutoAdd   : Boolean;
     MgrPassword: String[20];
     Remote    : Boolean;
     PackMode  : Byte;
     ViaNode   : NetAddress;
   end;

   NodeMGRidx = Record                          { NODEFILE.IDX file                                     }
     Aka   : NetAddress;
     Offset: word;
   end;

   ReportsMgrRec = Record                       { REPORTS.FIX file                                      }
     Groups   : GroupArray;
     Reserved : Byte;
     Extra1   : Array[1..4] of byte;
     Aka      : byte;
     Origin   : byte;
     Template : String[8];
     From,
     Too      : String[35];
     Subject  : String[72];
     MsgType  : byte;                           { Message base type                                     }
     Board    : Word;                           { Message board number                                  }
     Name     : String[40];
     Path     : String[60];
     Export   : ExportArray;
     Extra2   : Array[1..44] of byte;
   end;

   ReportsMGRidx = Record                       { REPORTS.IDX file                                      }
     Group : GroupArray;
     Offset: Word;
   end;

   MagicFileMgrRec = Record                     { MGICFILE.FIX file                                     }
     Attrib   : Byte;
     FileMask,
     FromArea,
     ToArea   : String[12];
     Directory: String[60];
     Command  : String[60];
     KeepNum  : ShortInt;
     Days     : Byte;
     Extra    : Array[1..41] of byte;
     Export   : ExportArray;
   end;

   MagicMGRidx = Record                         { MGICFILE.IDX file                                     }
     FileMask : String[12];
     Offset   : Word;
   end;

   HatchMGRrec = Record                         { HATCH.FIX file                                        }
     Name   : String[12];
     Spec   : String[79];
     Replace: String[12];
     Magic  : String[20];
     Desc   : String[80];
     Days   : Byte;
     UseFDB : Boolean;                          { no longer used                                        }
     Extra  : Array[1..4] of byte;
   end;

   HatchMgrIdx = Record                         { HATCH.IDX file                                        }
     Name: String[12];
     Offset: word;
   end;

   FileAreaRecord = Record                      { FILEAREA.FIX file (file area records)                 }
     Path: string[60];
     Name: string[60];
     List: string[60];
     Fnum: string[9];
     Fbrd: Word;
     Pbrd: Word;
     PathCRC: LongInt;
   end;

  FileAreaHeader = Record                       { FILEAREA.FIX file (header, stored at begining of file)}
    BBStype : byte;
    SysPath : String[60];
    BBSpath : String[60];
    FilePath: String[60];
    UseFDB  : boolean;
    Extra   : Array[1..71] of byte;
  end;

  StatisticRecord = Record                      { STATFILE.FIX file                                     }
    FileEcho : Str12;
    Date     : Longint;
    FileName : Str12;
    FileSize : Longint;
    FileDate : Longint;
    Sender   : NetAddress;
    NumDown  : Word;                            { Number of downlinks following this record             }
  end;

  StatisticIndex = Record                       { STATFILE.IDX file                                     }
    FileEcho : Longint;                         { 32 bit CRC of fileecho name                           }
    Offset   : Longint;
  end;

IMPLEMENTATION

end.
