{$A-,I-,R-,S-}

unit xnet;

interface

(*------------------------------------------------------------------------

             Specifications for the Xpress Network Mail Format
                                  XNET.3a
                 (c) copyright 1994 by Santronics Software

syntax:

  !  -  if comment has this character, the field is required

--------------------------------------------------------------------------*)

Type
    char8      =  array[0..8] of char;
    char80     =  array[0..80] of char;
    char255    =  array[0..255] of char;

Const
    XNET_CTRLID = $003A;

(*--------------------------------------------------------------------------
Object Token
--------------------------------------------------------------------------*)

(* token record *)

type _TOK =
     record
       id      : word;         (* !token id, 65K max *)
       len     : longint;      (* !token length      *)
     end;
     PTOK = ^_TOK;

(*========================================================================

XBIF.DAT   Board Information File

The BIF file has a header followed by tokens which describe the system.

The information found in this file should give meaningful information to
completely describe the BBS or HOST system for remote clients.

The first 1000 tokens are reserved for future public consumption. CoComp
designers may use anything above 1000.

------------------------------------------------------------------------*)

(* BIF tokens *)

Const    _TOK_BIF_HOSTNAME      = 0;     (* ! Host name of system          *)
Const    _TOK_BIF_REALNAME      = 1;     (* ! Real Sysop Name              *)
Const    _TOK_BIF_SYSOPNAME     = 2;     (* ! Name to use for 'SYSOP'      *)
Const    _TOK_BIF_HOSTPHONE     = 3;     (* ! Host phone                   *)
Const    _TOK_BIF_TIMEZONE      = 4;     (* ! Time zone (c based)          *)
Const    _TOK_BIF_LOCATION      = 5;     (* ! Location of host             *)
Const    _TOK_BIF_BBSTYPE       = 6;     (* Name of BBS package            *)
Const    _TOK_BIF_BBSVER        = 7;     (* Version of BBS package         *)
Const    _TOK_BIF_MAILDOOR      = 8;     (* Mail Door, Packet Provider     *)
Const    _TOK_BIF_MAILDOORVER   = 9;     (* Mail Door version              *)
Const    _TOK_BIF_MAILDOORINFO  = 10;    (* Mail Door Information String   *)
Const    _TOK_BIF_INETDOMAIN    = 11;    (* Internet Domain Name           *)
Const    _TOK_BIF_UUCPADDRESS   = 12;    (* UUCP Host Address              *)
Const    _TOK_BIF_READERINFO    = 13;    (* Attended Reader Information    *)
Const    _TOK_BIF_FIDOADDRESS   = 14;    (* Primary and AKA Addresses      *)
Const    _TOK_BIF_XNETPID       = 15;    (* ! Mail Door Product Code       *)

(* BIF flags *)

Const    _BIF_RIP_READY         = $00000001;   (* BBS has RIP           *)
Const    _BIF_FIDO_FRONTEND     = $00000002;   (* BBS has FIDO Mailer   *)
Const    _BIF_IEMSI             = $00000004;   (* BBS has FIDO IEMSI    *)
Const    _BIF_PX_READER         = $00000008;   (* BBS is Platinum Ready *)

(* BIF header record *)

type _BIF = record
      reclen     : word;                 (* length of header *)
      version   : longint;               (* ! version number 'XN3A'        *)
      pktid     : char8;                 (* ! packet name                  *)
      pktdate   : longint;               (* packet creation date           *)
      bbsflags  : longint;               (* bbs flags                      *)
      res       : array[1..100] of byte;
     end;
    PBIF =  ^_BIF;

(*=========================================================================
XUIF.DAT     User Information File

The UIF file has a header and tokens that describe the user of the system.

The first 1000 tokens are reserved for future public consumption. CoComp
designers may use anything about 1000.

-------------------------------------------------------------------------*)

(* UIF tokens *)

Const    _TOK_UIF_USERNAME      = 1;       (* ! user name               *)
Const    _TOK_UIF_ALIASNAME     = 2;       (* alias name                *)
Const    _TOK_UIF_USERID        = 3;       (* User ID                   *)
Const    _TOK_UIF_INTERNETNAME  = 4;       (* Internet Name             *)
Const    _TOK_UIF_MHSNAME       = 5;       (* MHS NAME                  *)
Const    _TOK_UIF_FIDOPOINT     = 6;       (* User's fido point address *)

(* UIF user flags    *)

Const    _UIF_CAN_FILEREQ       = $00000001;   (* User can file request *)
Const    _UIF_CAN_UPLOAD        = $00000002;   (* User can file attach  *)

(* UIF header record *)

type _UIF = record
      reclen     : word;                   (* length of header           *)
      version   : longint;                 (* !version number 'XN3A'     *)
      pktnumber : word;                    (* packet count               *)
      UsrFlags  : longint;                 (* user flags                 *)
      Credit    : Longint;                 (* Netmail Credit             *)
      Debit     : Longint;                 (* Netmail Debit              *)
      MaxMsgs   : word;                    (* maximum # of new messages  *)
      res       : array[1..100] of byte;
     end;
    PUIF =  ^_UIF;

(*===========================================================================
XMIF.DAT           Mail Conference Information File

The MIF file describes the FORUMS and CONFERENCES of a BBS.  There is a
MIFHDR header, followed by one MIF record per area, followed by any MIF
tokens for the area.  The MIF header has a total conferences variable to
allow clients to quickly determine how much ram space is required for
loading.

The first 1000 tokens are reserved for future public consumption. CoComp
designers may use anything about 1000.
--------------------------------------------------------------------------*)

(* MIF conference type flags *)

Const    _MIF_NET_LOCAL         = $00000001;   (* local base only            *)
Const    _MIF_NET_ECHO          = $00000002;   (* based shared with others   *)
Const    _MIF_NET_FIDO          = $00000004;   (* fidonet base               *)
Const    _MIF_NET_INTERNET      = $00000008;   (* internet email             *)
Const    _MIF_NET_NEWSGROUP     = $00000010;   (* internet newsgroup         *)
Const    _MIF_NET_FAX           = $00000020;   (* fax base                   *)
Const    _MIF_NET_CIS           = $00000040;   (* compuserve forum           *)

(* MIF Conference attribute flags *)

Const    _MIF_ALLOW_ANONYMOUS   = $00000001;   (* Allow user to change name   *)
Const    _MIF_READ_ONLY         = $00000002;   (* cannot post message         *)
Const    _MIF_PRIVATE_ONLY      = $00000004;   (* cannot post public message  *)
Const    _MIF_PUBLIC_ONLY       = $00000008;   (* cannot post private message *)
Const    _MIF_ALLOW_TEARLINE    = $00000010;   (* Allow Tearlines?            *)
Const    _MIF_ALLOW_TAGLINE     = $00000020;   (* Allow taglines?             *)
Const    _MIF_ALLOW_HIGHASCII   = $00000040;   (* Allow IBM extended chars?   *)
Const    _MIF_FORCE_UPPERCASE   = $00000080;   (* How Header Should Look      *)
Const    _MIF_FORCE_CAPS        = $00000100;   (* How Header should look      *)
Const    _MIF_ALLOW_KLUDGE      = $00000200;   (* Allow Ctrl A lines          *)
Const    _MIF_FORCE_ALIAS       = $00000400;   (* Force the Alias Name        *)
Const    _MIF_ALLOW_FILEATT     = $00000800;   (* Allow File Attaches         *)
Const    _MIF_ALLOW_CCMAIL      = $00001000;   (* Allow CC MAIL               *)
Const    _MIF_ALLOW_GROUP       = $00002000;   (* Allow Group mail            *)
Const    _MIF_FORCE_INTL        = $00004000;   (* Force International Line    *)

(* MIF Special Fido NetMail Control Flags *)

Const    _MIF_CAN_CRASH         = $00000001;   (* Allow Crash status          *)
Const    _MIF_CAN_HOLD          = $00000002;   (* Allow Hold status           *)
Const    _MIF_CAN_IMMED         = $00000004;   (* Allow Immediate status      *)
Const    _MIF_CAN_DIRECT        = $00000008;   (* Allow Direct status         *)
Const    _MIF_CAN_FILEATT       = $00000010;   (* Allow File Request Files    *)
Const    _MIF_CAN_FILEREQ       = $00000020;   (* Allow File Attach messages  *)
Const    _MIF_CAN_KILLSENT      = $00000040;   (* Allow Kill/Sent status      *)
Const    _MIF_CAN_KILLFILE      = $00000080;   (* Allow Kill/File status      *)

(* MIF User Area configuration Flags *)

Const    _MIF_USR_SCANALL       = $00000001;   (* Get all mail                *)
Const    _MIF_USR_SCANDIRECT    = $00000002;   (* Get Direct                  *)
Const    _MIF_USR_SCANKEYWORDS  = $00000004;   (* Get Keywords                *)
Const    _MIF_USR_SELECTED      = $00000008;   (* Selected Conference         *)

(* MIF tokens *)

Const    _TOK_MIF_EOR           = 0;           (* !end of MIF record/tokens *)
Const    _TOK_MIF_NETWORKTAG    = 1;           (* network tag *)
Const    _TOK_MIF_FORUMNAME     = 2;           (* forum name *)
Const    _TOK_MIF_LONGNAME      = 3;           (* long title of conference *)
Const    _TOK_MIF_SHORTNAME     = 4;           (* !short title of conference *)
Const    _TOK_MIF_DESCRIBE      = 5;           (* Forum Description, %filename *)
Const    _TOK_MIF_FIDOADDRESS   = 6;           (* address for area *)
Const    _TOK_MIF_MODERATOR     = 7;           (* moderator name *)

(* MIF header *)

type _MIFHDR = record
      reclen     : word;                (* length of header *)
      version   : longint;               (* version number 'XN3A' *)
      totalconf : longint;               (* total conferences *)
      res       : array[1..100] of byte;
     end;
    PMIFHDR =  ^_MIFHDR;

(* MIF record per conference *)

type _MIF = record
      reclen     : word;                (* length of header *)
      version    : longint;             (* version number 'XN3A'             *)
      ConfNumber : longint;             (* Optional Conference Number        *)
      Conftype   : longint;             (* Conference Network Type           *)
      ConfAttr1  : longint;             (* mail attribute flags              *)
      ConfAttr2  : longint;             (* reserved attributes               *)
      UserFlag   : Longint;             (* User Flags for this area          *)
      NetFlags   : longint;             (* fido netmail flags                *)
      PostArea   : longint;             (* Optional Conference to Post Mail  *)
      usertokid  : word;                (* UIF token to use for default name *)
      maxtolen   : word;                (* max length of to whom field;      *)
      maxfromlen : word;                (* max length of from whom field;    *)
      maxsubjlen : word;                (* max length of subject field;      *)
      maxlines   : longint;             (* max lines in text messages        *)
     end;
    PMIF =  ^_MIF;

(*-------------------------------------------------------------------------
XFIF.DAT  File Conference Information File

The FIF file describes the FILE CONFERENCES of a BBS.  There is
one FIF record per area, followed by any FIF tokens.

--------------------------------------------------------------------------*)

(* FIF tokens *)

Const    _TOK_FIF_EOF           = 0;    (* end of record                *)
Const    _TOK_FIF_NETWORKTAG    = 1;    (* network tag                  *)
Const    _TOK_FIF_FORUMNAME     = 2;    (* forum name                   *)
Const    _TOK_FIF_LONGNAME      = 3;    (* long title of area           *)
Const    _TOK_FIF_SHORTNAME     = 4;    (* short title                  *)
Const    _TOK_FIF_DESCRIBE      = 5;    (* Forum Description, %filename *)

(* MIF User Area configuration Flags *)

Const    _FIF_USR_SELECTED      = $00000001;   (* Selected Conference         *)

(* FIF header *)

type _FIFHDR = record
      reclen     : word;                (* length of header *)
      version    : longint;             (* version number 'XN3A' *)
      totalconf  : longint;             (* total conferences *)
      res        : array[1..100] of byte;
     end;
    PFIFHDR =  ^_FIFHDR;

(* FIF record per file conference *)

type _FIF = record
      reclen     : word;                (* length of header *)
      version    : longint;             (* version number 'XN3A' *)
      ConfNumber : longint;             (* Optional Conference Number *)
      userFlag   : longint;
     end;
    PFIF =  ^_FIF;

(*-------------------------------------------------------------------------
XNFL.DAT           New File Listing

The NFL file describes the new files available on the system.

--------------------------------------------------------------------------*)

(* NFL tokens *)

Const    _TOK_NFL_EOR           = 0;     (* END OF RECORD *)
Const    _TOK_NFL_FILENAME      = 1;     (* File name *)
Const    _TOK_NFL_DESCRIBE      = 2;     (* File Description *)
Const    _TOK_NFL_FILENET       = 3;     (* Network tag *)

(* NFL record per file *)

type _NFL = record
      reclen     : word;                (* length of header *)
      version    : longint;              (* version number 'XN3A' *)
      ConfNumber : longint;              (* Optional Conference Number *)
      filedate   : longint;              (* File date  *)
      filesize   : longint;              (* File size  *)
     end;
    PNFL =  ^_NFL;

(*---------------------------------------------------------------------------

pid.ODI            Object Data File Index

The index file holds the linkage of the object data base.

          ODI HEADER (OIH)
              TOKENS (OTOK)

The special token _TOK_ODI_OBJECT is a special token where the token length
must be 8. It points to a structure _ODR which contains the MSGLENGTH and
MSGPTR.

Do not use _TOK to create objects. They do no apply here.

---------------------------------------------------------------------------*)

(* Message Attribute Flags *)

Const    _OIH_PRIVATE           = $00000001;   (* Private                 *)
Const    _OIH_CRASH             = $00000002;   (* Crash mail              *)
Const    _OIH_RECEIVED          = $00000004;   (* Message received        *)
Const    _OIH_SENT              = $00000008;   (* Sent already            *)
Const    _OIH_DIRECT            = $00000010;   (* Direct, do not route    *)
Const    _OIH_IMMED             = $00000020;   (* Immediate Mail          *)
Const    _OIH_FILEATT           = $00000040;   (* File attached           *)
Const    _OIH_FILEREQ           = $00000080;   (* File request            *)
Const    _OIH_ORPHAN            = $00000100;   (* Orphaned                *)
Const    _OIH_KILLSENT          = $00000200;   (* Kill after sending      *)
Const    _OIH_KILLFILE          = $00000400;   (* Kill file after sending *)
Const    _OIH_LOCAL             = $00000800;   (* Local message           *)
Const    _OIH_HOLD              = $00001000;   (* Hold for pickup         *)
Const    _OIH_RECEIPTREQ        = $00002000;   (* receipt requested       *)
Const    _OIH_RECEIPT           = $00004000;   (* message is receipt      *)
Const    _OIH_GROUPMAIL         = $00008000;   (* message is group msg    *)
Const    _OIH_DELETED           = $00010000;   (* message is deleted      *)

(* ODI tokens *)

Const    _OTOK_OBJECT           = 0;      (* ! Data Object  See Media Byte *)
Const    _OTOK_TOWHOM           = 1;      (* ! To Field                    *)
Const    _OTOK_FROMWHOM         = 2;      (* ! From Field                  *)
Const    _OTOK_SUBJECT          = 3;      (* ! Subject                     *)
Const    _OTOK_DESTADDRESS      = 4;      (* Fido Destination Address      *)
Const    _OTOK_ORIGADDRESS      = 5;      (* Fido Originating Address      *)
Const    _OTOK_CCTO             = 6;      (* CC MAIL TO                    *)
Const    _OTOK_BCTO             = 7;      (* BC MAIL TO                    *)
Const    _OTOK_INETDEST         = 8;      (* Internet To                   *)
Const    _OTOK_INETORIG         = 9;      (* Internet From                 *)
Const    _OTOK_FILEATTACH       = 10;     (* File attached                 *)
Const    _OTOK_FAXPHONE         = 11;     (* Fax Phone number to sent      *)
Const    _OTOK_PID              = 30;     (* Fido PID of message           *)
Const    _OTOK_MSGID            = 31;     (* Fido MSGID of message         *)
Const    _OTOK_REPLY            = 32;     (* Fido REPLYID of message       *)
Const    _OTOK_INTL             = 33;     (* Fido INTL of message          *)
Const    _OTOK_FLAGS            = 34;     (* Fido FLAGS of message         *)

(* Object Token multi-media type *)

Const    _OTOK_MEDIATYPE_TEXT   = 0;     (* Text/Mail *)
Const    _OTOK_MEDIATYPE_RIP    = 1;     (* RIP Script Text *)
Const    _OTOK_MEDIATYPE_G3     = 2;     (* FAX group 3 *)
Const    _OTOK_MEDIATYPE_G4     = 3;     (* FAX group 4 *)
Const    _OTOK_MEDIATYPE_GIF    = 4;     (* GIF *)
Const    _OTOK_MEDIATYPE_PCX    = 5;     (* PCX *)
Const    _OTOK_MEDIATYPE_DCX    = 6;     (* DCX *)
Const    _OTOK_MEDIATYPE_TIF    = 7;     (* TIF *)
Const    _OTOK_MEDIATYPE_WAV    = 8;     (* WAV file *)
Const    _OTOK_MEDIATYPE_VOC    = 9;     (* VOC file *)
Const    _OTOK_MEDIATYPE_INET   = 10;    (* pure Internet message *)

(* Object Token *)

type _OTOK = record
      id         : word;                 (* token id *)
      mediatype  : word;                 (* multi-media type *)
      len        : longint;              (* length of message *)
      fileptr    : longint;              (* pointer to ODF file *)
     end;
    POTOK =  ^_OTOK;

(* Object Index Object Record Header *)

type _OIH = record
      reclen     : word;                (* length of header             *)
      version    : longint;             (* version number 'XN3A'        *)
      msgnum     : longint;             (* message number               *)
      prevnum    : longint;             (* previous message number      *)
      nextnum    : longint;             (* next message number          *)
      msgflags   : longint;             (* message attribute            *)
      postdate   : longint;             (* date message was created     *)
      readdate   : longint;             (* date message was read        *)
      cost       : longint;             (* cost                         *)
      echo32     : longint;             (* 32 bit crc of echotag        *)
      toksize    : longint;             (* size of all the total tokens *)
      res        : array[1..50] of byte; end; POIH =  ^_OIH;

(*=========================================================================
XODF.DAT           Object Data File Data

The ODF file is a RAW binary file. All linkages to data is based off the
ODI file. Direct pointers are defined above.

-------------------------------------------------------------------------*)

(*========================================================================
XUFA.DAT           File Attachments File, file, faxes
-------------------------------------------------------------------------*)

implementation
end.
