/*
**
**				MUI-Menu v.1.00
**
**			  By Giuseppe Chiesa 1994 Milano
**
**			E-Mail: chieg@ghost.sm.dsi.unimi.it
**
**		Dedicated to my aunt Ada ...
**
**			Hope you're happier now
**			surely we're more lonely now
**
*/

/*
**	Features:
**
**	- Dynamic Button Creation ( till 12rows x 4cols Buttons )
**	- Edit Capabilities
**	- Save Data
**	- Editable Config File ( Not Fully Implemented )
**	- Synch or ASynch Execution
**	- MUI facilities ( Great ! )
**	- Parameters Specification
**	- .AmigaGuide DocFile
**	- Keyboard Short-Cuts
**
*/

/*
**	Future:
**
**	- Maybe a better button positioning for new columns buttons
**		( Not just some centered elements but on the same
**		  rows of the first ones followed by empty buttons )
**	- ...
**
*/

/*
**
**	Idea, Program Design and Code by Giuseppe Chiesa aka ~Lizard~
**
**	E-Mail : chieg@ghost.sm.dsi.unimi.it
**
**	Original Idea and Program ( DBLMenu ) by Claudio Fuse' aka ~DBL~
**
*/

#include <exec/types.h>
#include <exec/memory.h>
#include "code.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Some definitons */

#define _MAX_ITCHARS 16
#define _MAX_PRGCHARS 32
#define _MAX_PARMSCHARS 48

#define _MAX_TXTCHARS 24

#define _MAX_ROWS 12
#define _MAX_COLS 4
#define _MAX_ELEMENTS _MAX_ROWS * _MAX_COLS

#define _QUIT_ID 60
#define _SAVE_ID 61
#define _ADD_ID 62
#define _DEL_ID 63
#define _CHANGE_ID 64
#define _ABOUT_ID 65
#define _OK_ID 66
#define _CANCEL_ID 67
#define _HIDE_ID 68
#define _LAUNCH_ID 70

/* Function Declarations - End */

void PutTxt( UBYTE * );
BOOL GetVGroup( ULONG );
BOOL AddFunc( void );
BOOL LoadFunc( void );
BOOL SaveFunc( void );
BOOL CleanUpMem( void );
BOOL GetBuffer( FILE * , UBYTE * );

/* Function Declaration - End */



/* Global Variables - Begin */

/* About Text */

UBYTE *Thxtxt="\33c\33bMUI Menu 1.00\33n\n\n\
\33cProgram By\n\33b\33cGiuseppe Chiesa\
\33n\n\n\33cE-Mail: chieg@ghost.sm.dsi.unimi.it\
\n\n\33cMilano-Italy 1994\n\n\33cThanks to\n\n\
\33c\33bFrency\n\33cArturo & Norma\n\n\33n\33c\
Dedicated To\n\n\33c\33bAda\33n\
\n\n\33cGreetings to\n\n\33c\33bClaudio and Furio\33n";


/*

  Typical Item Body

	item = Item Name : will be displaied as button text

	prog = Program Name : will be executed when item button is pressed

	parms = Parameters : If present will follow program as its parms

	pos = Array position : used to write and read with Notify Mechanism

	async = Asynchronous execution : If TRUE program will be executed
		asynchronously and MGTools will not wait for it to finish

*/

struct element
{
UBYTE *item;
UBYTE *prog;
UBYTE *parms;
ULONG pos;
ULONG async;
};

/* Array with all possible elements */

struct element els[ _MAX_ELEMENTS ];

ULONG pos[ _MAX_ELEMENTS ];

/* Array with all possible element buttons and key short-cuts */

APTR buttons[ _MAX_ELEMENTS ];
APTR labbuts[ _MAX_ELEMENTS ];
UBYTE keys[ _MAX_ELEMENTS ][2];

/* Link struct between main prog and Adder function */

struct element transit;

/* itnum = Current item number ( last one created ) <= _MAX_ELEMENTS - 1 */

ULONG	itnum=0;

/* Current VertGroup address */

APTR addVgroup,V1,V2,V3,V4;

/* Application, Window and Text_Object Address */

APTR app,window,txtobj ;

/* running Bool, numb ULONG for selecting button and buf for PutTxt func
	Add_Button, Del_Button and Change_Button addresses */

BOOL running = TRUE;
ULONG numb=-1;
APTR addbut,delbut,changebut;
UBYTE *infile="S:MUIMenu.data\0";
UBYTE *buf;

/* change global flag for changing data function */

BOOL change=FALSE;

/* Global Variables - End */



/* Function Bodies - Begin */


/* Writes in txtobj some text formatted to _MAX_TXTCHARS */

void PutTxt( UBYTE *txto )
{

int i;
BOOL intxt=TRUE;

for(i=0; i<=_MAX_TXTCHARS;i++)
{
	if(txto[i]=='\0')
		intxt=FALSE;

	if(intxt)
		buf[i]=txto[i];
	else
		buf[i]=' ';
}

buf[i]='\0';

set(txtobj,MUIA_Text_Contents,buf);

}

/* Get data function returns FALSE if EOF found */

BOOL GetBuffer( FILE *fil, UBYTE *buff)
{

int i,c;

for(i=0;( c=fgetc(fil) )!='\n' && c!=EOF ; i++)
	buff[i]=c;

	buff[i]='\0';

if(c=='\n')
	return(TRUE);
else
	return(FALSE);
}


/* This Function creates a new button and attaches it to the correct VGroup
   For this reason and for enabling add, del and text buttons I had to use
   app, window, addbut, delbut, txtbut addresses and running & numb as
   global variables */

BOOL AddButtFunc( void )
{

	if( itnum < 26 )
		keys[itnum][0]='b'+itnum;
	else
		keys[itnum][0]='A'+itnum-25;

	keys[itnum][1]='\0';

	buttons[ itnum ]=\
	HGroup,
	Child,	labbuts[itnum]=TextObject,
		ButtonFrame,
		MUIA_Text_Contents, transit.item,
		MUIA_Text_PreParse, "\33c",
		MUIA_InputMode    , MUIV_InputMode_RelVerify,
		MUIA_Background   , MUII_ButtonBack,
		End,

	Child,	TextObject,
		ButtonFrame,
		MUIA_FixWidthTxt,	"A",
		MUIA_Text_Contents, &((keys[itnum])[0]),
		MUIA_Text_PreParse, "\33c",
		MUIA_ControlChar  , keys[itnum][0],
		MUIA_InputMode    , MUIV_InputMode_RelVerify,
		MUIA_Background   , MUII_ButtonBack,
		End,
	End;
	

	if(buttons[ itnum ])
		{
	DoMethod(addVgroup,OM_ADDMEMBER,buttons[ itnum ]);
	DoMethod(buttons[itnum],MUIM_Notify,MUIA_Pressed,FALSE,
	app,2,MUIM_Application_ReturnID,_LAUNCH_ID);

	strcpy(els[ itnum ].item,transit.item);
	strcpy(els[ itnum ].prog,transit.prog);
	strcpy(els[ itnum ].parms,transit.parms);
	els[ itnum ].async=transit.async;
	els[itnum].pos=itnum;

	DoMethod(buttons[itnum],MUIM_Notify,MUIA_Pressed,FALSE,
	buttons[itnum],3,MUIM_WriteLong,els[itnum].pos,&numb);
	PutTxt("Item Added...");

	itnum++;

	set(delbut,MUIA_Disabled,FALSE);
	set(changebut,MUIA_Disabled,FALSE);

	if( itnum == _MAX_ELEMENTS )
		set(addbut,MUIA_Disabled,TRUE);
	
	} /* button created */
	else
		{
		fail(app,NULL);
		running=FALSE;
		}

	if(buttons[itnum-1])
	return(TRUE);
	else
	return(FALSE);
}


/* Gets Button VGroup Address and shows VGroup until
    ~number~ button in rows of 12 elements */

BOOL GetVGroup( ULONG number )
{

	ldiv_t calc ;

	calc = ldiv(number,_MAX_ROWS);
	switch(calc.quot)
	{
		case 0:
		addVgroup=V1;
		set(V1,MUIA_ShowMe,TRUE);
		set(V2,MUIA_ShowMe,FALSE);
		set(V3,MUIA_ShowMe,FALSE);
		set(V4,MUIA_ShowMe,FALSE);
		break;

		case 1:
		addVgroup=V2;
		set(V1,MUIA_ShowMe,TRUE);
		set(V2,MUIA_ShowMe,TRUE);
		set(V3,MUIA_ShowMe,FALSE);
		set(V4,MUIA_ShowMe,FALSE);
		break;

		case 2:
		addVgroup=V3;
		set(V1,MUIA_ShowMe,TRUE);
		set(V2,MUIA_ShowMe,TRUE);
		set(V3,MUIA_ShowMe,TRUE);
		set(V4,MUIA_ShowMe,FALSE);
		break;

		case 3:
		addVgroup=V4;
		set(V1,MUIA_ShowMe,TRUE);
		set(V2,MUIA_ShowMe,TRUE);
		set(V3,MUIA_ShowMe,TRUE);
		set(V4,MUIA_ShowMe,TRUE);
		break;
	}


return(TRUE);
}


/* Allocs Memory for new Button Data */

BOOL AddFunc( void )
{

	if(!change)
	{
	if(itnum < _MAX_ELEMENTS )
	{
	GetVGroup(itnum);

	els[itnum].item=(UBYTE *)AllocMem(sizeof(UBYTE)*_MAX_ITCHARS , MEMF_CLEAR);
	els[itnum].prog=(UBYTE *)AllocMem(sizeof(UBYTE)*_MAX_PRGCHARS , MEMF_CLEAR);
	els[itnum].parms=(UBYTE *)AllocMem(sizeof(UBYTE)*_MAX_PARMSCHARS , MEMF_CLEAR);
	return( TRUE );
	}
	else
	return(FALSE);
	}

}

/* Load Data Function */

BOOL LoadFunc( void )
{

FILE *in;
char *buffer;

BOOL ok=FALSE ,er=FALSE;
BOOL itempres=FALSE;
BOOL okiload=FALSE;

buffer=(char *) AllocMem(50*sizeof(char),MEMF_PUBLIC|MEMF_CLEAR);

in=fopen(infile,"r");
	if(!in)
	{
	er=TRUE;
	PutTxt("Data File Not Found");
	} /* File Not Found */

	if(in)
	{
	okiload=GetBuffer(in,buffer);
	if(strcmp(buffer,"MUIMenu Data File")==0 && okiload  )
	ok=TRUE;
	}

	while(ok)
		{
	okiload=GetBuffer(in,buffer);


	itempres=FALSE;
	if(strcmp(buffer,"ITEM")==0 && okiload)
	itempres=TRUE;

	if(itempres)
	{
	okiload=GetBuffer(in,buffer);
	if(okiload)
	{
	strcpy(transit.item,buffer);
	okiload=GetBuffer(in,buffer);
	if(okiload)	
		{
	strcpy(transit.prog,buffer);
	okiload=GetBuffer(in,buffer);
	if(okiload)
			{
	strcpy(transit.parms,buffer);
	okiload=GetBuffer(in,buffer);
	if(okiload)
				{
	transit.async=atol(buffer);

	change=FALSE;
	if(AddFunc())
		AddButtFunc();
				}
				else
				ok=FALSE;
			}
			else
			ok=FALSE;
		}
		else
		ok=FALSE;
	}
	else
	ok=FALSE;

	if(!ok)
	er=TRUE;	/* if ok gets FALSE here there's an error so exit */


	} /* ITEM ok */


	if(!itempres)
	{

	if(strcmp(buffer,"END MUIMenu")==0 && okiload )
	ok=FALSE; /* END ok */
	else
	{
	er=TRUE;
	ok=FALSE;
	} /* END not ok */

	}

	} /* ok while */

	if(in)
	{
	fclose(in);
	if(!er)
	PutTxt("Data Loaded...");
	else
	PutTxt("Data File Error");
	} /* File Found */

FreeMem(buffer,50*sizeof(char));

return( TRUE );
}

/* Save Data Function */

BOOL SaveFunc( void )
{


FILE *out;
char *buffer;

int it;

buffer=(char *) AllocMem(50*sizeof(char),MEMF_PUBLIC|MEMF_CLEAR);

out=fopen(infile,"w");
	if(!out)
	{
	PutTxt("Output File not opened");
	} /* File Not Found */
	else
	{
	fprintf(out,"MUIMenu Data File\n");
	for(it=0;it<itnum;it++)
	{
	fprintf(out,"ITEM\n");
	fprintf(out,"%s\n",els[it].item);
	fprintf(out,"%s\n",els[it].prog);
	fprintf(out,"%s\n",els[it].parms);
	fprintf(out,"%ld\n",els[it].async);
	}
	fprintf(out,"END MUIMenu\n");

	if(out)
	fclose(out);
	}

FreeMem(buffer,50*sizeof(char));

return( TRUE );
}

/* Frees all data previously allocated by AddFunc */

BOOL CleanUpMem( void )
{
	ULONG act;

	for(act=0;act=itnum || !els[act].item ;act++)
		{
		FreeMem(els[ act ].item,sizeof(UBYTE)*_MAX_ITCHARS);
		FreeMem(els[ act ].prog,sizeof(UBYTE)*_MAX_PRGCHARS);
		FreeMem(els[ act ].parms,sizeof(UBYTE)*_MAX_PARMSCHARS);
		}

return(TRUE);
}

/* Function Bodies - End */




/* Main function */

int main(int argc,char *argv[])
{

	struct DiskObject	*DObj;
	APTR savebut,quitbut,aboutbut;

	/* Add Item Window and Child objects */
	APTR addwin,itemobj,prgobj,parmobj,asyncobj,chkobj,okbut,cancbut;
	ULONG signals;

	/* Shall contain prog name and following parms */
	UBYTE *launcher;

	BOOL tosave = FALSE ;

	/* Change flag and item to change */
	ULONG chnum=0;

	BOOL deletion=FALSE;
	ULONG delnum=0;

	BOOL saveadvert=FALSE;


	launcher=(UBYTE*)AllocMem(sizeof(UBYTE)*(_MAX_PRGCHARS+_MAX_PARMSCHARS+1),
		MEMF_CLEAR);

	buf=(UBYTE *)AllocMem(sizeof(UBYTE)*(_MAX_TXTCHARS + 1), MEMF_CLEAR );

	transit.item=(UBYTE *)AllocMem(sizeof(UBYTE)*_MAX_ITCHARS , MEMF_CLEAR);
	transit.prog=(UBYTE *)AllocMem(sizeof(UBYTE)*_MAX_PRGCHARS , MEMF_CLEAR);
	transit.parms=(UBYTE *)AllocMem(sizeof(UBYTE)*_MAX_PARMSCHARS , MEMF_CLEAR);


	init();

	app = ApplicationObject,
		MUIA_Application_Title      , "MUIMenu",
		MUIA_Application_Version    , "VER$: Version 1.00 by G. Chiesa",
		MUIA_Application_Copyright  , "1994 Giuseppe Chiesa",
		MUIA_Application_Author     , "Giuseppe Chiesa",
		MUIA_Application_Description, "MUI Pop Up Menu for tools execution",
		MUIA_Application_Base       , "MUIMENU",

		MUIA_Application_SingleTask, 	TRUE,
		MUIA_Application_DiskObject,	DObj=GetDiskObjectNew("PROGDIR:MUIMenu"),
		MUIA_HelpFile,			"MUIMenu.guide",

		SubWindow, window = WindowObject,
			MUIA_Window_Title, "MUIMenu",
			MUIA_Window_ID   , MAKE_ID('M','U','M','N'),

			MUIA_HelpNode,	"Usage",

			WindowContents,VGroup,

			MUIA_Frame,		MUIV_Frame_Group,
			MUIA_FrameTitle,	"MUI-Menu 1.00",

			Child,		HGroup,
			MUIA_Group_SameSize,	TRUE,
			Child,	V1=VGroup, End,
			Child,	V2=VGroup, End,
			Child,	V3=VGroup, End,
			Child,	V4=VGroup, End,
					End,

			Child,	VSpace(2),

			Child,		VGroup,
			Child,	ColGroup(2),
				MUIA_Group_SameSize,	TRUE,
				Child,	addbut=KeyButton("ADD",'a'),
				Child,	delbut=SimpleButton("DELETE"),

				Child,  changebut=SimpleButton("CHANGE"),
				Child,	aboutbut=SimpleButton("ABOUT"),

				Child,	savebut=SimpleButton("SAVE"),
				Child,	quitbut=SimpleButton("QUIT"),
				MUIA_HelpNode,	"EditButtons",

				End,

			Child,	HGroup,
				Child,	Label("Info:"),
				Child,	txtobj=TextObject,
				TextFrame,
				MUIA_Text_Contents,	"",
				End,
			End,
				
				End,

					End,
			End,

		SubWindow, addwin=WindowObject,
			MUIA_Window_Title, "Add Item",
			MUIA_Window_ID,	MAKE_ID('A','D','D','T'),

			MUIA_HelpNode,	"EditWindow",

			WindowContents,	VGroup,

			Child,	ColGroup(2),	

				Child,	KeyLabel2("Item Name:",'i'),
				Child,	itemobj=KeyString("",_MAX_ITCHARS,'i'),

				Child,	KeyLabel2("File Name:",'f'),
				Child,	prgobj=PopaslObject,
					MUIA_Popstring_String,KeyString("",_MAX_PRGCHARS,'f'),
					MUIA_Popstring_Button, PopButton(MUII_PopFile),
					ASLFR_TitleText, "Please select a file...",
					End,

				Child,	KeyLabel2("Prg Parms:",'p'),
				Child,	parmobj=KeyString("",_MAX_PARMSCHARS,'p'),

				Child,	HSpace(80),
				Child,	HSpace(128),

				End,

			Child,	HGroup,

				Child,	asyncobj=KeyLabel("Async:",'a'),
				Child,	chkobj=CheckMark( TRUE ),
					MUIA_HelpNode,	"SyncVSAsync",
			End,

			Child,	HGroup,
				MUIA_Group_SameSize,	TRUE,
				Child,	okbut=KeyButton("OK",'o'),
				MUIA_HelpNode,	"EditWindow",
				MUIA_HelpLine,	10,
				Child,	cancbut=KeyButton("Cancel",'c'),
				MUIA_HelpNode,	"EditWindow",
				MUIA_HelpLine,	18,
			End,
					End,
			End,

		End;

	if (!app)
		fail(app,"Failed to create Application.");

	DoMethod(window,MUIM_Notify,MUIA_Window_CloseRequest,TRUE,
		app,2,MUIM_Application_ReturnID,_HIDE_ID);

	DoMethod(quitbut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,MUIV_Application_ReturnID_Quit);

	DoMethod(savebut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,_SAVE_ID);

	DoMethod(addbut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,_ADD_ID);

	DoMethod(delbut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,_DEL_ID);

	DoMethod(changebut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,_CHANGE_ID);

	DoMethod(aboutbut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,_ABOUT_ID);

	DoMethod(okbut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,_OK_ID);

	DoMethod(cancbut,MUIM_Notify,MUIA_Pressed,FALSE,
		app,2,MUIM_Application_ReturnID,_CANCEL_ID);


	DoMethod(window,MUIM_Window_SetCycleChain,
		addbut,delbut,changebut,aboutbut,savebut,quitbut,NULL);

	DoMethod(addwin,MUIM_Window_SetCycleChain,
		itemobj,prgobj,parmobj,chkobj,okbut,cancbut,NULL);


/*
** Input loop...
*/
	set(V1,MUIA_ShowMe,FALSE);
	set(V2,MUIA_ShowMe,FALSE);
	set(V3,MUIA_ShowMe,FALSE);
	set(V4,MUIA_ShowMe,FALSE);

	LoadFunc();

	if(itnum==0)
		{
		set(delbut,MUIA_Disabled,TRUE);
		set(changebut,MUIA_Disabled,TRUE);
		}

	set(window,MUIA_Window_Open,TRUE);

	while (running)
	{
		switch (DoMethod(app,MUIM_Application_Input,&signals))
		{

			case _HIDE_ID:
				set(app,MUIA_Application_Iconified, TRUE);
				break;

			case MUIV_Application_ReturnID_Quit:
				if(tosave)
				{
				if(!saveadvert)
				{
				PutTxt("Data Changed SAVE First");
				saveadvert=TRUE;
				}
				else
				{
				PutTxt("QUIT without SAVING");
				Delay(50);			
				running = FALSE;
				}
				}
				else
				{
				running = FALSE;
				}
				break;

			case _ABOUT_ID:
			if(deletion || change)
			{
			saveadvert=FALSE;
			deletion=FALSE;
			change=FALSE;
			PutTxt("Action Cancelled");
			}
			else
			MUI_RequestA(app,window,0,NULL,"_Thanx",Thxtxt,NULL);
				break;

			case _SAVE_ID:
				SaveFunc();
				PutTxt("Data Saved...");
				tosave=FALSE;
				saveadvert=FALSE;
				break;

			case _ADD_ID:
				saveadvert=FALSE;
				change=FALSE;
				if(itnum < _MAX_ELEMENTS)
				{
				set(itemobj,MUIA_String_Contents,"");
				set(prgobj,MUIA_String_Contents,"");
				set(parmobj,MUIA_String_Contents,"");
				set(chkobj,MUIA_Selected,TRUE);

				set(addwin,MUIA_Window_Open,TRUE);
				}
				break;

			case _OK_ID:

			PutTxt("");
			get(itemobj,MUIA_String_Contents,&transit.item);
			get(prgobj,MUIA_String_Contents,&transit.prog);
			get(parmobj,MUIA_String_Contents,&transit.parms);
			get(chkobj,MUIA_Selected,&transit.async);

			set(addwin,MUIA_Window_Open,FALSE);

			if(AddFunc())
			{
			tosave=TRUE;
			set(window,MUIA_Window_Open,FALSE);

			if(!change)
			AddButtFunc();	 /* !change */
			else
			{	
			strcpy(els[ chnum ].item,transit.item);
			strcpy(els[ chnum ].prog,transit.prog);
			strcpy(els[ chnum ].parms,transit.parms);
			els[ chnum ].async=transit.async;
			set(labbuts[chnum],MUIA_Text_Contents,transit.item);
			PutTxt("Item Changed...");
			} /* change */
	
			set(window,MUIA_Window_LeftEdge,MUIV_Window_LeftEdge_Centered);

			set(window,MUIA_Window_Open,TRUE);

			set(window,MUIA_Window_Activate,TRUE);

			} /* AddFunc */
			else
			{	
			PutTxt("No More Space Sorry...");		
			} /* !AddFunc */

			change=FALSE;
				break;

			case _CANCEL_ID:
			set(addwin,MUIA_Window_Open,FALSE);
			set(window,MUIA_Window_Activate,TRUE);
			change=FALSE;

				break;

			case _DEL_ID:
			if(itnum>0)
			{
			deletion=TRUE;
			PutTxt("Delete - ABOUT Cancel");
			}
			else
			{
		/* Unuseful : Del button gets Disabled when itnum = 0 */
			PutTxt("No Item to Delete");
			deletion=FALSE;
			}
				break;

			case _CHANGE_ID:
			if(itnum>0)
			{
			change=TRUE;
			PutTxt("Change - ABOUT Cancel");
			}
			else
			{
		/* Unuseful : Change button gets Disabled when itnum = 0 */
			PutTxt("No Item to Change");
			change=FALSE;
			}
				break;

			case _LAUNCH_ID:

			/* Thanks to Notify capibility numb has already
			   been filled with the correct item number */ 

			saveadvert=FALSE;

			if(!change && !deletion)
			{	
			if(els[numb].async==1L)
				strcpy(launcher,"C:Run >nil: <nil: ");
			else if(els[numb].async==0L)
				strcpy(launcher,(UBYTE *)"\0");

			strcat(launcher,els[numb].prog);
			strcat(launcher,(UBYTE *)" \0");
			strcat(launcher,els[numb].parms);

			if(strcmp(els[numb].prog,"")!=0)
			system(launcher);
			}

			if(change)
			{
			PutTxt("");
			chnum=numb;
			set(itemobj,MUIA_String_Contents,els[chnum].item);
			set(prgobj,MUIA_String_Contents,els[chnum].prog);
			set(parmobj,MUIA_String_Contents,els[chnum].parms);
			set(chkobj,MUIA_Selected,els[chnum].async);
			set(addwin,MUIA_Window_Open,TRUE);
			PutTxt("Item Changed...");
			tosave=TRUE;
			}

			if(deletion)
			{
			PutTxt("");
			delnum=numb;
			set(window,MUIA_Window_Open,FALSE);
			GetVGroup(numb);
			itnum--;
			if(delnum!=itnum)
			{
			strcpy(els[ delnum ].item,els[ itnum ].item);
			strcpy(els[ delnum ].prog,els[ itnum ].prog);
			strcpy(els[ delnum ].parms,els[ itnum ].parms);
			els[ delnum ].async=els[ itnum ].async;
		set(labbuts[delnum],MUIA_Text_Contents,els[itnum].item);
			}
 			DoMethod(addVgroup,OM_REMMEMBER,buttons[itnum]);
			MUI_DisposeObject(buttons[itnum]);
		FreeMem(els[itnum].item,sizeof(UBYTE)*_MAX_ITCHARS);
		FreeMem(els[itnum].prog,sizeof(UBYTE)*_MAX_PRGCHARS);
		FreeMem(els[itnum].parms,sizeof(UBYTE)*_MAX_PARMSCHARS);
			GetVGroup(itnum-1);
			set(window,MUIA_Window_LeftEdge,MUIV_Window_LeftEdge_Centered);
			set(window,MUIA_Window_Open,TRUE);
			if(itnum<_MAX_ELEMENTS)
				set(addbut,MUIA_Disabled,FALSE);
			tosave=TRUE;
			deletion=FALSE;
			if(itnum==0)
			{
			set(delbut,MUIA_Disabled,TRUE);
			set(changebut,MUIA_Disabled,TRUE);
			}

			}
				break;

		}
		if (running && signals) Wait(signals);

	}

	set(window,MUIA_Window_Open,FALSE);


/*
** Shut down...
*/

	if(app)
	fail(app,NULL);

	CleanUpMem();

	if(transit.item)
	FreeMem(transit.item,sizeof(UBYTE)* _MAX_ITCHARS );
	if(transit.prog)
	FreeMem(transit.prog,sizeof(UBYTE)* _MAX_PRGCHARS );
	if(transit.parms)
	FreeMem(transit.parms,sizeof(UBYTE)* _MAX_PARMSCHARS );

	if(buf)
	FreeMem(buf,sizeof(UBYTE)*(_MAX_TXTCHARS + 1));

	if(launcher)
	FreeMem(launcher,sizeof(UBYTE)*(_MAX_PRGCHARS+_MAX_PARMSCHARS+1) );

	if(DObj)
	FreeDiskObject(DObj);

}

/* End of MUIMenu */