//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//



#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"

/* Defines for Soundblaster and Soundblaster Pro IO address */

void fill_buff(void);
extern void display_up(void);
extern void display_dn(void);
void effect_0(void);
void effect_1(void);
void effect_2(void);
void effect_3(void);
extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);


void massage_audio(void)
{
	int temp,x,y;
	int temp2;
	int top=0;

	switch (massageStyle) {
		case 0:
		default:
			break;
		case 1:
			temp=stereo[0][1];
			temp2=stereo[0][0];
			for (x=1; x<BUFF_WIDTH; x++) {
				if ((stereo[x][1]-temp)>10) {
					stereo[x][1]=temp+10;
				} else if ((stereo[x][1]-temp)<-10) {
					stereo[x][1]=temp-10;
				}
				if ((stereo[x][0]-temp2)>10) {
					stereo[x][0]=temp2+10;
				} else if ((stereo[x][0]-temp2)<-10) {
					stereo[x][0]=temp2-10;
				}
				temp=stereo[x][1];
				temp2=stereo[x][0];
			}
			break;
		case 2:
			temp=stereo[0][1];
			temp2=stereo[0][0];
			for (x=1; x<BUFF_WIDTH; x++) {
				if ((stereo[x][1]-temp)>3) {
					stereo[x][1]=temp+3;
				} else if ((stereo[x][1]-temp)<-3) {
					stereo[x][1]=temp-3;
				}
				if ((stereo[x][0]-temp2)>3) {
					stereo[x][0]=temp2+3;
				} else if ((stereo[x][0]-temp2)<-3) {
					stereo[x][0]=temp2-3;
				}
				temp2=stereo[x][0];
				temp=stereo[x][1];
			}
			break;
	}

}

static void do_vwave(int ystart,int yend,int x,unsigned int val)
{
	int y,ys,ye;

	ystart=min(max(ystart,0),BUFF_HEIGHT-1);
	yend=min(max(yend,0),BUFF_HEIGHT-1);

	if (ystart>yend) {
		ye=ystart;
		ys=yend;
	} else {
		ys=ystart;
		ye=yend;
	}


	for (y=ys; y<=ye; y++)
		buff[y][x]=val;
}

static void do_hwave(int xstart,int xend,int y,unsigned int val)
{
	int x,xs,xe;

	xstart=min(max(xstart,0),BUFF_WIDTH-1);
	xend=min(max(xend,0),BUFF_WIDTH-1);

	if (xstart>xend) {
		xe=xstart;
		xs=xend;
	} else {
		xs=xstart;
		xe=xend;
	}


	for (x=xs; x<=xe; x++)
		buff[y][x]=val;
//	memset(&(buff[y][xs]),val,(xe-xs+1));
}


static void wave_buff0(void)
{
	int temp,x;

	for (x=0; x<BUFF_WIDTH; x++) {
		temp=stereo[x][0];
		buff[BUFF_BOTTOM-(temp>>2)-20][(x)>>1]=table[curtable][temp];
		temp=stereo[x][1];
		buff[BUFF_BOTTOM-(temp>>2)-20][(x+BUFF_WIDTH)>>1]=table[curtable][temp];
	}

}

static void wave_buff1(void)
{
	int temp,x;


	for (x=0; x<BUFF_WIDTH; x++) {
		temp=stereo[x][0];
		buff[BUFF_BOTTOM-(temp>>1)-20][(x)>>1]=table[curtable][temp];
		temp=stereo[x][1];
		buff[BUFF_BOTTOM-(temp>>1)-20][(x+BUFF_WIDTH)>>1]=table[curtable][temp];
	}

}

static void wave_buff2(void)
{
	int temp,x;

	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][0];
		buff[x][160-(temp>>2)]=table[curtable][temp];
		temp=stereo[x][1];
		buff[x][160+(temp>>2)]=table[curtable][temp];
	}

}

static void wave_buff3(void)
{
	int temp,x,i;


	for (x=0; x<BUFF_WIDTH; x++) {
		temp=abs(128-stereo[x][0])>>1;
		for (i=0; i<temp; i++)
			buff[BUFF_BOTTOM-i][(x)>>1]=table[curtable][i];

		temp=abs(128-stereo[x][1])>>1;
		for (i=0; i<temp; i++)
			buff[BUFF_BOTTOM-i][(x+BUFF_WIDTH)>>1]=table[curtable][i];
	}

}

static void wave_buff4(void)
{
	int temp,x,i;


	for (x=0; x<BUFF_WIDTH; x++) {
		temp=abs(128-stereo[x][0]);
		for (i=0; i<temp; i++)
			buff[BUFF_BOTTOM-i][x>>1]=table[curtable][temp];
	}

	for (x=0; x<BUFF_WIDTH; x++) {
		temp=abs(128-stereo[x][1]);
		for (i=0; i<temp; i++)
			buff[BUFF_BOTTOM-i][(x+BUFF_WIDTH)>>1]=table[curtable][temp];
	}

}

static void wave_buff5(void)
{
	int temp,x,y;
	int last=128;


	for (y=0; y<2; y++)
		for (x=0; x<BUFF_WIDTH; x++) {
			temp=stereo[x][y];
			do_vwave(BUFF_BOTTOM-(temp>>2),BUFF_BOTTOM-(last>>2),(y)?((x+BUFF_WIDTH)>>1):(x>>1),table[curtable][temp]);
			last=temp;
		}

}

static void wave_buff6(void)
{
	int temp,x,y;
	int last=128;


	for (y=0; y<2; y++)
		for (x=0; x<BUFF_WIDTH; x++) {
			temp=stereo[x][y];
			do_vwave(BUFF_BOTTOM-(temp>>1),BUFF_BOTTOM-(last>>1),(y)?((x+BUFF_WIDTH)>>1):(x>>1),table[curtable][temp]);
			last=temp;
		}

}

static void wave_buff7(void)
{
	int temp,x;

	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][0];
		buff[x][160-(temp>>1)]=table[curtable][temp];
		temp=stereo[x][1];
		buff[x][160+(temp>>1)]=table[curtable][temp];
	}

}

static void wave_buff8(void)
{
	int temp,x,y;
	int last=0;


	for (y=0; y<2; y++)
		for (x=0; x<BUFF_WIDTH; x++) {
			temp=stereo[x][y];
			temp=abs(128-temp);
			do_vwave(BUFF_BOTTOM-(temp),BUFF_BOTTOM-(last),(y)?((x+BUFF_WIDTH)>>1):(x>>1),table[curtable][temp]);
			last=temp;
		}

}

static void wave_buff9(void)   // *******************************************
{

	int temp,x,last1=128,last2=128;
	static col=128;

	col=(col+1)%BUFF_WIDTH;


	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][0];
		do_hwave(col-(temp>>2),col-(last1>>2),x,table[curtable][temp]);
		last1=temp;

		temp=stereo[x][1];
		do_hwave(col+(temp>>2),col+(last2>>2),x,table[curtable][temp]);
		last2=temp;
	}
}

static void wave_buff10(void)   // *******************************************
{
	int i;
	static int row=0;

	row=(row+1)%BUFF_BOTTOM;

	for (i=0; i<160; i++) {
		buff[row][i]      =table[curtable][stereo[i][0]];
		buff[row+1][i]    =table[curtable][stereo[i][0]];
		buff[row][i+160]  =table[curtable][stereo[i][1]];
		buff[row+1][i+160]=table[curtable][stereo[i][1]];
	}

}

static void wave_buff11(void) // **************************************
{
	int temp,x,temp2;
	
	for (x=0; x<BUFF_WIDTH; x++) {
		temp=stereo[x][0];
		temp2=stereo[x][1];

		buff[(temp+200-28)%BUFF_BOTTOM][(temp2+32)%BUFF_WIDTH]=table[curtable][temp];
	}

}

static void wave_buff12(void)
{
	int temp,x,last1=128,last2=128;

	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][0];
		do_hwave(BUFF_WIDTH/2-(temp>>2),BUFF_WIDTH/2-(last1>>2),x,table[curtable][temp]);
		last1=temp;

		temp=stereo[x][1];
		do_hwave(BUFF_WIDTH/2+(temp>>2),BUFF_WIDTH/2+(last2>>2),x,table[curtable][temp]);
		last2=temp;
	}

}

static void wave_buff13(void)
{
	int temp,x,last1=128,last2=128;

	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][0];
		do_hwave(BUFF_WIDTH/2-(temp>>1),BUFF_WIDTH/2-(last1>>1),x,table[curtable][temp]);
		last1=temp;

		temp=stereo[x][1];
		do_hwave(BUFF_WIDTH/2+(temp>>1),BUFF_WIDTH/2+(last2>>1),x,table[curtable][temp]);
		last2=temp;
	}

}

static void wave_buff14(void)
{
	int temp,x,last=128;

	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][0];
		do_hwave(160-(temp>>2),160-(last>>2),x,table[curtable][temp]);
		last=temp;
	}

	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][1];
		do_hwave(120+(temp>>2),120+(last>>2),x,table[curtable][temp]);
		last=temp;
	}

}

static void wave_buff15(void)
{
	int temp=100,x,last=100;

	for (x=0; x<BUFF_BOTTOM; x++) {

		temp=((stereo[x][0]-127)/16)+last;

		if (temp>=BUFF_WIDTH)
			temp=BUFF_WIDTH-1;
		if (temp<0)
			last=0;

		temp=temp%BUFF_WIDTH;
//		do_hwave(temp,last,x,table[curtable][temp]);
		do_hwave(temp,last,x,255);
		last=temp;
	}

	last=200; temp=200;
	for (x=0; x<BUFF_BOTTOM; x++) {

		temp=((stereo[x][1]-127)/16)+last;

		if (temp>=BUFF_WIDTH)
			temp=BUFF_WIDTH-1;
		if (temp<0)
			last=0;

		temp=temp%BUFF_WIDTH;
//		do_hwave(temp,last,x,table[curtable][temp]);
		do_hwave(temp,last,x,255);
		last=temp;

	}
}

static void wave_buff16(void)
{
	int temp=100,x,last=100;


	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=((stereo[x][0]-127)/32)+last;
		if (temp>=BUFF_WIDTH)
			temp=BUFF_WIDTH-1;
		if (temp<0)
			last=0;

		temp=temp%BUFF_WIDTH;
//		do_hwave(temp,last,x,table[curtable][temp]);
		do_hwave(temp,last,x,255);
		last=temp;

	}

	last=200; temp=200;
	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=((stereo[x][1]-127)/32)+last;

		if (temp>=BUFF_WIDTH)
			temp=BUFF_WIDTH-1;
		if (temp<0)
			last=0;

		temp=temp%BUFF_WIDTH;
//		do_hwave(temp,last,x,table[curtable][temp]);
		do_hwave(temp,last,x,255);
		last=temp;

	}
}


static void wave_buff17(void)
{
	int temp=160,x,last=160;

	for (x=0; x<BUFF_BOTTOM; x++) {
		temp=stereo[x][0];
		buff[x][160-(temp>>2)]=table[curtable][temp];
		temp=stereo[x][1];
		buff[x][160+(temp>>2)]=table[curtable][temp];
	}

}


int usewave=0;
void next_wave(void)
{
	usewave=(usewave+1)%NUMWAVES;
}

void change_wave(int wavenum)
{
	usewave=wavenum%NUMWAVES;
}

void wave(void) {
	switch (usewave) {
		case 0:
		default:
			wave_buff0();
			break;
		case 1:
			wave_buff1();
			break;
		case 2:
			wave_buff2();
			break;
		case 3:
			wave_buff3();
			break;
		case 4:
			wave_buff4();
			break;
		case 5:
			wave_buff5();
			break;
		case 6:
			wave_buff6();
			break;
		case 7:
			wave_buff7();
			break;
		case 8:
			wave_buff8();
			break;
		case 9:
			wave_buff9();
			break;
		case 10:
			wave_buff10();
			break;
		case 11:
			wave_buff11();
			break;
		case 12:
			wave_buff12();
			break;
		case 13:
			wave_buff13();
			break;
		case 14:
			wave_buff14();
			break;
		case 15:
			wave_buff15();
			break;
		case 16:
			wave_buff16();
			break;
		case 17:
			wave_buff17();
			break;
		case 18:
			pete_0();
			break;
		case 19:
			pete_1();
			break;
		case 20:
			pete_2();
			break;
	}
}


