#!ĴTemplate SegmentĿ
#!                               Clarion.TPL              Version: 3007.105
#!ĴContentsĴ
#!Structure             Type       Description                              
#!    ĳ
#!-None-                PROGRAM    Standard Procedure Code                  
#!-None-                MODULE     Standard Module Code                     
#!Ĵ
#! CLARION.TPL is the first of a chain of template files that contain the   
#! standard Clarion procedure templates.  These templates generate CUA      
#! compliant, text-based applications.  Other files in the template chain   
#! are PullDown.TPX, Menu.TPX, and so forth.                                
#!                                                                          
#! Initial screen, report, and action images are contained in corresponding 
#! application files with an extension of .APP (e.g. CLARION.APP).          
#!                                                                          
#! Template Listing (In CHAIN Order)                                        
#!                                                                          
#!   Clarion.TPL     Module       Initialize a module                       
#!                   Program      Initialize a program                      
#!   PullDown.TPX    Pulldown     Execute a procedure from a pulldown menu  
#!   Menu.TPX        Menu         Execute a procedure from a pop-up menu    
#!   Browse.TPX      Browse       Browse records directly from a file       
#!   List.TPX        List         List a file's records from a memory queue 
#!   Lookup.TPX      Lookup       Setup procedure to lookup a field         
#!   Validate.TPX    Validate     Edit procedure to lookup a field          
#!   Select.TPX      Select       Load a selected record into memory        
#!   Form.TPX        Form         Update a record with a form               
#!   MultiPg.TPX     MultiPage    Update a file with a multiple page entry  
#!   PageOf.TPX      PageOf       Data entry 'Page' used with the MultiPage 
#!   Child.TPX       Child        Update a batch of Child records           
#!   Report.TPX      Report       Print a report                            
#!   Print.TPX       Print        Print a report from memory                
#!   Redirect.TPX    Redirect     Select destination for a report           
#!   View.TPX        View         View a selected text file in a listbox    
#!   Batch.TPX       Batch        Sequential record processing of a file.   
#!   File.TPX        File         Select a file from a directory listing    
#!   Screen.TPX      Screen       Process any screen                        
#!   Source.TPX      Source       Process any source code                   
#!   External.TPX    External     Document external procedure call          
#!   ToDo.TPX        Todo         Undefined procedure code                  
#!   FileCtrl.TPX    #GROUPs      Associated with File Opening/Closing      
#!   Relation.TPX    #GROUPs      Associated with R/I Changes/Deletes       
#!   ScrnFlds.TPX    #GROUPs      Associated with Screen Edit/Setup Code    
#!   BrwsGrps.TPX    #GROUPs      Associated with BROWSE type procedures    
#!   ChldGrps.TPX    #GROUPs      Associated with CHILD procedures          
#!   FormGrps.TPX    #GROUPs      Associated with FORM type procedures      
#!   MiscGrps.TPX    #GROUPs      Used in various places in the CHAIN       
#!   RptGrps.TPX     #GROUPs      Associated with REPORT type procedures    
#!   Warnings.TPX    #GROUPs      WARNINGS issued (for easy customization)  
#!   CPD21.TPX       Form21       Version 2.1-Style Form Procedure          
#!                   Menu21       Version 2.1-Style Menu Procedure          
#!                   MemForm21    Version 2.1-Style MemForm Procedure       
#!                   Table21      Version 2.1-Style Table Procedure         
#!ĴCommentsĴ
#!Version   Comments                                                        
#!  ĳ
#!3007.000  Release of CDD3 version 3007 templates                          
#!3007.105  Modified CheckOpen Function                                     
#!          Modified CheckOpen Procedure                                    
#!          Modified DiskError Function                                     
#!
#!
#PROGRAM
#!
#!Ŀ
#!                                #PROGRAM                Version: 3007.000
#!ĴDescriptionĴ
#!The Program template generates the PROGRAM statement, MAP structure, FILE 
#!structures, and global declarations for a Clarion program.  This template 
#!also blanks the screen and calls the first procedure.  There is only one  
#!#PROGRAM segment in a template file chain.                                
#!ĴCommentsĴ
#!Version   Comments                                                        
#!  ĳ
#!3007.000  Release of CDD3 version 3007 templates                          
#!
#!
#PROMPT('Enable &Shared Files',CHECK),%SharedFiles
#PROMPT('Enable Mouse Support',CHECK),%MouseSupport
#PROMPT('Enhanced Background?',CHECK),%EnhancedBackground
#PROMPT('Close Unused &Files?',CHECK),%CloseFiles
#PROMPT('If &File Not Found',OPTION),%FileNotFound
#PROMPT('Create',RADIO)
#PROMPT('Halt',RADIO)
#PROMPT('Program &Author',@S30),%Author
#!
#IF(%SharedFiles)
  #SET(%AccessMode,'42h')
#ELSE
  #SET(%AccessMode,'22h')
#ENDIF
                TITLE('%Program')
OMIT('')
ͻ
  Program - %Program                          #<!                           
  Author  - %Author                           #<!                           
ͼ
                 PROGRAM

                 INCLUDE('KEYCODES.EQU')
                 INCLUDE('CLARION.EQU')
                 INCLUDE('ERRORS.EQU')

                 MAP
#IF(%CloseFiles)
                   CheckOpen(FILE),BYTE
#ELSE
                   CheckOpen(FILE)
#ENDIF
                   DiskError(<STRING>),BYTE
                   ShowWarning
                   %ModuleStructures
                   #EMBED('Inside Global MAP')
                 END

                 EJECT('File Layouts')

%GlobalData
#EMBED('Before File Declarations')

#FOR(%AppFiles)
  #FIX(%File,%AppFiles)
 OMIT('')
Ŀ
File:   %File                                 #<!                           
Prefix: %FilePre                              #<!                           
  #IF(%FileDescription)
Desc:   %FileDescription                      #<!                           
  #ENDIF
Driver: %FileType                             #<!                           
  #IF(%FileTypeParameter)
  Code: %FileTypeParameter                    #<!                           
  #ENDIF
  #IF(%FileOwner)
Owner:  %FileOwner                            #<!                           
  #ENDIF
  #IF(%FileCreate)
File Create On                                #<!                           
  #ELSE
File Create Off                               #<!                           
  #ENDIF
  #FOR(%Key)
Ĵ
    #IF(%Key=%FilePrimaryKey)
Key:    %Key (Primary)                        #<!                           
    #ELSE
Key:    %Key                                  #<!                           
    #ENDIF
    #IF(%KeyDescription)
Desc:   %KeyDescription                       #<!                           
    #ENDIF
    #IF(%KeyAuto)
Auto Increment                                #<!                           
    #ENDIF
    #IF(%KeyDuplicate)
Key ALLOWS Duplicates                         #<!                           
    #ELSE
Key DOES NOT Allow Duplicates                 #<!                           
    #ENDIF
    #FOR(%KeyField)
      #IF(%KeyFieldSequence = 'ASCENDING')
Field (Ascending):  %KeyField                 #<!                           
      #ELSE
Field (Descending): %KeyField                 #<!                           
      #ENDIF
    #ENDFOR
  #ENDFOR

%FileStructure
#ENDFOR

AddRecord        EQUATE(1)                     #<!  Add a new record
ChangeRecord     EQUATE(2)                     #<!  Change the current record
DeleteRecord     EQUATE(3)                     #<!  Delete the current record
SelectRecord     EQUATE(4)                     #<!  Select the current record
#EMBED('Data Section')


  CODE
  #EMBED('Setup Program')
  LOADSYMBOLS                                  #<!Display graphic mouse
  #IF(%EnhancedBackground)
  SETNOBLINK                                   #<!Enable enhanced colors
  #ENDIF
  #IF(%HelpFile)
  HELP('%HelpFile')                            #<!Open the help file
  #ENDIF
  #IF(%StyleFile )
  GETSTYLES('%StyleFile')                      #<!Open the style file
  #ENDIF
  #IF(%MouseSupport)
  SETMOUSE(1,1)                                #<!Turn on mouse
  #ENDIF
  SETCOLOR(WhiteOnBlack)                       #<!Set white on black
  BLANK                                        #<!Clear the screen
  SETCOLOR                                     #<!Turn off override color

  %FirstProcedure                              #<!Call the first procedure

  #EMBED('Before return to DOS')
  RETURN                                       #<!Return to DOS

OMIT('')
#IF(%CloseFiles)                                #!Generate function for close

Ĵ Function Ŀ
                                 CheckOpen              Version: 3007.105
ĴDescriptionĴ
 Function called to insure that a file is open.  In this code, file       
 opening is attempted.  If no error is perceived, a Value of 1 is         
 returned, informing the calling procedure that the file was indeed       
 opened during this call.  If the file is already opened, a Value of      
 0 is returned.  Otherwise, if errors are set by the OPEN procedure,      
 the appropriate maintenance actions occur, or the user is informed.      
ĴCommentsĴ
Version   Comments                                                        
  ĳ
3007.000  Release of CDD3 version 3007 templates                          
3007.105  Added the ProcedureReturn ROUTINE                               
          Added several EMBED points                                      
          Added LOC::ReturnVal, to allow a common exit point              


CheckOpen         FUNCTION(File)
LOC::ReturnVal    BYTE(0)

  CODE
  #EMBED('CheckOpen: Setup Procedure')
  OPEN(File,%AccessMode)                       #<!Attempt to open the file
  CASE ERRORCODE()                             #<! and check for errors
  OF NoError                                   #<!Return opened flag
    #EMBED('CheckOpen: No Error')
    LOC::ReturnVal = True
    DO ProcedureReturn                           ! signal successful open
  OF IsOpenErr                                 #<! or if already open.
    #EMBED('CheckOpen: File Open Error')
    DO ProcedureReturn
  #IF(%FileNotFound <> 'Halt')
  OF NoFileErr                                 #<!If file was not found
    #EMBED('CheckOpen: No File Error')
    CREATE(File)                               #<!Create the file
    IF ERRORCODE()
      #INSERT(%CreateFailureMsg)
    END
    OPEN(File,%AccessMode)                     #<! then open it
    IF ~ERRORCODE()                            #<!  And return if it opened
      LOC::ReturnVal = True
      DO ProcedureReturn                         ! signal successful open
    ELSE
      HALT(ERRORCODE())
    END
  #ENDIF
  OF InvalidFileErr                            #<!Invalid Record Declaration
    #EMBED('CheckOpen: Invalid File Error')
    #INSERT(%InvalidFileMsg)
    HALT(InvalidFileErr)
  OF BadKeyErr                                 #<!Key Files must be rebuilt
    #EMBED('CheckOpen: Bad Key Error')
    #INSERT(%BadKeyMsg)
    OPEN(File,12H)                               !Open for exclusive access
    BUILD(File)                                  !Rebuild the key files
    IF ERRORCODE()
      #INSERT(%KeyBuildErrorMsg)
      HALT(BadKeyErr)
    ELSE
      CLOSE(File)                                !Close
      OPEN(File,%AccessMode)                   #<! then re-open it
      LOC::ReturnVal = True
      DO ProcedureReturn                         ! signal successful open
    END
  END                                          #<!End of Case Structure
  IF DiskError(NAME(File) & ' File could not be opened') THEN HALT(0). #<!Cannot resume
ProcedureReturn ROUTINE
  #EMBED('CheckOpen: Directly before return')
  RETURN(LOC::ReturnVal)
#ELSE                                           #!Generate procedure

Ĵ Procedure Ŀ
                                CheckOpen               Version: 3007.105
ĴDescriptionĴ
 Procedure called to insure that a file is open.  In this code, file      
 opening is attempted.  If no error is perceived, or the file is already  
 open, the procedure returns with no additional action.                   
 If errors are set by the OPEN procedure, the appropriate maintenance     
 actions occur, or the user is informed.                                  
ĴCommentsĴ
Version   Comments                                                        
  ĳ
3007.000  Release of CDD3 version 3007 templates                          
3007.105  Added the ProcedureReturn ROUTINE                               
          Added several EMBED points                                      


CheckOpen         PROCEDURE(File)

  CODE
  #EMBED('CheckOpen: Setup Procedure')
  OPEN(File,%AccessMode)                       #<!Attempt to open the file
  CASE ERRORCODE()                             #<! and check for errors
  OF NoError                                   #<!Return if no error
    #EMBED('CheckOpen: No Error')
  OROF IsOpenErr                               #<! or if already open.
    #EMBED('CheckOpen: File Open Error')
    DO ProcedureReturn
  #IF(%FileNotFound <> 'Halt')
  OF NoFileErr                                 #<!If file was not found
    #EMBED('CheckOpen: No File Error')
    CREATE(File)                               #<!Create the file
    IF ERRORCODE()
      #INSERT(%CreateFailureMsg)
    END
    OPEN(File,%AccessMode)                     #<! then open it
    IF ~ERRORCODE()                            #<!  And return if it opened
      DO ProcedureReturn
    ELSE
      HALT(ERRORCODE())
    END
  #ENDIF
  OF InvalidFileErr                            #<!Invalid Record Declaration
    #EMBED('CheckOpen: Invalid File Error')
    #INSERT(%InvalidFileMsg)
    HALT(InvalidFileErr)
  OF BadKeyErr                                 #<!Key Files must be rebuilt
    #EMBED('CheckOpen: Bad Key Error')
    #INSERT(%BadKeyMsg)
    OPEN(File,12H)                             #<!Open for exclusive access
    BUILD(File)                                #<!Rebuild the key files
    IF ERRORCODE()
      #INSERT(%KeyBuildErrorMsg)
      HALT(BadKeyErr)
    ELSE
      CLOSE(File)                              #<!Close
      OPEN(File,%AccessMode)                   #<! then open it
    END
  END                                          #<!End of Case Structure
  IF DiskError(NAME(File) & ' File could not be opened') THEN HALT(0). #<!Cannot resume
  DO ProcedureReturn
ProcedureReturn ROUTINE
  #EMBED('CheckOpen: Directly before return')
  RETURN
#ENDIF
OMIT('')

Ĵ Function Ŀ
                                DiskError               Version: 3007.105
ĴDescriptionĴ
 Function called to post errors if a disk related error has occurred.     
ĴCommentsĴ
Version   Comments                                                        
  ĳ
3007.000  Release of CDD3 version 3007 templates                          
3007.105  Added the ProcedureReturn ROUTINE                               
          Added several EMBED points                                      
          Added LOC::ReturnVal, to allow a common exit point              


DiskError        FUNCTION(Cause)
StopMsg::        STRING(180)
LOC::ReturnVal   BYTE(0)

  CODE
  #EMBED('DiskErr: Setup Procedure')
  IF ~ERRORCODE() THEN DO ProcedureReturn.     #<!Return with no error
  IF ~OMITTED(1)                               #<!If a cause was given
    StopMsg:: = 'Cause: ' & Cause & LF:CR      #<!  Display it
  END                                          #<!End IF
  IF ERRORFILE()                               #<!If error involves a file
    StopMsg:: = CLIP(StopMsg::) & 'File : '  | #<!  display the file
              & ERRORFILE() & LF:CR
  END                                          #<!End IF
  StopMsg:: = CLIP(StopMsg::) & 'Error: '    | #<!Display the error code
            & ERRORCODE() & ' - '            | #<!  and the error message
            & ERROR() & LF:CR

  STOP(StopMsg::)                              #<!Stop with message
  LOC::ReturnVal = True                        #<!Return with error
  DO ProcedureReturn
ProcedureReturn ROUTINE
  #EMBED('DiskErr: Directly before return')
  RETURN(LOC::ReturnVal)

OMIT('')
ͻ
  Display a warning message using 3 Global message variables.               
ͼ
ShowWarning      PROCEDURE

SaveStyle        STRING(256)

Screen           SCREEN(9,53),PRE(SCR),CENTER,SHADOW,CUA,COLOR(112)
                   ROW(1,1)    STRING('{51}'),COLOR(116)
                   ROW(9,1)    STRING('{51}'),COLOR(116)
                               REPEAT(7)
                   ROW(2,1)      STRING(''),COLOR(116)
                   ROW(2,53)     STRING(''),COLOR(116)
                               .
                   ROW(3,5)    ENTRY(@S45),USE(GLO:Message1),INS,SKIP,COLOR(112,112,112)
                   ROW(4,5)    ENTRY(@S45),USE(GLO:Message2),INS,SKIP,COLOR(112,112,112)
                   ROW(5,5)    ENTRY(@s45),USE(GLO:Message3),INS,SKIP,COLOR(112,112,112)
                   ROW(7,24)   BUTTON('  &Ok  |'),SHADOW,USE(?Ok),COLOR(23,71,24,31,79)
                 .

  CODE
  #EMBED('ShowWarning: Setup Procedure')
  SaveStyle = STYLES()                         #<!Save current style
  GETSTYLES('')                                #<!Turn off Styles
  GLO:Message1 = CENTER(GLO:Message1,SIZE(GLO:Message1))
  GLO:Message2 = CENTER(GLO:Message2,SIZE(GLO:Message2))
  GLO:Message3 = CENTER(GLO:Message3,SIZE(GLO:Message3))
  #EMBED('ShowWarning: Before Screen Opening')
  OPEN(Screen)
  DISPLAY
  ACCEPT                                       #<!Enable keyboard and mouse
  #EMBED('ShowWarning: After Accept')
  CLEAR(GLO:MessageGroup)                      #<!Blank out message fields
  SETSTYLES(SaveStyle)                         #<!Restore user styles
  DO ProcedureReturn
ProcedureReturn ROUTINE
  #EMBED('ShowWarning: Directly before return')
  RETURN

#!
#MODULE
#!
#!Ŀ
#!                                 #MODULE                Version: 3007.000
#!ĴDescriptionĴ
#!The Module template generates the MEMBER statement, and module level data 
#!declarations for a source module of a Clarion program.  There is only one 
#!#MODULE segment in a template file chain.                                 
#!ĴCommentsĴ
#!Version   Comments                                                        
#!  ĳ
#!3007.000  Release of CDD3 version 3007 templates                          
#!
#!
                MEMBER('%Program')
OMIT('')
ͻ
   %Module - %ModuleDescription               #<!                           
ͼ
%ModuleData
#EMBED('Data Section')
#!
#CHAIN('PullDown.tpx')
