#ifndef FPEUND
/*
 *
 * Error codes generated by basic arithmetic operations (+ - * /)
 *
 */

#define FPEUND 1	/* underflow */
#define FPEOVF 2	/* overflow */
#define FPEZDV 3	/* zero divisor */
#define FPENAN 4	/* not a number (invalid operation) */
#define FPECOM 5	/* not comparable */

#define FPEFMT 6	/* floating point format error in ASCFLT */
#define FPEINT 7	/* number too large or small to convert to int. */
#define FPESQRT 8	/* tried to take the square root of negative # */
#define FPETAN 9	/* TANgent of 90 degrees attempted */

/*
 *
 * Constants
 *
 */

#define PI   3.14159265358979323846
#define PID2 1.57079632679489661923	/* PI divided by 2 */
#define PID4 0.78539816339744830962	/* PI divided by 4 */
#define I_PI 0.31830988618379067154	/* Inverse of PI */
#define I_PID2 0.63661977236758134308	/* Inverse of PID2 */

#define HUGE 1.797693e308		/* huge value */
#ifndef HUGE_VAL
#define HUGE_VAL 1.797693e308		/* huge value */
#endif
#define TINY 2.2e-308			/* tiny value */
#define LOGHUGE 709.778			/* natural log of huge value */
#define LOGTINY -708.396		/* natural log of tiny value */

/*
 *
 * External declarations
 *
 */

extern int _FPERR;	/* floating point arithmetic error */
extern int errno;	/* UNIX error code */

extern double acos (double);
extern double asin (double);
extern double atan (double);
extern double atan2 (double, double);
extern double atof (char *);
extern double ceil (double);
extern double cos (double);
extern double cot (double);
extern char *ecvt (double, int, int *, int *);
extern double except (int, char *, double, double, double);
extern double exp (double);
extern double fabs (double);
extern char *fcvt (double, int, int *, int *);
extern double floor (double);
extern double fmod (double, double);
extern double frexp (double, int *);
extern double ldexp (double, int);
extern double log (double);
extern double log10 (double);
extern double modf (double, double *);
extern int rand (void);
extern double sin (double);
extern double sqrt (double);
extern void srand (unsigned);
extern double tan (double);

/*
 *
 * Macros
 *
 */

#ifndef abs
#define abs(x) ((x)<0?-(x):(x))
#endif
#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<=(b)?(a):(b))
#endif
#endif
