/* This header file defines the ASCII character test macros
 *
 *   isalnum(c)    non-zero if c is alphabetic or a decimal digit
 *   isalpha(c)    non-zero if c is alphabetic
 *   iscntrl(c)    non-zero if c is a control character
 *   isdigit(c)    non-zero if c is a digit (0 to 9)
 *   isgraph(c)    non-zero if c is graphic (excluding blank)
 *   islower(c)    non-zero if c is lower case
 *   isprint(c)    non-zero if c is printable (including blank)
 *   ispunct(c)    non-zero if c is punctuation
 *   isspace(c)    non-zero if c is white space
 *   isupper(c)    non-zero if c is upper case
 *   isxdigit(c)   non-zero if c is a hexadecimal digit (0 to 9, A to F, a to f)
 */

#define _U 1          /* upper case flag */
#define _L 2          /* lower case flag */
#define _N 4          /* number flag */
#define _S 8          /* space flag */
#define _P 16         /* punctuation flag */
#define _C 32         /* control character flag */
#define _B 64         /* blank flag */
#define _X 128        /* hexadecimal flag */

extern char _ctype[];   /* character type table */

#define isalnum(c)	(_ctype[c]&(_U|_L|_N))
#define isalpha(c)	(_ctype[c]&(_U|_L))
#define iscntrl(c)	(_ctype[c]&_C)
#define isdigit(c)	(_ctype[c]&_N)
#define isgraph(c)	(_ctype[c]&(_P|_U|_L|_N))
#define islower(c)	(_ctype[c]&_L)
#define isprint(c)	(_ctype[c]&(_P|_U|_L|_N|_B))
#define ispunct(c)	(_ctype[c]&_P)
#define isspace(c)	(_ctype[c]&_S)
#define isupper(c)	(_ctype[c]&_U)
#define isxdigit(c)	(_ctype[c]&_X)

#define toupper(c)	(islower(c)?((c)-('a'-'A')):(c))
#define tolower(c)	(isupper(c)?((c)+('a'-'A')):(c))
