#define BUFF_SIZE 32

#ifndef NULL
#define NULL 0
#endif

/* defines for _io_data.flag1 */
#define _IORD	1		/* read flag */
#define _IOWR	2		/* write flag */
#define _IOEOF	4		/* end-of-file flag */
#define _IOERR	8		/* error flag */
#define _IONBUF	16		/* not buffered flag */

struct _io_data {
  char _buff[BUFF_SIZE];
  unsigned char _wr_cnt, _rd_cnt;
  unsigned char _flag1, _flag2;
  char _next_char, _nc_flag;	/* if nc_flag then next_char valid */
  struct _io_extension *_io_ext;
};

#define FILE struct _io_data

#define EOF (-1)

extern struct _io_data _iob[];

#define stdin ((FILE *)(&_iob[0]))	/* standard input file pointer */
#define stdout (FILE *)(&_iob[1])	/* standard output file pointer */
#define stderr (FILE *)(&_iob[2])	/* standard error file pointer */

extern int getc(FILE *);
extern int putc(char, FILE *);

extern int getchar( void );
extern int putchar(char);

extern int fputs(char *, FILE *);
extern int fgetc (FILE *);
extern char *fgets (char *, int, FILE *);
extern int fprintf (FILE *, char *,...);
extern int fputc (char, FILE *);
extern int fscanf (FILE*, char *,...);
extern char *gets (char *);
extern int printf (char *,...);
extern int puts (char *);
extern int scanf (char *,...);
extern int sprintf (char *, char *,...);
extern int sscanf (char *, char *,...);
extern int feof (FILE *);
extern int ferror (FILE *);
extern int ungetc (int, FILE *);

extern int getch(FILE *);

#ifndef abs
#define abs(x) ((x)<0?-(x):(x))
#endif
#ifndef max
/*
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<=(b)?(a):(b))
*/
#endif
