/* GEN_DEFS.H */

/* Copyright 1994 Digital Dynamics, All rights reserved. */

#ifndef _GEN_DEFS_H
#define _GEN_DEFS_H

/************************************************************************/
/* General (application independant) type definitions and macros		*/
/* tabstop: 4 (as usual)												*/
/************************************************************************/

									/* Control characters */
#define STX 	0x02				/* Start of text			^B	*/
#define ETX 	0x03				/* End of text				^C	*/
#define BS		0x08				/* Back space				^H	*/
#define TAB 	0x09				/* Horizontal tabulation	^I	*/
#define LF		0x0a				/* Line feed				^J	*/
#define FF		0x0c				/* Form feed				^L	*/
#define CR		0x0d				/* Carriage return			^M	*/
#define ESC 	0x1b				/* Escape					^[	*/
#define SP		0x20				/* Space						*/

									/* Unsigned type short-hands	*/
#define uchar	unsigned char
#define ushort  unsigned short
#define uint    unsigned int
#define ulong   unsigned long

#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
#define MALLOC  farmalloc
#define REALLOC farrealloc
#define FREE    farfree
#else
#define MALLOC  malloc
#define REALLOC realloc
#define FREE    free
#endif

#endif /* Don't add anything after this #endif statement */
