/******************************************************************
** CIPHER.C - a file encryption/decryption utility using an XOR   *
**    algorithm. To encrypt a file named PLAIN.TXT to one named   *
**    CODE.TXT using the key string ABCD, type at the DOS prompt  *
**    this command line:                                          *
**            CIPHER ABCD PLAIN.TXT CODE.TXT                      *
**    To decrypt CODE.TXT back to PLAIN.TXT, you must use the same*
**    code string.   Issue this command at the DOS prompt:        *
**            CIPHER ABCD  CODE.TXT PLAIN.TXT                     *
**    Program author is Mark R. Parker.                           *
******************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

void GiveUsage(void), ErrorMsg1(void), ErrorMsg2(void);
FILE * fpin, *fpout;

void main(int argc, char *argv[])
{
        int ch,                    /* Character to encrypt   */
            len;                   /* Length of key-string   */
        long i = 0;                /* Loop control variable  */

        switch(argc)  {
           case 1:
           case 2:
           case 3: GiveUsage();  // Too few command-line arguments
                   exit(1);
                   break;
                                   // Open input file to read from
           case 4: fpin = fopen( argv[2], "rb");
                                   // Open output file to write to
                   fpout = fopen( argv[3], "wb");
                   len = strlen( argv[1]);
                   if (fpin == NULL)  {
                       ErrorMsg1();     //Couldn't open input file
                       exit(2);
                       }
                   if (fpout == NULL)  {
                       ErrorMsg2();     //Couldn't open output file
                       exit(3);
                       }

     /* Everything was OK.  Each pass, read a character from the *
     ** input file, encrypt it, then write it to the output file.*/

                   while (  (ch = getc(fpin)) != EOF )  {
                        ch ^= argv[1][i++ % len];
                        putc(ch, fpout);
                        }
                   break;
        }
        fclose(fpin);
        fclose(fpout);
}


void GiveUsage(void)
{
printf("Usage: cipher <key> <input-file> <output-file>\n");
printf("<key> is the coding/decoding character string, \n");
printf("<input-file> is the name of the file to be encrypted,\n");
printf("<output-file> is the name of the file to be decrypted.\n");
printf("First time encrypts, second time decrypts.");
}


void ErrorMsg1(void)
{
   printf("Input file does not exist!\n");
   printf("You must provide the name of an existing file!\n");
   printf("Please try again.\n");
}

void ErrorMsg2(void)
{
   printf("Output file already exists!\n");
   printf("Delete or rename the output file");
   printf(" and try again.\n");
}
