program MaxExec;

uses
  WinTypes, WinProcs, OWindows;

type
  PMaxExecApp = ^TMaxExecApp;
  TMaxExecApp = object( TApplication )
    constructor Init( AName : PChar );
    procedure InitMainWindow; virtual;
  end;


  constructor TMaxExecApp.Init( AName : PChar );
  var
    RetCode : Word;
    S, TmpStr : String;
  begin
    inherited Init( AName );
          { CmdLine is a system variable which is automatically }
                   { set to the current command line parameters }
    if CmdLine[ 0 ] <> #0  then
    begin           { If a program is specified, try to execute }
      RetCode := WinExec( CmdLine, sw_ShowMaximized );
      if RetCode < 32 then
      begin
        S := 'Program could not be executed.'+#13+'Return code = ';
        Str( RetCode, TmpStr );
        S := S + TmpStr + #0;   { Make sure string ends with #0 }
            { Using a String variable where a PChar is expected }
        MessageBox( 0, @S[ 1 ], 'MaxExec Error',
                    mb_Ok or mb_IconStop );
      end;
    end
    else
      MessageBox( 0, 'No program specified.', 'MaxExec Error',
                  mb_Ok or mb_IconStop );
  end; {= TMaxExecApp.Init =}


  procedure TMaxExecApp.InitMainWindow;
  begin
    { Overridden so that a main window is not displayed }
  end;


var
  MaxApp : TMaxExecApp;

begin {=== MAIN ===}
  MaxApp.Init( 'MaximizeApp' );
{ MaxApp.Run;  No Need to execute Run method b/c nothing to run }
  MaxApp.Done;
end.