{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S+,V-,X+}
{$IFDEF MSDOS}
{$M 1024,0,655360}
{$ELSE}
{$M 8192,0}
{$ENDIF}
{
  Free 3.2
  Borland Pascal (Objects) 7.0.
  Copr. (c) 11-21-1993 DwarFools & Consultancy drs. Robert E. Swart
                       P.O. box 799
                       5702 NP  Helmond
                       The Netherlands
  Code size: 4880  5351  8523 Bytes
  Data size:  780   858  1252 Bytes
  .EXE size: 2852 10256 11536 Bytes
  ----------------------------------------------------------------
  This program shows the amount of free harddisk and RAM space.
}
{$IFNDEF MSDOS}
  {$IFDEF WINDOWS}
  Uses WinProcs,
       WinCrt;
  {$ELSE DPMI}
  Uses WinApi;
  {$ENDIF}

  Type
    LongRec = record
                Selector,Segment: Word
              end {LongRec};

    TDPMIRegisters = record
                       EDI,ESI,EBP,Reserved,EBX,EDX,ECX,EAX: LongInt;
                       Flags,ES,DS,FS,GS,IP,CS,SP,SS: Word
                     end {TDPMIRegisters};

    function XGlobalDosAlloc(Size: LongInt; var P: PChar): Word;
    var Long: LongInt;
    begin
      Long := GlobalDosAlloc(Size);
      P := Ptr(LongRec(Long).Selector, 0);
      XGlobalDosAlloc := LongRec(Long).Segment { real mode segment }
    end {XGlobalDosAlloc};

    function SimulateRealModeInt(IntNo: Word;
                             var Regs: TDPMIRegisters): Word; Assembler;
    ASM
          mov   BX,IntNo { real mode interrupt nr in BL    }
          xor   CX,CX    { no copying bytes from the stack }
          les   DI,Regs  { ES:DI -> real TDPMIRegisters    }
          mov   AX,$300  { function $300 = real mode int   }
          int   $31      { call DPMI int $31 }
          jc    @Exit
          xor   AX,AX
     @Exit:
    end {SimulateRealModeInt};

    procedure TrueName(var FileName, TrueFileName: String);
    var Regs: TDPMIRegisters;
        Name: PChar;
        Len: Byte absolute FileName;
        LenT: Byte absolute TrueFileName;
        i: Integer;
    begin
      FillChar(Regs,SizeOf(Regs),#0);
      Regs.DS := XGlobalDosAlloc(256,Name);
      Move(FileName[1],Name^,Len);
      Name[Len] := #0;
      Regs.ES := Regs.DS;
      Regs.EAX := $6000; { TrueName }
      SimulateRealModeInt($21,Regs);
      LenT := 0;
      repeat
        TrueFileName[LenT+1] := Name[LenT];
        Inc(LenT);
      until (LenT = 255) or (Name[LenT] = #0);
      GlobalDosFree(LongRec(Name).Selector)
    end {TrueName};
{$ENDIF}
Const TotSize: LongInt = 0;
      TotFree: LongInt = 0;

Type
  DirStr = String[5];
  MapStr = String[80];

Const
  Disk: DirStr = 'C:\)'#0;

Type TDrive = (Floppy, Hard, None);

var MapName: MapStr;
    MapLen: Byte absolute MapName;
    DiskClusters,FreeClusters: Word;
    Size,Free: LongInt;


    function Drive(ID: Char): TDrive; Assembler;
    ASM
          mov   AX,$4408
          mov   BL,ID
          sub   BL,'A'-1
        {$IFDEF MSDOS}
          int   $21
        {$ELSE}
          call  DOS3Call
        {$ENDIF}
          cmp   AX,Hard
          jbe   @End
          mov   AX,None
    @End:
    end {Drive};


  {$IFDEF MSDOS}
    procedure TrueName(var FileName, TrueFileName: String); Assembler;
    ASM
          push  DS
          cld
          lds   SI,FileName
          inc   SI { FileName = TP String }
          les   DI,TrueFileName
          inc   DI { TrueFileName = TP String }
          mov   AX,$6000
          int   $21
          pop   DS
    end {TrueName};
  {$ENDIF}

    function StrComp(var Str1, Str2: String): Integer; Assembler;
    ASM
          push  DS
          cld
          lds   SI,Str2
          xor   AX,AX
          cwd
          lodsb
          mov   CX,AX
          dec   CX
          les   DI,Str1
          inc   DI
          repe  CMPSB
          mov   AL,DS:[SI-1]
          mov   DL,ES:[DI-1]
          sub   AX,DX
          pop   DS
    end {StrComp};

    function BytesPerCluster(Drive: Char): Longint; Assembler;
    ASM
          mov   DL,Drive
          sub   DL,'A'-1
          mov   AH,$36
        {$IFDEF MSDOS}
          int   $21
        {$ELSE}
          call  DOS3Call
        {$ENDIF}
          {     AX = Sectors/Cluster
                CX = Bytes/Sector
                AX * CX = Bytes/Cluster
          }
          mov   DiskClusters,DX { Size }
          mov   FreeClusters,BX { Free }
          mul   CX
    end {BytesPerCluster};

begin
  writeln('Free 3.2 (c) 1993 DwarFools & Consultancy' +
                          ', by drs. Robert E. Swart.'#13#10);

  for Disk[1] := 'A' to 'Z' do
  begin
    case Drive(Disk[1]) of
      Floppy: writeln('Disk ',Disk[1],':\ is a floppy drive.');
        Hard: begin
                Size := BytesPerCluster(Disk[1]) {DiskSize(i)};
                Free := Size * FreeClusters;
                Size := Size * DiskClusters;
                write('Disk ',Disk[1],':\',Size:11);
                MapName := Disk;
                TrueName(Disk,MapName);
              {$IFDEF MSDOS}
                MapLen := 1;
                while MapName[MapLen] <> #0 do Inc(MapLen);
              {$ENDIF}
                if StrComp(Disk,MapName) = 0 then
                begin
                  Inc(TotSize,Size);
                  writeln(Free:10,' bytes free.');
                  Inc(TotFree,Free)
                end
                else
                  writeln(Free:10,' bytes free (maps to ',MapName)
              end
    end {case}
  end;
  writeln('============= +':21);
  writeln('Totaal: ',TotSize:11,' bytes on harddisk.');
  writeln(TotFree:19,' bytes free.');
  writeln;
  writeln(MemAvail:15,' RAM bytes free.');
  {$IFDEF WINDOWS}
  readln;
  DoneWinCrt { Destroy the Window after readln }
  {$ENDIF}
end.
