/* LISTCMPX.C  (c)1994, Anthony Hotchkiss */

#include <stdio.h>
#include <string.h>
#include "adslib.h"
#include "adxlib.h"
#define SEQEND "SEQEND"
/* Complex entity listing example */

int listcmpx (void)
{
   struct resbuf *elist;
   ads_name ename, en1;
   ads_point pt;
   char fn[132];
   FILE *f1;

   ads_getstring(0, "\nEnter the txt file name: ", fn);
   strcat(fn, ".txt");
   if (ads_entsel("\nSelect block reference: ", ename, pt) != RTNORM)
      {
         ads_alert("No entity selected...");
         return RTERROR;
      }
   ads_redraw(ename, 3);
   elist = ads_entget(ename);
   f1 = fopen(fn, "w");
   adx_fprint_dxf(f1, elist);   
   ads_name_set(ename, en1);
  /*  while (adx_assoc(-2, elist) == 0)  */
   while (strcmp (adx_assoc(0, elist)->resval.rstring, SEQEND))
      {
         if (ads_entnext(ename, ename) != RTNORM)
            {
               ads_alert("entnext failed...");
               fclose(f1);
               return RTERROR;
            }
         if (elist != NULL) 
            ads_relrb(elist);
         elist = ads_entget(ename);
         adx_fprint_dxf(f1, elist);
      }
   if (elist != NULL) 
      ads_relrb(elist);
   fclose(f1);
   if (ads_redraw(en1, 1) != RTNORM)
      return RTERROR;
   ads_retvoid();
} /* listcmpx */
/*FUNCLOAD -- Define the external functions */
void funcload(void)
{
   ads_defun("C:LISTCMPX", 1);
}

/*DOFUN -- Execute the external functions */
void dofun()
{
   listcmpx();
}
void main(int argc, char **argv)
{
    ads_init(argc, argv);    /* Open communication with AutoLISP */
    for ( ;; ) 
      {                      /* Request/Result loop */
        switch(ads_link(RSRSLT)) 
        {
        case RQXLOAD:         /* Load & define functions */
            funcload();
            break;
        case RQSUBR:         /* Handle external function requests */
            dofun();
            break;
        }
    }
}/* main */


