
























      
                            Manu Roibal Prieto
                        Sagastagoitia, 13 2 B izq
                      Barakaldo 48903. Bizkaia. Spain.























Printout of `FAST.GT  1.50  Reference'
Printed by the Norton Guides Printer v2.0 (NGP.EXE).


                                 - Page 1 -
Norton Guide: `FAST.GT  1.50  Reference'


Menu List: FAST.GT, Functions



    DestScreen()

         Destroys a screen file generated by savescreen()

    Syntax:

         DestScreen( cFile ) -> nError

    Description:

         Deletes a screen file generated by SaveScreen(). These files can be
         deleted too by RestScreen().

    Return:

         A numeric value indicating if an error is found

    Example:

         cScr := SaveScreen( 0, 0, MaxRow(), MaxCol() )
         // Now draws a box
         RestScreen( 0, 0, MaxRow(), MaxCol(), cScr, .F. )
         DestScreen( cPan )

See Also: "RestScreen()" 


    gtClose()

         Deinitialize FAST.GT system

    Syntax:

         gtClose() -> Nil

    Description:

         gtClose() deinstalls FAST.GT graphic system and restores the
         system parameters.

    Return:

         Nothing.

    Example:

         gtClose()


    gtInit()


                                 - Page 2 -
Norton Guide: `FAST.GT  1.50  Reference'


         Initialize FAST.GT system

    Syntax:

         gtInit( nMode ) -> Nil

         nMode : A numerical value indicating the graphics mode to use.
                 Default value is 0.

                    0  ->  640x400 256 colors * SVGA 256kb required
                    1  ->  640x480 256 colors * SVGA 512kb required
                    2  ->  800x600 256 colors * SVGA 1Mb   required
                    3  -> 1024x768 256 colors * "    "     "
                    4  ->  640x480  16 colors * VGA  standard mode

    Description:

         gtInit() installs FAST.GT graphic system and changes the system
         parameters.

    Return:

         Nothing.

    Example:

         gtInit()


    IsVesa()

         Detects if the graphic system is VESA compatible

    Syntax:

         IsVesa() -> lVesa

    Description:

         It returns a logic indicating if the system is compatible with the
         standard placed by the VESA committee. If your graphic card is not
         VESA compatible contact your distributor and probably there will
         be a driver that allows you a software emulation of VESA.

    Return:

         A logic indicating if it is compatible

    Example:

         If IsVesa()
           ? VesaVer()
         EndIf

See Also: "VesaOEM()" "VesaVer()" 

                                 - Page 3 -
Norton Guide: `FAST.GT  1.50  Reference'




    RestScreen()

         Restores a screen file generated by savescreen()

    Syntax:

         RestScreen( nY1, nX1, nY2, nX2, cFile, lPurge ) -> Nil

         nY1, nX1, nY2, nX2 : Coordinates
         cFile              : The screen file generated by savescreen
         lPurge             : A logic value indicating if you want delete
                              the file. Default value is .T.

    Description:

         Restores a screen file generated by SaveScreen().

    Return:

         Nothing.

    Example:

         cScr := SaveScreen( 0, 0, MaxRow(), MaxCol() )
         // Now draws a box
         RestScreen( 0, 0, MaxRow(), MaxCol(), cScr )

See Also: "DestScreen()" 


    VesaBox()

         Draws a box

    Syntax:

         VesaBox ( nY1, nX1, nY2, nX2, nColor ) -> Nil

         nY1, nX1, nY2, nX2 : Graphic coordinates.
         nColor             : The color of the frame.

    Description:

         Draws a box with graphic coordinates. To fill it, you can use
         VesaArea().

    Return:

         Nothing.

    Example:

         VesaBox( 240, 100, 260, 120, 4 )

                                 - Page 4 -
Norton Guide: `FAST.GT  1.50  Reference'




    VesaBIOS()

         Sets/Gets if Direct Write BIOS is supported

    Syntax:

         VesaBIOS( [ lSupport ] ) -> lActualSupport

         lSupport : a logical value to forze the internal flag of Direct
                    Write BIOS support.

    Description:

         Sets/Gets the internal flag of Direct Write BIOS support.
         Some VESA drivers don't support calls to int10h in modes with 256
         colors. Anothers, returns a value indicating that Direct Write is
         supported but this is not true.
         If you have problems with FAST.GT you must force Direct Write BIOS
         Support to <No> calling to VesaBIOS( .F. ).

    Return:

         The actual internal flag.

    Example:

         ? VesaBIOS()


    VesaCurSpeed()

         Set/Gets the speed of cursor emulation

    Syntax:

         VesaCurSpeed ( [ nSpeed ] ) -> nOldSpeed

    Description:

         Gets an optionally sets the speed of cursor emulation in graphic
         mode.
         The Cursor Emulation System has been created with the Clipper
         Event System.
         Default value to nSpeed is 2.

    Return:

         Actual cursor speed.

    Example:

         ? VesaCurSpeed( 3 )


                                 - Page 5 -
Norton Guide: `FAST.GT  1.50  Reference'



    VesaGetDAC()

         Gets a block of DAC registers

    Syntax:

         VesaGetDAC( nInic, nColors ) -> cPalette

         nInic   : a numeric value with the first color to get
         nColors : a numeric value with the number of colors to get

    Description:

         Gets a block of DAC registers. The first color is 0 and the
         maximun number of colors is 256.

    Return:

         A string value with the system palette.

    Example:

         cPalette := VesaGetDAC( 0, 256 )
         Len( cPalette )                      // 256 *  3  = 768
                                              //       RGB

See Also: "VesaSetDAC()" 


    VesaGetPixel()

         Informs of the colour of a point in graphic mode

    Syntax:

         VesaGetPixel( nRow, nCol ) -> nColor

         nRow    : Row of the point to verify
         nCol    : Column of the point to verify

    Description:

         It informs of the colour of a point in graphic mode in the
         specified coordinates.

    Return:

         Nothing.

    Example:

         ? VesaGetPixel( 330, 240 )

See Also: "VesaSetPixel()" 

                                 - Page 6 -
Norton Guide: `FAST.GT  1.50  Reference'




    VesaLoadFont()

         Loads a user font

    Syntax:

         VesaLoadFont( cFile ) -> Nil

    Description:

         With FAST.GT you can use 3 fonts, 2 standard fonts and an user font.
         You can select the active font with VesaSetFont().

    Return:

         Nothing.

    Example:

         VesaLoadFont( "Myfont.fon" )


    VesaLine()

         Draws a line

    Syntax:

         VesaLine ( nY1, nX1, nY2, nX2, nColor ) -> Nil

         nY1, nX1, nY2, nX2 : Graphic coordinates.
         nColor             : The color of the line.

    Description:

         Draws a line with graphic coordinates. The algoritm can separe
         between horizontal, vertical or another lines.

    Return:

         Nothing.

    Example:

         VesaLine( 240, 100, 260, 120, 4 )


    VesaOEM()

         Returns the OEM of the VESA driver

    Syntax:


                                 - Page 7 -
Norton Guide: `FAST.GT  1.50  Reference'


         VesaOEM() -> cOEM

    Description:

         It returns a string with the OEM or builder of the VESA driver.

    Return:

         A string with the name of the builder.

    Example:

         ? VesaOEM()

See Also: "IsVesa()" "VesaVer()" 


    VesaSetArea()

         Fills a rectangular area

    Syntax:

         VesaSetArea ( nY1, nX1, nY2, nX2, nColor ) -> Nil

         nY1, nX1, nY2, nX2 : Graphic coordinates.
         nColor             : The color to fill.

    Description:

         Fill a rectangular area with graphic coordinates.

    Return:

         Nothing.

    Example:

         VesaSetArea( 240, 100, 260, 120, 4 )


    VesaSetDAC()

         Sets a block of DAC registers

    Syntax:

         VesaSetDAC( cPalette, nInic, nColors ) -> Nil

         cPalette : a string character with the palette to set
         nInic    : a numeric value with the first color to set
         nColors  : a numeric value with the number of colors to set

    Description:


                                 - Page 8 -
Norton Guide: `FAST.GT  1.50  Reference'


         Sets a block of DAC registers. The first color is 0 and the
         maximun number of colors is 256.
         The lenght of string must be equal to nColors * 3.

    Return:

         Nothing.

    Example:

         cPalete := Replicate( Chr( 0 ), 768 )
         VesaGetDAC( cPalette, 0, 256 )     // oh no! the world is black. :-)

See Also: "VesaGetDAC()" 


    VesaSetFont()

         Sets a specified font which default font

    Syntax:

         VesaSetFont( nFont ) -> nDefaultFont

         nFont : Font to active which default font

    Description:

         With FAST.GT you can use 3 fonts, 2 standard fonts and an user font.
         Font numbers are defined in fastgt.ch.

    Return:

         Actual default font.

    Example:

         #include "fastgt.ch"

         VesaLoadFont( "Myfont.fon" )
         VesaSetFont( FONT_USER )
         ? "Hello"
         VesaSetFont( FONT_BIG )
         ? "Hello"
         VesaSetFont( FONT_SMALL )
         ? "Hello"


    VesaSetPixel()

         Draws a point in graphic mode

    Syntax:

         VesaSetPixel( nRow, nCol, nColor ) -> Nil

                                 - Page 9 -
Norton Guide: `FAST.GT  1.50  Reference'



         nRow    : The row where to place the point.
         nCol    : The column where to place the point.
         nColor  : The colour. It must be a numeric value.

    Description:

         It draws a point on the screen at the coordinates and colours
         specified.

    Return:

         Nothing.

    Example:

         VesaSetPixel ( 330, 240, 2 )

See Also: "VesaGetPixel()" 


    VesaShowIcon()

         Shows a Fast Icon

    Syntax:

         VesaShowIcon( nY, nX, cIcon ) -> Nil

         nY    : Coordinate Y
         nX    : Coordinate X
         cIcon : A bitmap with an icon (8 bits / pixel)

    Description:

         Shows a Fast Icon. cIcon is a var with 1024 bytes (32x32) where
         a byte is equivalent to a pixel.

    Return:

         Nothing.

    Example:

         VesaShowIcon( 120, 100, MemoRead( "fast.fic" ) )


    VesaStart()

         Sets the initial position of the video buffer

    Syntax:

         VesaStart( nY, nX ) -> Nil


                                 - Page 10 -
Norton Guide: `FAST.GT  1.50  Reference'


         nY : Coordinate Y
         nX : Coordinate X

    Description:

         It fixes the relative position given as the start position of the
         video memory.
         For example, if we call to Origin( 5, 6 ) we are indicating that
         the new position in Y is shifted 5 pixels and in X is shifted 6
         pixels. With all this we will descend the image 5 lines and move
         it right 6 columns.
         These movements are extraordinarily fast.

    Return:

         Nothing.

    Example:

         For nInd := 0 To 200 Step 2
           VesaStart( nInd, 0 )
         Next


    VesaVer()

         Returns the VESA driver version

    Syntax:

         VesaVer() -> cVersion

    Description:

         It returns a 5 character string with the VESA driver version, no
         matter if the driver is soft made or it is included in the video
         card.

    Return:

         A string like xx.xx with the driver version.

    Example:

         If IsVesa()
           ? VesaVer()
         EndIf

See Also: "IsVesa()" "VesaOEM()" 


    VesaWriteAt()

         Writes a string on the screen


                                 - Page 11 -
Norton Guide: `FAST.GT  1.50  Reference'


    Syntax:

         VesaWriteAt( nRow, nCol, cText, nFore, nBack ;
                      [, nFont] [, Space] ) -> Nil

         nRow, nCol : Graphic coordinates
         cText      : The text to display
         nFore      : Foreground color
         nBack      : Background color
         nFont      : Optional font. If not specified default value is the
                      value returned by VesaSetFont()
         nSpace     : Optional space between the letters. Default space is
                      8 pixels per letter.

    Description:

         Writes a string on the screen with graphic coordinates.

    Return:

         Nothing.

    Example:

         VesaWriteAt( 240, 100, "Hello Mr. Chip", 1, 7, FONT_SMALL, 12 )


    MouseArea()

         Determines if mouse pointer is on a specified area

    Syntax:

         MouseArea( nY1, nX1, nY2, nX2 ) -> lArea

         nY1, nX1, nY2, nX2 : Coordinates

    Description:

         Determines if a mouse pointer is on a specified area returning
         a logic value.

    Return:

         A logic value indicating if mouse pointer is on the specified area.

    Example:

         lArea := MouseArea( 10, 10, 200, 150 )


    MouseButtons()

         Returns the number of buttons


                                 - Page 12 -
Norton Guide: `FAST.GT  1.50  Reference'


    Syntax:

         MouseButtons() -> nButtons

    Description:

         Returns the number of buttons getting the driver's information.

    Return:

         A numeric value with the number of buttons.

    Example:

         nButtons := MouseButtons()


    MouseCursor()

         Hides/Shows the mouse pointer

    Syntax:

         MouseCursor( [ lShow ] ) -> lActualShow

         lShow : a logic value indicating if you want show or hide the
                 mouse pointer

    Description:

         Hides/Shows the mouse pointer and returns a logic value indicating
         the actual state of the mouse pointer.

    Return:

         The state of the mouse pointer.

    Example:

         #define MOUSE_ON  .T.
         #define MOUSE_OFF .F.

         MouseCursor( MOUSE_OFF )       // Hides mouse pointer


    MouseInstall()

         Determines if a mouse driver if loaded

    Syntax:

         MouseInstall() -> lMouseInstall

    Description:


                                 - Page 13 -
Norton Guide: `FAST.GT  1.50  Reference'


         Determines if a mouse driver is loaded and ready to work with
         FAST.GT.

    Return:

         A logic value indicating if a mouse driver is loaded.

    Example:

         if MouseInstall()
           @ 10, 10 Say "Mouse Ok"
         endif


    MousePointer()

         Changes the mouse pointer

    Syntax:

         MousePointer( nMousePointer ) -> Nil

         nMousePointer : a numeric value with the new pointer for the
                         the mouse. Available values are:

                                #define  MOUSE_POINT   0
                                #define  MOUSE_CLOCK   1

    Description:

         Sets the mouse pointer like as a pointer or a clock.

    Return:

         Nothing.

    Example:

         MousePoint( MOUSE_CLOCK )    // now, mouse pointer is a clock!!!


    MouseX()

         Sets/Gets mouse column

    Syntax:

         MouseX( [ nPos ] ) -> nOldPos

         nPos : a numeric value with the new column for the mouse pointer

    Description:

         Sets/Gets the mouse pointer column.


                                 - Page 14 -
Norton Guide: `FAST.GT  1.50  Reference'


    Return:

         The actual column of the mouse pointer.

    Example:

         ? MouseX()

See Also: "MouseY()" 


    MouseY()

         Sets/Gets mouse row

    Syntax:

         MouseY( [ nPos ] ) -> nOldPos

         nPos : a numeric value with the new row for the mouse pointer

    Description:

         Sets/Gets the mouse pointer row.

    Return:

         The actual row of the mouse pointer.

    Example:

         ? MouseY()

See Also: "MouseX()" 





















                                 - Page 15 -
Norton Guide: `FAST.GT  1.50  Reference'


Menu Choice: Credits, What's FAST.GT



    FAST.GT is a new Graphic Terminal for Clipper created by Manu Roibal.


    Using FAST.GT you can build Graphic Aplications with Clipper 5.x and
 addapt your old text mode aplication to graphic mode in about 5 minutes.


    You just need a few changes in your programs and they will run in
 graphic mode with all these advantages.
 One instruction at the beginning of the program and another one at
 the end is all you need. You don't need to modify the rest any other
 source code!!!


    A program generated with FAST.GT would be:

        Function Main()

        Local hInit := gtInit( nVideoMode )

            < ... your code ... >

            gtClose( hInit )

        Return( Nil )


    VERY IMPORTANT

    It's probably to receive a linker warning indicating that there are
 duplicate modules. There is no problem, that's ok.


 With this, all standard functions of Clipper, aChoice, Get, Say, Box,
 Clear, ?, Tbrowse and more, write in graphic mode ( VGA and SVGA ).


    You must see FAST.GT in action!!!













                                 - Page 16 -
Norton Guide: `FAST.GT  1.50  Reference'


Menu Choice: Credits, Programming reference



    FAST.GT is a C developed library including ASM calls for critical video
 access.

    All the memory request have been developed under the model Clipper
 imposes in its API.

    The library is using VESA because it's the world standard in video
 access to SVGA. For these reasons we assure that all the Clipper programs
 generated with FAST.GT will work fine in all machines with a SVGA card and
 driver VESA, soft or hard.

    During FAST.GT beta test has been found some problems with a few old
 SVGA cards that included VESA driver in ROM. Such ROM drivers contain some
 bugs. In these cases we recomend using a SOFT driver as UNIVESA.

 UNIVESA Universal SuperVGA BIOS Extension Version 1.2 Release 3.1
 Copyright (C) 1993 Kendall Bennett


































                                 - Page 17 -
Norton Guide: `FAST.GT  1.50  Reference'


Menu Choice: Credits, About the mouse



    FAST.GT includes a powerfull mouse system that working in background
 making the process invisible for users.

    With this system, the mouse presses can be dealt with normal keyboard
 presses. This way, when the left button is pressed down the Standard
 Clipper function InKey() returns the value K_MOUSE_LEFT ( 451 ). The right
 button returns K_MOUSE_RIGHT ( 452 ) and the central button returns
 K_MOUSE_CENTRE ( 454 ).

    Apart from that, a mouse event is generated when you release one of
 mouse buttons. In this case InKey() returns K_MOUSE_RELEASE ( 458 ).

    By means of this system the user can write expressions like :

        - if Inkey( 0 ) == K_MOUSE_LEFT
            ...

        - SetKey( K_MOUSE_RIGHT, { || Action } )

































                                 - Page 18 -
Norton Guide: `FAST.GT  1.50  Reference'


Menu Choice: Credits, About Blinker 3


  About Protected Mode

    Now FAST.GT is compatible with the all more popular linkers.
 Blinker 1.x, Blinker 2.x, Blinker 3 (real, protected & dual mode),
 CA-ExoSpace and rtLink x.x are supported.

 You only must change the linker module!!!


    To link with Blinker 3 (real, protected & dual mode) you must include the
 file apibli.lib in your script file or command line

    BLINKER FI my_prog, GT, LIB FastGT, apibli

    or

    BLINKER FI my_prog, GT LIB FastGT, apibli SEA blxclp52 BLI EXE EXT


    To link with Blinker 1.x, Blinker 2.x, rtLink x.x or WarpLink x.x you
 must include the file apistd.lib in your script file or command line

    BLINKER FI my_prog, GT LIB FastGT, apistd

    or

    RTLINK FI my_prog, GT LIB FastGT, apistd


    To link with CA-ExoSpace you must write the following script file
  or command line

    EXOSPACE FI my_prog, GT LIB FastGT EXO PAC int10, Mouse



















                                 - Page 19 -
Norton Guide: `FAST.GT  1.50  Reference'


Menu Choice: Credits, Copyright


    Copyright

              Ŀ
                                                         
                             FAST.GT 1.50                
                                                         
                        (C) 1992-94 Manu Roibal          
                                                         
              


    All code included in FAST.GT and the documentation, example programs
 and this Norton Guide is a property of Manu Roibal.

    It is fully prohibited its shell or distribution by either physics or
 juridic persons without the permission of the author.

    It is fully prohibited too using FAST.GT for building Commercial
 Aplications without a previous registering.


    FAST.GT, (C) 1992-94 Manu Roibal
    FastWare solutions.

    All trademarks and registered trademarks referenced in this file are the
 property of their respective owners.


























                                 - Page 20 -
Norton Guide: `FAST.GT  1.50  Reference'


Menu Choice: Credits, FAST.* Distributors




     FAST.* DISTRIBUTORS


      Exclusive distributor North, South & Central America 

     Zac Catalog
     106 Access Road
     Norwood, MA 02062
     USA
     Phone 1-800-254-7737
     FAX   1-617-551-0857


      Finland 

     ATK-Antti Oy
     Lars J W Holm
     Pohjoistullikatu 12
     23500 Nystad
     FINLAND
     Phone +358 22 8415066
     FAX   +358 22 8415067
     BBS   +358 22 8418882


      Nederland 

     Micro Consult Nederland
     Miguel Oliveira
     Rhijngeesterstraalweg 78
     2343 BX Oegstgeest
     NEDERLAND
     Phone +31 71 170401
     FAX   +31 71 156154
     BBS   +31 71 157618


      Spain 

     Manu Roibal Prieto
     Sagastagoitia 13 2 B izda
     Barakaldo 48903 Bizkaia
     SPAIN
     Phone +34 4 4992660
     FAX   +34 4 4605666
     BBS   +34 4 4605666




                                 - Page 21 -
Norton Guide: `FAST.GT  1.50  Reference'



                                I N D E X
                                ---------



FAST.GT
    Functions  ....................................................    2


Credits
    What's FAST.GT  ...............................................   16
    Programming reference  ........................................   17
    About the mouse  ..............................................   18
    About Blinker 3  ..............................................   19
    Copyright  ....................................................   20
    FAST.* Distributors  ..........................................   21






































                                 - Page 22 -
