		-----------------------------------
		-- roll dice and see a histogram --
		-----------------------------------

include get.e

constant KEYBOARD = 0,
	 SCREEN = 1

function get_number()
-- input a number
    sequence input

    input = get(KEYBOARD) 
    if input[1] = GET_SUCCESS then
	return input[2]
    else
	abort(1)
    end if
end function

function sum(sequence x)
-- add up a sequence of numbers
    integer total

    total = 0
    for i = 1 to length(x) do
	total = total + x[i]
    end for
    return total
end function

procedure dice()
-- main procedure
    integer ndice, nrolls, score, lines
    sequence count, roll

    puts(SCREEN, "number of dice? ")  
    ndice = get_number()

    puts(SCREEN, "\nnumber of rolls? ")
    nrolls = get_number()

    count = repeat(0, 6 * ndice)

    -- roll the dice
    for r = 1 to nrolls do
	roll = rand(repeat(6, ndice))
	score = sum(roll) 
	count[score] = count[score] + 1 
    end for

    -- display the results
    printf(1, "\n\n\t%d dice, %d rolls\n", {ndice, nrolls})
    lines = 1
    for i = ndice to 6 * ndice do
	printf(SCREEN, "%2d: ", i)  
	puts(SCREEN, repeat('*', count[i]) & '\n')
	if remainder(lines, 24) = 0 then
	    while get_key() = -1 do
	    end while
	end if
	lines = lines + 1
    end for
end procedure

dice()

