		-- Example of calling a machine code 
		-- routine from Euphoria

include machine.e
include graphics.e

sequence vc
vc = video_config()

atom screen
if vc[VC_COLOR] then
    screen = #B8000 -- color
else
    screen = #B0000 -- mono
end if

sequence string_copy_code, string
atom code_space, string_space, screen_location

clear_screen()

string = {'E', 9, 'u', 10, 'p', 11, 'h', 12, 'o', 13, 'r', 14,
	  'i', 15, 'a', 2, '!', 134}

string_space = allocate(length(string)+1)
screen_location = screen+11*80*2+64 -- 10 lines down

		-- String Copy machine code:
		-- (will move at least one char)
string_copy_code =
      {#50,			       -- push eax
       #53,			       -- push ebx
       #52,			       -- push edx
       #B8} &			       -- mov eax, 
       int_to_bytes(string_space) &    -- string address (source)
      {#BA} &			       -- mov edx, 
       int_to_bytes(screen_location) & -- screen address (destination)
      {#8A, #18,		       -- L1: mov bl, [eax]
       #40,			       -- inc eax
       #88, #1A,		       -- mov [edx],bl
       #83, #C2, #01,		       -- add edx, #1
       #80, #38, #00,		       -- cmp byte ptr [eax], #00
       #75, #F3, 		       -- jne L1
       #5A, 			       -- pop edx	
       #5B,			       -- pop ebx
       #58,			       -- pop eax
       #C3}			       -- ret

-- poke in the machine code:
code_space = allocate(length(string_copy_code))
for i = 1 to length(string_copy_code) do
    poke(code_space+i-1, string_copy_code[i])
end for

-- poke in the string:
for i = 1 to length(string) do
    poke(string_space+i-1, string[i])
end for
poke(string_space+length(string), 0) -- machine code looks for 0 terminator

puts(1, "\n  calling machine code routine ... ")

-- call the machine code:
call(code_space) -- copies string to screen

-- these would be freed anyway when the program ends:
free(code_space)
free(string_space)

puts(1, "success\n")


