DECLARE SUB sort ()

DEFINT A-Z

CONST BATCH = 100
CONST BENCHTIME = 15
CONST NITEMS = 50
DIM SHARED xlist(NITEMS), slist(NITEMS)

DATA 9, 34, 14, 18, 33, 46, 11, 13, 7, 26, 22, 10, 36, 40, 2, 28, 32, 1
DATA 23, 31, 43, 5, 24, 42, 45, 50, 16, 3, 47, 39, 21, 49, 41, 6, 19, 30
DATA 20, 35, 44, 38, 25, 15, 27, 17, 8, 4, 29, 37, 48, 12

FOR i = 1 TO NITEMS
    READ xlist(i)
NEXT i

PRINT "shell sort benchmark ..."

cycles& = 0
t# = TIMER
WHILE TIMER < t# + BENCHTIME
    FOR b = 1 TO BATCH
        REM must preserve the original array
        FOR x = 1 TO NITEMS
	    slist(x) = xlist(x)
        NEXT x
        sort
    NEXT b
    cycles& = cycles& + BATCH
WEND
t# = TIMER - t#
PRINT USING "######.## sorts per second"; cycles& / t#

FOR i = 1 TO NITEMS
    PRINT slist(i),
NEXT i

SUB sort
REM put slist into ascending order
REM using a shell sort
    
    gap = INT(NITEMS / 4) + 1
    DO
	FOR i = gap + 1 TO NITEMS
	    tempi = slist(i)
	    j = i - gap
	    DO
		tempj = slist(j)
		IF tempi >= tempj THEN
		    j = j + gap
		    EXIT DO
		END IF
		slist(j + gap) = tempj
		IF j <= gap THEN
		    EXIT DO
		END IF
		j = j - gap
	    LOOP
	    slist(j) = tempi
	NEXT i
	IF gap = 1 THEN
	    EXIT SUB
	ELSE
	    gap = INT(gap / 4) + 1
	END IF
    LOOP
END SUB

