/*
   CXSUB interface.
   Copyright (c) 1990-1994 Eugene Nelson, Four Lakes Computing.
*/

#ifndef _CXSUB_
#define _CXSUB_
/*-------------------------------------------------------------------------*/
#include "cx.h"

#ifdef __cplusplus
extern "C" {
#endif

#define CXSUB_ERR_OPENS       (1)
#define CXSUB_ERR_OPEND       (2)
#define CXSUB_ERR_NOMEM       (3)
#define CXSUB_ERR_READ        (4)
#define CXSUB_ERR_WRITE       (5)
#define CXSUB_ERR_CLOSE       (6)
#define CXSUB_ERR_INVALID     (7)

char  *cx_error_message(
         CXINT err);

CXINT cx_compress_ofile(
         int   ofile,
         int   ifile,
         CXINT method,
         CXINT bsize,
         CXINT tsize,
         int   (*callback)(void *),
         void  *p);

CXINT cx_compress_file(
         char  *dst,
         char  *src,
         CXINT method,
         CXINT bsize,
         CXINT tsize,
         int   (*callback)(void *),
         void  *p);

CXINT cx_decompress_ofile(
         int   ofile,
         int   ifile,
         int   (*callback)(void *),
         void  *p);

CXINT cx_decompress_file(
         char  *dst,
         char  *src,
         int   (*callback)(void *),
         void  *p);

#ifdef __cplusplus
}
#endif

/*-------------------------------------------------------------------------*/
#endif

