*$Header:$
*----------------------------------------------------------------------------
*   Name    :   cvrdemo2.prg
*   Purpose :   coverage analysis demo 
*   Usage   :   see Installation Checksheet
*   Created :   03-22-1994
*   Notes   :   
*----------------------------------------------------------------------------
FUNC CVR2()
    ? PROCNAME()        // This routine gets called once, 1 hit per...
    ? PROCLINE()
    CVR3()
RETURN( 0 )

FUNC CVR3()                     // this function's called twice
    LOCAL   iCtr,           ;   // 0 hits, no assignment, no actual code...
            cString := ""       // 2 hits, once per invocation

    FOR iCtr := 1 to 100        // 2 hits, once on each entry into the
                                // loop
        cString += " "          // 200 hits, 2 calls @ 100 each
        cString += " "          // 200 hits, 2 calls @ 100 each
                                // 
    NEXT                        // NEXT lines don't show any hits since 
                                // Clipper never actually 'executes' them.  
                                // Think of them more as syntatical place 
                                // holders...      

    IF .F.                      // This can't be true but it's tested
       ? "HI FROM FALSE"        // no hits
    ELSE                        // no hits, just a place holder
       ? "HI FROM TRUE"         // 2 hits, 2 calls
    ENDIF                       // no hits, just a place holder

    IF .T.                      // This better be true!
       ? "HI FROM TRUE"         // 2 hits, one each call
    ELSE                        // no hits, just a place holder
       ? "HI FROM FALSE"        // no hits
    ENDIF                       // no hits, just a place holder

    ? PROCNAME()                // these lines hit once each time through
    ? PROCLINE()

    DO CASE
        CASE 1==1               // This'll get hit 
            ? "1 == 1"
        CASE 2 != 2             // but none of this will...
            ? "2 != 2"
        OTHERWISE
            ? "OTHERWISE"
    ENDCASE 

RETURN( 0 )

*----------------------------------------------------------------------------
*                                 cvrdemo2.prg
*----------------------------------------------------------------------------
