; ROUGHEN.LSP: Routine to "roughen" a polyline              15 May 93
; copyright 1993 by Mark Middlebrook / Daedalus Consulting

(defun C:ROUGHEN (/ basicziglen roughness en etype en1 en2 vtx1 vtx2
                    seglen segang inclen zignum ziglen zigdist
                    wanderdist wanderang newvtx seed)

   ;set desired length and roughness of "zigzags" here:  
   (setq basicziglen (* 0.05 (getvar "DIMSCALE"))  ;larger is longer
         roughness 0.25                            ;larger is rougher
   )

   (setq ocmd (getvar "CMDECHO"))
   (setvar "CMDECHO" 0)

   (setq en (car (entsel "\nSelect a Polyline or Line: "))
         etype (cdr (assoc 0 (entget en)))
   )

   (cond
      ((equal etype "LINE")                     ;is entity a Line?
         (command "._PEDIT" en "_Yes" "_eXit")  ;make it a Pline
         (setq en (entlast)                     ;reset en
               etype (cdr (assoc 0 (entget en)))
         )
      )
   )

   (cond
      ((equal etype "POLYLINE")                 ;is entity a Pline?
         (setq en1 (entnext en)                    ;first vertex
               en2 (entnext en1)                   ;second vertex
         )
         (command "._PEDIT" en "_Edit")            ;edit vertex

         (while (/= "SEQEND" (cdr (assoc 0 (entget en2))))
            (setq vtx1 (cdr (assoc 10 (entget en1)))
                  vtx2 (cdr (assoc 10 (entget en2)))
                  seglen (distance vtx1 vtx2)
                  segang (angle vtx1 vtx2)
                  zignum (fix (/ seglen basicziglen)) ;# of "zigzags"...
                  zignum (max zignum 2)               ; but not less than 2
                  ziglen (/ seglen zignum)            ;zigzag length
                  zigdist ziglen
                  i 2
            )

            (repeat (1- zignum)
               (setq newvtx (polar vtx1 segang zigdist)  ;vertex init. loc.
                     wanderdist (* roughness (randnum))
                     wanderang (if (= (rem i 2) 1)       ;wander back & forth
                                    (+ segang (/ pi 4))
                                    (- segang (/ pi 4))
                               );if
               );setq
               (command "_Insert" newvtx "_Next"
                        "_Move" (polar newvtx wanderang wanderdist))
               (setq zigdist (+ ziglen zigdist)
                     i (1+ i)
               )
            );repeat

            (command "_Next")
            (setq en1 en2
                  en2 (entnext en1)
            )
         );while

         (command "_eXit" "_eXit")     ;exit PEDIT
      );entity is a Pline

      (T (prompt "\nEntity is not a Polyline or Line."))
   );cond

   (setvar "CMDECHO" ocmd)
   (princ)
);defun

;Random number generation function - based on the linear
; congruential method as presented in Doug Cooper's book
; Condensed Pascal, pp. 116-117.
; Returns a random number between 0 and 1.
(defun randnum ()
   (if (not seed) (setq seed (getvar "DATE")))
   (setq modulus 65536
         multiplier 25173
         increment 13849
         seed (rem (+ (* multiplier seed) increment) modulus)
         random (/ seed modulus)
   )
)

(prompt "\nROUGHEN loaded.  Type ROUGHEN to run it.")
(princ)
