; **********************************************************
; TASKMAN.LSP
; Tasks Manager Program
; Copyright (c) Barry R. Bowen 1993
; ----------------------------------------------------------
; Variables:
; ANS    = Variable used for questions
; DCL_ID = Dialog box ID number
; DTE    = Variable for date section
; FILE   = TASKS.DCL file
; FILE1  = Specific task file for editing
; IN     = Index counter
; LBL    = Dialog box heading label
; LEN    = Length of string
; LINE   = Text string read/write to file
; NOTE   = String for note section of dialog box
; PRO    = String for priority section
; REM    = Remainder of string length
; TOG    = Toggle status
; ----------------------------------------------------------

(defun C:TASKMAN (/ ANS DCL_ID DTE FILE FILE1 IN LBL LEN
                    LINE NOTE PRO REM TOG OLD_CMD OLD_ERROR)
  (defun WLF (LINE) (write-line LINE FILE))
  (setq OLD_CMD (getvar "cmdecho")
        OLD_ERROR *error*
        *error* ai_error
  )
  (setvar "cmdecho" 0)
  (initget 1 "C T M R")
  (setq ANS (getkword "\nCalls/Tasks/Master/Redick: "))
  (cond
    ((= ANS "C") (setq LBL "DAILY CALLS")
                 (setq FILE1 "DCALLS.TSK"))
    ((= ANS "T") (setq LBL "DAILY TASKS")
                 (setq FILE1 "DTASKS.TSK"))
    ((= ANS "M") (setq LBL "MASTER TASKS")
                 (setq FILE1 "MTASKS.TSK"))
    ((= ANS "R") (setq LBL "REDICHECK LIST")
          (setq FILE1 (strcat (getvar "dwgname") ".TSK")))
  )
  (setq FILE (open "TASKS.DCL" "w"))
  (WLF "TASKS : dialog {")
  (WLF (strcat "label = " (chr 34) LBL (chr 34) ";"))
  (WLF ": column {")
  (setq IN 1)
  (repeat 5
    (WLF ": row {")
    (WLF (strcat ":toggle {key = " (chr 34) "t"
                   (itoa IN) (chr 34) ";}"))
    (WLF (strcat ":edit_box {key = " (chr 34) "p"
                   (itoa IN) (chr 34) ";
                   edit_width = 2;}"))
    (WLF (strcat ":edit_box {key = " (chr 34) "n"
                   (itoa IN) (chr 34) ";
                   edit_width = 45;}"))
    (WLF (strcat ":edit_box {key = " (chr 34) "d"
                   (itoa IN) (chr 34) ";
                   edit_width = 8;}"))
    (WLF "}")
    (setq IN (1+ IN))
  )
  (WLF "} spacer_1; ok_cancel; }")
  (close FILE)
  (setq DCL_ID (load_dialog "TASKS"))
  (new_dialog "TASKS" DCL_ID)
  (if (/= (findfile FILE1) nil) (progn
    (setq FILE (open FILE1 "r")
          IN 1
          LINE (read-line FILE))
    (while LINE
      (setq TOG (substr LINE 1 1))
      (set_tile (strcat "t" (itoa IN)) TOG)
      (set_tile (strcat "p" (itoa IN)) (substr LINE 2 2))
      (set_tile (strcat "n" (itoa IN)) (substr LINE 4 45))
      (set_tile (strcat "d" (itoa IN)) (substr LINE 49))
      (setq IN (1+ IN)
            LINE (read-line FILE))
    )
    (close FILE)
  ))
  (action_tile "accept" "(do_task)")
  (action_tile "cancel" "(done_dialog)")
  (start_dialog)
  (setq *error* OLD_ERROR)
  (setvar "cmdecho" OLD_CMD)
  (unload_dialog DCL_ID)
  (princ)
)

(defun DO_TASK ()
  (setq FILE (open FILE1 "w") IN 1)
  (repeat 5
   (setq TOG (get_tile (strcat "t" (itoa IN)))
         PRO (get_tile (strcat "p" (itoa IN))))
   (if (= PRO "") (setq PRO "  "))
   (setq NOTE (get_tile (strcat "n" (itoa IN)))
         DTE (get_tile (strcat "d" (itoa IN)))
         LEN (strlen NOTE))
   (if (< LEN 45)
     (progn
       (setq REM (- 45 LEN))
       (repeat REM
         (setq NOTE (strcat NOTE " "))
   ) ) )
   (WLF (strcat TOG PRO NOTE DTE))
   (setq IN (1+ IN))
  )
  (close FILE)
  (done_dialog dcl_id)
)

(prompt "\nTaskManger Loaded..Type TASKMAN at Command prompt!")
(princ)

