; TIP938C.LSP: RADI.LSP    Dimensioning Circles and Arcs
;                          (c)1993, Ken Leseberg

; Program used to add a radius dimension to an arc or circle.
; The arrow head and an internal line are inside the circle.

(defun C:RADI (/ pk p1a p1 p2 p4 pt7 p9 ngl mngl rrad str dst lcr loc tmco ht ccol tortho pkk)
   (setq tmco (getvar "cmdecho"))
   (setq ccol (getvar "cecolor"))
   (setq tortho (getvar "orthomode"))
   (command "color" "green")
   (setvar "cmdecho" 0)
   (setvar "orthomode" 0)
   (setq pkk (entsel "\nSelect arc or circle: ")
      pk (car (cdr pkk))
      p1a (osnap pk "nea")
      p2 (osnap p1a "cen")
      p7 (getpoint p2 "\nPick leader point: ")
      rrad (distance p1a p2)
      ngl (angle p7 p2)
      mngl (+ pi ngl)
      p1 (polar p2 mngl rrad)
      p4 (polar p1 ngl (* 0.18 (getvar "dimscale")))
   zw (* 0.06 (getvar "dimscale")))
   (grdraw p2 p7 -1)
   (setvar "ORTHOMODE" 1)
   (setq p9 (getpoint p7 "\nPick point to finish leader: "))
   (grdraw p2 p7 -1)
   (command "pline" p2 "w" 0 0 p4 "w" zw 0 p1 p7 p9 "")
   (command "color" "11")
   (setq str (strcat "R" (rtos (* (getvar "dimlfac") (distance p1 p2))))
      dst (* 1.0 (getvar "dimtxt") (getvar "dimscale"))
      ht (* (getvar "dimtxt") (getvar "dimscale"))
      lcr (polar p9 PI dst)
   loc (polar p9 0.0 dst))
   (if (< (car p9) (car p7))
      (command "text" "j" "mr" lcr ht 0 str)
      (command "text" "j" "ml" loc ht 0 str)
   )
   (setvar "ORTHOMODE" tortho)
   (setvar "cmdecho" tmco)
   (command "color" ccol)
   (prin1)
); end radi.lsp
