; TIP934.LSP: MULTIBUB.LSP    Multiple Bubbles   (c)1993, Andrew C. Clarey

; MULTIBUB.lsp Will insert BOM bubbles at the end of a leader line.
; You first choose the destination layer for the BOM bubbles.  Then you
; choose the start point and the end point of the leader line.  Now you 
; enter the BOM bubble text (up to 2 characters).  At this point you can
; type <Q> to quit or you can press <Enter> to continue inserting BOM
; bubbles.  The number of BOM bubbles inserted is determined by the user.
; The size of the BOM bubble's are determined by referencing the DIMTXT
; variable.

(defun c:multibub ( / CMD O Q LAY LAY1 PT1 PT2 ANGG P C T TXT A)
   (setq CMD(getvar "CMDECHO"))
   (setq O(getvar "ORTHOMODE"))    
   (setvar "ORTHOMODE" 0)
   (setvar "CMDECHO" 0)   
   (setq Q 1)
   (setq LAY(getvar "CLAYER"))
   (setq LAY1(getstring "\nEnter Destination Layer of Bubble: "))
   (setq PT1 (getpoint "\nLeader Start Point: "))
   (setq PT2 (getpoint "\nBubble Centerpoint: " PT1))
   (setq ANGG(angle PT1 PT2))
   (setq P (* (getvar "DIMTXT") 10.0))
   (setq C (* p 0.125))
   (setq T (* p 0.1))
   (command "LAYER" "S" LAY1 "")
   (command "CIRCLE" PT2 C)
   (command "SELECT" "L" "")
   (command "LINE" PT1 PT2 "")
   (command "TRIM" "P" "" PT2 "")
   (setq TXT (getstring "Bubble text: "))
   (command "TEXT" "S" "STANDARD" "M" PT2 T 0 TXT)
   (setq A(getstring "\nEnter to continue or <Q> to Quit "))
   (if(or (= A "q")(= A "Q"))(setq Q nil))   
      (if(and(< ANGG 4.712)(> ANGG 1.5707))
         (while Q
            (setq PT11(list(- (abs(car PT2))(* 2 c))(cadr PT2)))  
            (command "CIRCLE" PT11 C)
            (setq TXT(getstring "Bubble text: "))
            (command "TEXT" "S" "STANDARD" "M" PT11 T 0 TXT)
            (setq PT2 PT11) 
            (setq A(getstring "\nEnter to continue or <Q> to Quit "))
            (if(=(strcase A)"Q")(setq Q nil))
        )
     )
         (while Q
            (setq PT11(list(+ (abs(car PT2))(* 2 c))(cadr PT2)))
            (command "CIRCLE" PT11 C)
            (setq TXT(getstring "Bubble Text: "))
            (command "TEXT" "S" "STANDARD" "M" PT11 T 0 TXT)
            (setq PT2 PT11)
            (setq A(getstring "\nEnter to Continue or <Q> to Quit "))
            (if(=(strcase A)"Q")(setq Q nil))
        )
   (command "LAYER" "S" LAY "")
   (setvar "CMDECHO" CMD)
   (setvar "ORTHOMODE" O)
   (princ)
)
