; TIP933.LSP: LOG.LSP    Operator Log   (c)1993, David Doler

; Drawing Activity Operator/Date/Time Logger
; Creates a text record of operator name, date and time activity.
; The name of the text file is the same as the drawing name with
; a .LOG as the file type. The date format is in MONTH/DAY/YEAR
;

(defun C:LOG (/ f_name op_name up_date j_date hour min) 
   (setq f_name (open (strcat (getvar "dwgname") ".log") "a") 
      op_name (strcat (getstring "Enter Operator Name: ") " ") 
      up_date (c_date (getvar "tdupdate")) 
   j_date (getvar "date"))
   (setq hour (* 24.0 (- j_date (fix j_date))) 
      min (* 60.0 (- hour (fix hour))) 
      hour (itoa (fix hour)) 
   min (fix min))
   (if (< min 10) 
      (setq min (strcat "0" (itoa min)))
      (setq min (itoa min))
   ) 
   (princ (strcat "\n" op_name) f_name)
   (princ (strcat "\t\t" up_date) f_name) 
   (princ (strcat "\t" hour) f_name) 
   (princ (strcat ":" min) f_name) 
   (close f_name)
) 
(print) 
;;;   Algorithms are from collection from Communications of the ACM
;;;   Original AutoLISP from AutoDesk examples on Compuserve
(defun c_date (j / y d m) 
   (setq j (fix j) 
      j (- j 1721119.0) 
      y (fix (/ (1- (* 4 j)) 146097.0)) 
      j (- (* j 4.0) 1.0 (* 146097.0 y)) 
      d (fix (/ j 4.0)) 
      j (fix (/ (+ (* 4.0 d) 3.0) 1461.0)) 
      d (- (+ (* 4.0 d) 3.0) (* 1461.0 j)) 
      d (fix (/ (+ d 4.0) 4.0)) 
      m (fix (/ (- (* 5.0 d) 3) 153.0)) 
      d (- (* 5.0 d) 3.0 (* 153.0 m)) 
      d (fix (/ (+ d 5.0) 5.0)) 
   y (+ (* 100.0 y) j))
   (if (< m 10.0) 
      (setq m (+ m 3))
      (setq m (- m 9) 
      y (1+ y))
   ) 
   (strcat (nth (1- (fix m)) 
         (list "01" "02" "03" "04" "05" "06" 
         "07" "08" "09" "10" "11" "12")
      ) "/" 
      (if (< D 10) "0" "") 
      (itoa (fix D)) "/" 
      (substr (itoa (fix Y)) 3 2)
   )
)
(princ); end log.lsp
